/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.bshsupport.checks;

import bsh.ParseException;
import bsh.Parser;
import bsh.TokenMgrError;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.configuration.Configuration;

public class BSHActivityCheck
extends AbstractExecutableComponentCheck {
    private static final String CHECK_ID = "BSHActivityCheck";

    public BSHActivityCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super(CHECK_ID, "de.aristaflow.tools.BSH");
    }

    public BSHActivityCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    public void performCheckSpi(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        String script = conf.getString("Script");
        if (script == null || script.equals("")) {
            String msg = String.format("The script parameter must be set", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        } else {
            String msg;
            Parser parser = new Parser((Reader)new StringReader(script));
            try {
                while (!parser.Line()) {
                    parser.popNode();
                }
            }
            catch (ParseException ex) {
                msg = String.format("The script has syntax errors: " + ex.getMessage(), new Object[0]);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
            catch (TokenMgrError er) {
                msg = String.format("The script leads to an error in the parser: " + er.getMessage(), new Object[0]);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        }
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            for (Parameter parameter : activity.getParameters(accessType)) {
                ActivityConfiguration patc = parameter.getConfiguration();
                if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    String msg;
                    String udtType = patc.getString("UDTType");
                    if (udtType == null || udtType.equals("")) {
                        msg = String.format("The UDT type of parameter '%s' must be set", parameter.getName());
                        this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                    } else if (!(udtType.equals("JavaObject") || udtType.equals("Stream") || udtType.equals("String"))) {
                        msg = String.format("The UDT type of parameter '%s' is set to an unknown value ('%s').", parameter.getName(), udtType);
                        this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                    }
                }
                if (!parameter.getName().equals("return") || accessType != ActivityConstants.AccessType.READ) continue;
                String msg = String.format("The name '%s' is reserved for theoutput parameter for the return value.", "return");
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
            ++n2;
        }
    }
}

