/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.bshsupport.environments;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.util.FileTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;

public class BSHEnvironment
extends ExecutionEnvironment {
    private static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType;

    public BSHEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        i = new Interpreter();
        i.setClassLoader(this.getClass().getClassLoader());
        i.setExitOnEOF(false);
        i.setStrictJava(false);
        i.setShowResults(false);
        try {
            i.set("activityInstance", (Object)this.activityInstance);
            i.set("sessionContext", (Object)this.sessionContext);
        }
        catch (EvalError ee) {
            msg = String.format("Failed setting parameter activityInstance / sessionContext.", new Object[0]);
            throw new ApplicationFailedException(msg, "AristaFlow:BSHEnvironment:EvalError", 768L, ee);
        }
        script = this.activityInstance.getConfiguration().getString("Script");
        dataContext = this.sessionContext.getDataContext();
        for (ProcessModelParameter parameter : this.activityInstance.getParameters(ActivityConstants.AccessType.READ)) {
            parameterName = parameter.getName();
            parameterType = parameter.getDataType();
            try {
                if (dataContext.isNull(parameterName)) {
                    i.set(parameterName, null);
                    continue;
                }
                switch (BSHEnvironment.$SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType()[parameterType.ordinal()]) {
                    case 4: {
                        b = dataContext.retrieveBooleanParameterValue(parameterName);
                        i.set(parameterName, b);
                        break;
                    }
                    case 5: {
                        da = dataContext.retrieveDateParameterValue(parameterName);
                        i.set(parameterName, (Object)da);
                        break;
                    }
                    case 2: {
                        d = dataContext.retrieveFloatParameterValue(parameterName);
                        i.set(parameterName, d);
                        break;
                    }
                    case 1: {
                        l = dataContext.retrieveIntegerParameterValue(parameterName);
                        i.set(parameterName, l);
                        break;
                    }
                    case 3: {
                        string = dataContext.retrieveStringParameterValue(parameterName);
                        i.set(parameterName, (Object)string);
                        break;
                    }
                    case 6: {
                        uri = dataContext.retrieveURIParameterValue(parameterName);
                        i.set(parameterName, (Object)uri);
                        break;
                    }
                    case 7: {
                        value = dataContext.retrieveUDTParameterValue(parameterName);
                        udtType = parameter.getConfiguration().getString("UDTType");
                        if (udtType == null) {
                            msg = String.format("UDT type of parameter '%s' is null.", new Object[]{parameterName});
                            throw new ApplicationEnvironmentException(msg, 0L);
                        }
                        if (!udtType.equals("JavaObject")) ** GOTO lbl56
                        o = this.userdefinedToNativeTypedValue(value, parameter, false);
                        ** GOTO lbl87
lbl56:
                        // 1 sources

                        if (!udtType.equals("Stream")) ** GOTO lbl59
                        o = value.getValueAsStream();
                        ** GOTO lbl87
lbl59:
                        // 1 sources

                        if (!udtType.equals("String")) ** GOTO lbl85
                        udtString = new StringBuilder();
                        reader = null;
                        try {
                            try {
                                reader = new BufferedReader(new InputStreamReader(value.getValueAsStream(), "UTF-8"));
                                s = reader.readLine();
                                while (s != null) {
                                    udtString.append(s);
                                    s = reader.readLine();
                                }
                                reader.close();
                            }
                            catch (UnsupportedEncodingException ex) {
                                msg = "UTF-8 encoding is required but not available on this system!";
                                throw new ApplicationEnvironmentException(msg, 1L, ex);
                            }
                            catch (IOException e) {
                                msg = String.format("Could not transform UDT '%s' (%s) into a string.", new Object[]{parameterName, value.getUserDefinedType()});
                                throw new ApplicationEnvironmentException(msg, 0L, e);
                            }
                        }
                        catch (Throwable var23_40) {
                            FileTools.closeQuietly(reader);
                            throw var23_40;
                        }
                        FileTools.closeQuietly(reader);
                        o = udtString.toString();
                        ** GOTO lbl87
lbl85:
                        // 1 sources

                        msg = String.format("Unknown UDT type '%s' found in parameter '%s'.", new Object[]{udtType, parameterName});
                        throw new ApplicationEnvironmentException(msg, 0L);
lbl87:
                        // 3 sources

                        i.set(parameterName, o);
                        break;
                    }
                    default: {
                        msg = String.format("Unknown data type '%s', ignoring parameter '%s', continuing with an Object.", new Object[]{parameterType, parameterName});
                        this.logger.severe(msg);
                        i.set(parameterName, new Object());
                        break;
                    }
                }
            }
            catch (InvalidDataTypeException e) {
                msg = String.format("Invalid Data type for parameter '%s', expected type '%s'.", new Object[]{parameterName, parameterType});
                this.logger.log(Level.SEVERE, msg, e);
                throw new ApplicationEnvironmentException(msg, 1100004L, e);
            }
            catch (NoSuchParameterException e) {
                msg = String.format("No such input parameter '%s'.", new Object[]{parameterName});
                this.logger.log(Level.SEVERE, msg, e);
                throw new ApplicationEnvironmentException(msg, -401000L, e);
            }
            catch (EvalError ee) {
                msg = String.format("Failed setting parameter '%s'.", new Object[]{parameterName});
                throw new ApplicationFailedException(msg, "AristaFlow:BSHEnvironment:EvalError", 768L, ee);
            }
        }
        try {
            ret = i.eval(script);
        }
        catch (ParseException pe) {
            msg = "Parsing the BSH script for activity '%s' failed: %s\nScript: '%s'";
            msg = String.format(msg, new Object[]{this.activityInstance.getActivityName(), pe.getMessage(), pe.getErrorSourceFile()});
            throw new ApplicationFailedException(msg, "AristaFlow:BSHEnvironment:ParseException", 256L, pe);
        }
        catch (TargetError te) {
            msg = "A target error occured while evaluating the BSH script for activity '%s'. Line %s in script, stack trace:\n%s";
            msg = String.format(msg, new Object[]{this.activityInstance.getActivityName(), te.getErrorLineNumber(), te.getScriptStackTrace()});
            thrw = te.getTarget();
            if (thrw instanceof ApplicationFailedException) {
                throw (ApplicationFailedException)thrw;
            }
            if (thrw instanceof ApplicationEnvironmentException) {
                throw (ApplicationEnvironmentException)thrw;
            }
            throw new ApplicationFailedException(msg, "AristaFlow:BSHEnvironment:TargetError", 512L, thrw);
        }
        catch (EvalError ee) {
            msg = String.format("Failed to eval the script:\n\n%s", new Object[]{script});
            throw new ApplicationFailedException(msg, "AristaFlow:BSHEnvironment:EvalError", 768L, ee);
        }
        for (ProcessModelParameter parameter : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
            parameterName = parameter.getName();
            parameterType = parameter.getDataType();
            try {
                o = parameterName.equals("return") != false ? ret : i.get(parameterName);
                if (o == null) {
                    dataContext.ignoreValue(parameterName);
                    continue;
                }
                switch (BSHEnvironment.$SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType()[parameterType.ordinal()]) {
                    case 4: {
                        b = (Boolean)o;
                        dataContext.storeBooleanParameterValue(parameterName, b);
                        break;
                    }
                    case 5: {
                        da = o instanceof Long != false ? new Date((Long)o) : (o instanceof Calendar != false ? ((Calendar)o).getTime() : (Date)o);
                        dataContext.storeDateParameterValue(parameterName, da);
                        break;
                    }
                    case 2: {
                        d = o instanceof Double != false ? ((Double)o).doubleValue() : ((Float)o).doubleValue();
                        dataContext.storeFloatParameterValue(parameterName, d);
                        break;
                    }
                    case 1: {
                        l = o instanceof Long != false ? ((Long)o).longValue() : ((Integer)o).longValue();
                        dataContext.storeIntegerParameterValue(parameterName, l);
                        break;
                    }
                    case 3: {
                        s = o.toString();
                        dataContext.storeStringParameterValue(parameterName, s);
                        break;
                    }
                    case 6: {
                        uri = (URI)o;
                        dataContext.storeURIParameterValue(parameterName, uri);
                        break;
                    }
                    case 7: {
                        udtType = parameter.getConfiguration().getString("UDTType");
                        if (udtType == null) {
                            msg = String.format("UDT type of parameter '%s' is null.", new Object[]{parameterName});
                            throw new ApplicationEnvironmentException(msg, 0L);
                        }
                        if (udtType.equals("JavaObject")) {
                            value = this.objectToUserdefined(o, parameter, true);
                        } else if (udtType.equals("Stream")) {
                            value = new ADEPT2UDTValue(parameter.getUDTName(), (InputStream)o);
                        } else if (udtType.equals("String")) {
                            try {
                                (String)o;
                                value = new ADEPT2UDTValue(parameter.getUDTName(), ((String)o).getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException ex) {
                                msg = "UTF-8 encoding is required but not available on this system!";
                                throw new ApplicationEnvironmentException(msg, 1L, ex);
                            }
                        } else {
                            msg = String.format("Unknown UDT type '%s' found in parameter '%s'.", new Object[]{udtType, parameterName});
                            throw new ApplicationEnvironmentException(msg, 0L);
                        }
                        dataContext.storeUDTParameterValue(parameterName, value);
                        break;
                    }
                    default: {
                        msg = String.format("Unknown data type '%s', ignoring parameter '%s', continuing with an Object.", new Object[]{parameterType, parameterName});
                        this.logger.severe(msg);
                        i.set(parameterName, new Object());
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                throw e;
            }
            catch (InvalidDataTypeException e) {
                msg = String.format("Invalid Data type for parameter '%s', expected type '%s'.", new Object[]{parameterName, parameterType});
                this.logger.log(Level.SEVERE, msg, e);
                throw new ApplicationEnvironmentException(msg, 1100004L, e);
            }
            catch (NoSuchParameterException e) {
                msg = String.format("No such input parameter '%s'.", new Object[]{parameterName});
                this.logger.log(Level.SEVERE, msg, e);
                throw new ApplicationEnvironmentException(msg, -401000L, e);
            }
            catch (EvalError ee) {
                msg = String.format("Failed getting parameter '%s'.", new Object[]{parameterName});
                throw new ApplicationFailedException(msg, "AristaFlow:BSHEnvironment:EvalError", 768L, ee);
            }
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType() {
        if ($SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType != null) {
            return $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType;
        }
        int[] nArray = new int[ProcessConstants.AdeptDataType.values().length];
        try {
            nArray[ProcessConstants.AdeptDataType.BOOLEAN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ProcessConstants.AdeptDataType.DATE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ProcessConstants.AdeptDataType.FLOAT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ProcessConstants.AdeptDataType.INTEGER.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ProcessConstants.AdeptDataType.STRING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ProcessConstants.AdeptDataType.URI.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ProcessConstants.AdeptDataType.USERDEFINED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType = nArray;
        return nArray;
    }
}

