/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.datatypes;

import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUDT
implements Serializable {
    private static final long serialVersionUID = 4166159344489422431L;
    private static final String XML_DATA = "data";
    private static final String XML_FILENAME = "filename";
    private static final String XML_ENCODING = "encoding";
    private static final String XML_MIMETYPE = "mimetype";
    private static final String XML_SIZE = "size";
    byte[] data;
    String filename;
    String encoding;
    String mimetype;
    long size;

    public FileUDT(File file) {
        this(file, file.getName());
    }

    public FileUDT(File file, String newFileName) {
        if (!file.exists()) {
            String msg = String.format("The file '%s' does not exist!", file);
            throw new RuntimeException(msg);
        }
        if (file.isDirectory()) {
            String msg = String.format("'%s' is a directory, which is not supported!", file);
            throw new RuntimeException(msg);
        }
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(file);
                int available = ((InputStream)is).available();
                this.data = new byte[available];
                int read = ((InputStream)is).read(this.data);
                if (available != read) {
                    LoggerTools.getLogger(this).severe("Read more from the input stream than available!");
                }
                ((InputStream)is).close();
                this.filename = newFileName;
                URLConnection con = file.toURL().openConnection();
                this.encoding = con.getContentEncoding();
                this.mimetype = con.getContentType();
                this.size = file.length();
            }
            catch (IOException e) {
                String msg = String.format("An IOException occurred while trying to initialise a FileUDT from the file '%s'.", file);
                throw new RuntimeException(msg, e);
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    String msg = "An IOException occurred while trying to close a file input stream.";
                    throw new RuntimeException(msg, e);
                }
            }
        }
    }

    public FileUDT(UDTValue xml) {
        try {
            Document doc = XMLHelperTools.getDocumentFromStream(xml.getValueAsStream());
            Element file = doc.getDocumentElement();
            this.filename = file.getAttribute(XML_FILENAME);
            this.encoding = file.getAttribute(XML_ENCODING);
            this.mimetype = file.getAttribute(XML_MIMETYPE);
            this.size = Long.valueOf(file.getAttribute(XML_SIZE));
            Element data = XMLHelperTools.getElement(file.getFirstChild());
            this.data = Base64.decode(data.getTextContent());
        }
        catch (XMLFormatException e) {
            String msg = String.format("A XMLFormatException occurred while trying to initialise a FileUDT from a xml UDTValue.", new Object[0]);
            throw new RuntimeException(msg, e);
        }
        catch (IOException e) {
            String msg = String.format("An IOException occurred while trying to initialise a FileUDT from a xml UDTValue.", new Object[0]);
            throw new RuntimeException(msg, e);
        }
    }

    public FileUDT(byte[] data, String filename, String encoding, String mimetype, long size) {
        ArgChecks.checkForNull(data, XML_DATA);
        ArgChecks.checkForNull(filename, XML_FILENAME);
        this.data = (byte[])data.clone();
        this.filename = filename;
        this.encoding = encoding;
        this.mimetype = mimetype;
        this.size = size;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public String getFileName() {
        return this.filename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public long getSize() {
        return this.size;
    }

    public String getSizeString() {
        long size = this.getSize();
        StringBuilder ret = new StringBuilder();
        if (size > 0L) {
            if (size < 2048L) {
                ret.append(" Bytes of Data");
            } else if ((size /= 1024L) < 2048L) {
                ret.append(" KB of Data");
            } else {
                size /= 1024L;
                ret.append(" MB of Data");
            }
        }
        ret.insert(0, size);
        return ret.toString();
    }

    public UDTValue getAsXML() {
        Document doc = XMLHelperTools.createDocument();
        Element file = doc.createElement("fileUDT");
        file.setAttributeNS(null, XML_FILENAME, this.filename);
        file.setAttributeNS(null, XML_ENCODING, this.encoding);
        file.setAttributeNS(null, XML_MIMETYPE, this.mimetype);
        file.setAttributeNS(null, XML_SIZE, Long.toString(this.size));
        Element fileData = doc.createElement(XML_DATA);
        fileData.setTextContent(Base64.encodeBytes(this.data));
        file.appendChild(fileData);
        doc.appendChild(file);
        try {
            return new ADEPT2UDTValue("File", XMLHelperTools.getByteArrayForDocument(doc));
        }
        catch (IOException e) {
            String msg = String.format("An IOException occurred while trying to write a FileUDT to a xml UDTValue.", new Object[0]);
            throw new RuntimeException(msg, e);
        }
    }
}

