/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.datatypes;

import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WJPContainer {
    public static final String UDT_NAME = "container";
    private static boolean schemaInitialised = false;
    private static Schema schema;
    private String containerId;
    private String containerName;
    private String containerDescription;
    private Map<String, Field> fields = new LinkedHashMap<String, Field>();

    public void loadFromUDTValue(UDTValue udtValue) throws IOException, XMLFormatException {
        if (!udtValue.getUserDefinedType().equals(UDT_NAME)) {
            throw new XMLFormatException("the UDT type must be 'container'");
        }
        this.loadFromStream(udtValue.getValueAsStream());
    }

    public void loadFromStream(InputStream in) throws IOException, XMLFormatException {
        this.containerId = null;
        this.containerName = null;
        this.containerDescription = null;
        this.fields.clear();
        Document doc = XMLHelperTools.getDocumentFromStream(in, WJPContainer.getXMLSchema(), null, false);
        Element containerElem = doc.getDocumentElement();
        if (containerElem.hasAttribute("id")) {
            this.containerId = containerElem.getAttribute("id");
        }
        if (containerElem.hasAttribute("name")) {
            this.containerName = containerElem.getAttribute("name");
        }
        if (containerElem.hasAttribute("description")) {
            this.containerDescription = containerElem.getAttribute("description");
        }
        for (Element element : WJPContainer.getChildrenByTagName(doc.getDocumentElement(), "Element")) {
            ProcessConstants.AdeptDataType dataType;
            String name = element.getAttribute("name");
            if (element.hasAttribute("type")) {
                String typeString = element.getAttribute("type");
                dataType = ProcessConstants.AdeptDataType.valueOf(typeString);
            } else {
                dataType = ProcessConstants.AdeptDataType.STRING;
            }
            String valueString = element.getAttribute("value");
            Object value = WJPContainer.parseValue(valueString, dataType);
            this.fields.put(name, new Field(name, dataType, value));
        }
    }

    private static synchronized Schema getXMLSchema() {
        if (!schemaInitialised) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schema = schemaFactory.newSchema(WJPContainer.class.getResource("wjpcontainer.xsd"));
            }
            catch (SAXException ex) {
                String msg = "could not load the XML Schema for WJPContainer";
                LoggerTools.getLogger(WJPContainer.class).log(Level.WARNING, msg, ex);
            }
            schemaInitialised = true;
        }
        return schema;
    }

    static List<Element> getChildrenByTagName(Element parent, String tagName) {
        if (parent == null) {
            throw new IllegalArgumentException("The parameter 'parent' must not be null!");
        }
        ArrayList<Element> childElements = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node item = children.item(i);
            if (item.getNodeType() == 1 && item.getNodeName().equals(tagName)) {
                childElements.add((Element)item);
            }
            ++i;
        }
        return childElements;
    }

    public UDTValue saveToUDTValue() {
        try {
            return new ADEPT2UDTValue(UDT_NAME, XMLHelperTools.getByteArrayForDocument(this.createDoc()));
        }
        catch (IOException ex) {
            throw new RuntimeException("an unexpected error occurred", ex);
        }
    }

    public void saveToStream(OutputStream out) throws IOException {
        XMLHelperTools.writeDocumentToStream(this.createDoc(), out);
    }

    private Document createDoc() {
        Document doc = XMLHelperTools.createDocument();
        Element containerElem = doc.createElement("Container");
        doc.appendChild(containerElem);
        if (this.containerId != null) {
            containerElem.setAttribute("id", this.containerId);
        }
        if (this.containerName != null) {
            containerElem.setAttribute("name", this.containerName);
        }
        if (this.containerDescription != null) {
            containerElem.setAttribute("description", this.containerDescription);
        }
        for (Field field : this.fields.values()) {
            Element fieldElem = doc.createElement("Element");
            containerElem.appendChild(fieldElem);
            fieldElem.setAttribute("name", field.name);
            fieldElem.setAttribute("type", field.dataType.toString());
            String valueString = WJPContainer.formatValue(field.value, this.getDataType(field.name));
            if (valueString == null) continue;
            fieldElem.setAttribute("value", valueString);
        }
        return doc;
    }

    public String[] getFieldNames() {
        return ArrayTools.toArray(this.fields.keySet(), String.class);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public boolean hasField(String fieldName) {
        ArgChecks.checkForNull(fieldName, "fieldName");
        return this.fields.containsKey(fieldName);
    }

    public void addField(String fieldName, ProcessConstants.AdeptDataType dataType) {
        ArgChecks.checkForNull(fieldName, "fieldName");
        ArgChecks.checkForNull((Object)dataType, "dataType");
        if (this.fields.containsKey(fieldName)) {
            String msg = "field '%s' already exists";
            msg = String.format(msg, fieldName);
            throw new IllegalArgumentException(msg);
        }
        this.fields.put(fieldName, new Field(fieldName, dataType));
    }

    public void removeField(String fieldName) {
        ArgChecks.checkForNull(fieldName, "fieldName");
        Field field = this.fields.get(fieldName);
        if (field == null) {
            String msg = "unknown field '%s'";
            msg = String.format(msg, fieldName);
            throw new IllegalArgumentException(msg);
        }
        this.fields.remove(fieldName);
    }

    public ProcessConstants.AdeptDataType getDataType(String fieldName) {
        ArgChecks.checkForNull(fieldName, "fieldName");
        Field field = this.fields.get(fieldName);
        if (field == null) {
            String msg = "unknown field '%s'";
            msg = String.format(msg, fieldName);
            throw new IllegalArgumentException(msg);
        }
        return field.dataType;
    }

    public Object getValue(String fieldName) {
        ArgChecks.checkForNull(fieldName, "fieldName");
        Field field = this.fields.get(fieldName);
        if (field == null) {
            String msg = "unknown field '%s'";
            msg = String.format(msg, fieldName);
            throw new IllegalArgumentException(msg);
        }
        return field.value;
    }

    public void setValue(String fieldName, Object value) {
        ArgChecks.checkForNull(fieldName, "fieldName");
        Field field = this.fields.get(fieldName);
        if (field == null) {
            String msg = "unknown field '%s'";
            msg = String.format(msg, fieldName);
            throw new IllegalArgumentException(msg);
        }
        WJPContainer.checkValue(value, field.dataType);
        field.value = value;
    }

    static void checkValue(Object value, ProcessConstants.AdeptDataType dataType) {
        if (value != null) {
            try {
                switch (dataType) {
                    case BOOLEAN: {
                        Boolean.class.cast(value);
                        break;
                    }
                    case INTEGER: {
                        Long.class.cast(value);
                        break;
                    }
                    case FLOAT: {
                        Double.class.cast(value);
                        break;
                    }
                    case STRING: {
                        String.class.cast(value);
                        break;
                    }
                    case DATE: {
                        Date.class.cast(value);
                        break;
                    }
                    case URI: {
                        URI.class.cast(value);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported data type: " + (Object)((Object)dataType));
                    }
                }
            }
            catch (ClassCastException ex) {
                String msg = "value has wrong object value for data type of the field";
                throw new IllegalArgumentException(msg, ex);
            }
        }
    }

    static Object parseValue(String valueString, ProcessConstants.AdeptDataType dataType) {
        Object value;
        if (valueString.equals("")) {
            value = dataType == ProcessConstants.AdeptDataType.STRING ? "" : null;
        } else {
            switch (dataType) {
                case BOOLEAN: {
                    value = Boolean.parseBoolean(valueString);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(valueString);
                    break;
                }
                case FLOAT: {
                    value = Double.parseDouble(valueString);
                    break;
                }
                case STRING: {
                    value = valueString;
                    break;
                }
                case DATE: {
                    try {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        df.setTimeZone(TimeZone.getTimeZone("UTC"));
                        value = df.parse(valueString);
                        break;
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                case URI: {
                    value = URI.create(valueString);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported data type: " + (Object)((Object)dataType));
                }
            }
        }
        return value;
    }

    static String formatValue(Object value, ProcessConstants.AdeptDataType dataType) {
        String valueString;
        if (value == null) {
            valueString = null;
        } else {
            try {
                switch (dataType) {
                    case BOOLEAN: {
                        valueString = ((Boolean)value).toString();
                        break;
                    }
                    case INTEGER: {
                        valueString = ((Long)value).toString();
                        break;
                    }
                    case FLOAT: {
                        valueString = ((Double)value).toString();
                        break;
                    }
                    case STRING: {
                        valueString = (String)value;
                        break;
                    }
                    case DATE: {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        df.setTimeZone(TimeZone.getTimeZone("UTC"));
                        valueString = df.format((Date)value);
                        break;
                    }
                    case URI: {
                        valueString = ((URI)value).toString();
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported data type: " + (Object)((Object)dataType));
                    }
                }
            }
            catch (ClassCastException ex) {
                String msg = "value has wrong object value for data type of the field";
                throw new IllegalArgumentException(msg, ex);
            }
        }
        return valueString;
    }

    private static class Field {
        private final String name;
        private final ProcessConstants.AdeptDataType dataType;
        private Object value;

        private Field(String name, ProcessConstants.AdeptDataType dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        private Field(String name, ProcessConstants.AdeptDataType dataType, Object value) {
            this(name, dataType);
            this.value = value;
        }
    }
}

