/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.datatypes;

import de.aristaflow.adept2.extensions.datatypes.WJPContainer;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WJPSubtable {
    public static final String UDT_NAME = "subtable";
    private static boolean schemaInitialised = false;
    private static Schema schema;
    private String subtableName;
    private Map<String, ProcessConstants.AdeptDataType> columns = new LinkedHashMap<String, ProcessConstants.AdeptDataType>();
    private List<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();

    public void loadFromUDTValue(UDTValue udtValue) throws IOException, XMLFormatException {
        if (!udtValue.getUserDefinedType().equals(UDT_NAME)) {
            throw new XMLFormatException("the UDT type must be 'subtable'");
        }
        this.loadFromStream(udtValue.getValueAsStream());
    }

    public void loadFromStream(InputStream in) throws IOException, XMLFormatException {
        Element schemaElem;
        this.subtableName = null;
        this.columns.clear();
        this.rows.clear();
        Document doc = XMLHelperTools.getDocumentFromStream(in, WJPSubtable.getXMLSchema(), null, false);
        Element subtableElem = doc.getDocumentElement();
        if (subtableElem.hasAttribute("name")) {
            this.subtableName = subtableElem.getAttribute("name");
        }
        if ((schemaElem = WJPSubtable.getChildByTagName(doc.getDocumentElement(), "Schema")) != null) {
            for (Element columnElem : WJPContainer.getChildrenByTagName(schemaElem, "Column")) {
                ProcessConstants.AdeptDataType dataType;
                String name = columnElem.getAttribute("name");
                if (columnElem.hasAttribute("type")) {
                    String typeString = columnElem.getAttribute("type");
                    dataType = ProcessConstants.AdeptDataType.valueOf(typeString);
                } else {
                    dataType = ProcessConstants.AdeptDataType.STRING;
                }
                this.columns.put(name, dataType);
            }
        }
        for (Element rowElem : WJPContainer.getChildrenByTagName(doc.getDocumentElement(), "Row")) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (Element elemElem : WJPContainer.getChildrenByTagName(rowElem, "Element")) {
                String name = elemElem.getAttribute("name");
                String valueString = elemElem.getAttribute("value");
                ProcessConstants.AdeptDataType dataType = this.columns.get(name);
                Object value = WJPContainer.parseValue(valueString, dataType);
                row.put(name, value);
            }
            this.rows.add(row);
        }
    }

    private static synchronized Schema getXMLSchema() {
        if (!schemaInitialised) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schema = schemaFactory.newSchema(WJPSubtable.class.getResource("wjpsubtable.xsd"));
            }
            catch (SAXException ex) {
                String msg = "could not load the XML Schema for WJPSubtable";
                LoggerTools.getLogger(WJPSubtable.class).log(Level.WARNING, msg, ex);
            }
            schemaInitialised = true;
        }
        return schema;
    }

    private static Element getChildByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node item = children.item(i);
            if (item.getNodeType() == 1 && item.getNodeName().equals(tagName)) {
                return (Element)item;
            }
            ++i;
        }
        return null;
    }

    public UDTValue saveToUDTValue() {
        try {
            return new ADEPT2UDTValue(UDT_NAME, XMLHelperTools.getByteArrayForDocument(this.createDoc()));
        }
        catch (IOException ex) {
            throw new RuntimeException("an unexpected error occurred", ex);
        }
    }

    public void saveToStream(OutputStream out) throws IOException {
        XMLHelperTools.writeDocumentToStream(this.createDoc(), out);
    }

    private Document createDoc() {
        Document doc = XMLHelperTools.createDocument();
        Element subtableElem = doc.createElement("Subtable");
        doc.appendChild(subtableElem);
        if (this.subtableName != null) {
            subtableElem.setAttribute("name", this.subtableName);
        }
        if (this.columns.size() > 0) {
            Element schemaElem = doc.createElement("Schema");
            subtableElem.appendChild(schemaElem);
            for (Map.Entry entry : this.columns.entrySet()) {
                Element columnElem = doc.createElement("Column");
                schemaElem.appendChild(columnElem);
                columnElem.setAttribute("name", (String)entry.getKey());
                columnElem.setAttribute("type", ((ProcessConstants.AdeptDataType)((Object)entry.getValue())).toString());
            }
        }
        int index = 1;
        for (Map<String, Object> map : this.rows) {
            Element rowElem = doc.createElement("Row");
            subtableElem.appendChild(rowElem);
            rowElem.setAttribute("id", Integer.toString(index));
            Set<String> colNames = this.columns.size() > 0 ? this.columns.keySet() : map.keySet();
            for (String colName : colNames) {
                Element elementElem = doc.createElement("Element");
                rowElem.appendChild(elementElem);
                Object value = map.get(colName);
                elementElem.setAttribute("name", colName);
                String valueString = WJPContainer.formatValue(value, this.columns.get(colName));
                if (valueString == null) continue;
                elementElem.setAttribute("value", valueString);
            }
            ++index;
        }
        return doc;
    }

    public String[] getColumnNames() {
        return ArrayTools.toArray(this.columns.keySet(), String.class);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean hasColumn(String columnName) {
        ArgChecks.checkForNull(columnName, "columnName");
        return this.columns.containsKey(columnName);
    }

    public void addColumn(String columnName, ProcessConstants.AdeptDataType dataType) {
        ArgChecks.checkForNull(columnName, "columnName");
        ArgChecks.checkForNull((Object)dataType, "dataType");
        if (this.columns.containsKey(columnName)) {
            String msg = "column '%s' already exists";
            msg = String.format(msg, columnName);
            throw new IllegalArgumentException(msg);
        }
        this.columns.put(columnName, dataType);
    }

    public void removeColumn(String columnName) {
        ArgChecks.checkForNull(columnName, "columnName");
        if (!this.columns.containsKey(columnName)) {
            String msg = "unknown column '%s'";
            msg = String.format(msg, columnName);
            throw new IllegalArgumentException(msg);
        }
        this.columns.remove(columnName);
        for (Map<String, Object> row : this.rows) {
            row.remove(columnName);
        }
    }

    public ProcessConstants.AdeptDataType getDataType(String columnName) {
        ArgChecks.checkForNull(columnName, "columnName");
        if (!this.columns.containsKey(columnName)) {
            String msg = "unknown column '%s'";
            msg = String.format(msg, columnName);
            throw new IllegalArgumentException(msg);
        }
        if (this.columns.size() > 0) {
            return this.columns.get(columnName);
        }
        return ProcessConstants.AdeptDataType.STRING;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int addRow() {
        int row = this.rows.size();
        this.rows.add(new HashMap());
        return row;
    }

    public int addRow(Object ... values) {
        int row = this.addRow();
        this.setValues(row, values);
        return row;
    }

    public void insertRow(int rowIndex) {
        this.rows.add(rowIndex, new HashMap());
    }

    public void insertRow(int rowIndex, Object ... values) {
        this.insertRow(rowIndex);
        this.setValues(rowIndex, values);
    }

    public void removeRow(int rowIndex) {
        this.rows.remove(rowIndex);
    }

    public Object getValue(String columnName, int rowIndex) {
        ArgChecks.checkForNull(columnName, "columnName");
        if (!this.columns.containsKey(columnName)) {
            String msg = "unknown column '%s'";
            msg = String.format(msg, columnName);
            throw new IllegalArgumentException(msg);
        }
        return this.rows.get(rowIndex).get(columnName);
    }

    public void setValue(String columnName, int rowIndex, Object value) {
        ArgChecks.checkForNull(columnName, "columnName");
        if (!this.columns.containsKey(columnName)) {
            String msg = "unknown column '%s'";
            msg = String.format(msg, columnName);
            throw new IllegalArgumentException(msg);
        }
        WJPContainer.checkValue(value, this.columns.get(columnName));
        this.rows.get(rowIndex).put(columnName, value);
    }

    public void setValues(int rowIndex, Object ... values) {
        ArgChecks.checkForNull(values, "values");
        if (values.length != this.columns.size()) {
            throw new IllegalArgumentException("number of provided values does not match number of columns");
        }
        int i = 0;
        for (String columnName : this.columns.keySet()) {
            this.setValue(columnName, rowIndex, values[i]);
            ++i;
        }
    }
}

