/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.exesupport.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration.Configuration;

public class ExeCheck
extends AbstractExecutableComponentCheck {
    private static final String CHECK_ID = "EXE Activity Check";

    public ExeCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.exe.EXE", CHECK_ID);
    }

    public ExeCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    protected ExeCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, String typeID, String checkID) {
        super(typeID, checkID);
    }

    @Override
    public void performCheckSpi(AbstractActivity activity) {
        String message;
        this.checkGUIContext(activity);
        ActivityConfiguration conf = activity.getConfiguration();
        String commandURI = conf.getString("CommandURI");
        if (commandURI == null || commandURI.equals("")) {
            message = "An EXE activity requires a command URI.";
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
        } else {
            try {
                URI uri = new URI(commandURI);
                if (uri.getScheme() == null || !uri.getScheme().equals("file")) {
                    String message2 = String.format("A file URI is required, but '%s' is not a file URI.", uri);
                    this.addReportEntry(CheckReport.ResultType.FAILURE, message2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                message = String.format("'%s' is not a valid (file) URI.", commandURI);
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
            }
        }
        String arguments = conf.getString("CommandLineArguments");
        HashSet<Parameter> nonVirtualInputParams = new HashSet<Parameter>();
        for (Parameter parameter : activity.getParameters(ActivityConstants.AccessType.READ)) {
            if (parameter.isVirtual()) continue;
            nonVirtualInputParams.add(parameter);
        }
        if (arguments == null || arguments.equals("")) {
            String string = "The EXE activity requires the command line arguments to be set.";
            this.addReportEntry(CheckReport.ResultType.FAILURE, string);
        } else {
            for (Parameter parameter : nonVirtualInputParams) {
                String pos = parameter.getConfiguration().getString("position");
                if (pos == null || arguments.contains("%" + pos)) continue;
                String message4 = String.format("The parameter with the position %s does not appear in the command line arguments", pos);
                this.addReportEntry(CheckReport.ResultType.FAILURE, message4);
            }
        }
        for (Parameter parameter : nonVirtualInputParams) {
            if (parameter.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || parameter.getName().equals("STDIN")) continue;
            String message5 = String.format("An EXE activity may not have UDT parameters (except STDIN).", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message5);
        }
        HashSet<Parameter> hashSet = new HashSet<Parameter>();
        for (Parameter parameter : activity.getParameters(ActivityConstants.AccessType.WRITE)) {
            if (parameter.isVirtual()) continue;
            hashSet.add(parameter);
        }
        boolean bl = false;
        for (Parameter parameter : hashSet) {
            boolean bl2;
            if (parameter.getName().equals("STDERR") || parameter.getName().equals("STDOUT")) continue;
            if (bl2) {
                String message7 = "There must only be one return parameter.";
                this.addReportEntry(CheckReport.ResultType.FAILURE, message7);
                continue;
            }
            bl2 = true;
            String positionS = parameter.getConfiguration().getString("position");
            if (positionS == null || !positionS.equals("0")) {
                String message6 = "The position of the return parameter must be 0.";
                this.addReportEntry(CheckReport.ResultType.FAILURE, message6);
            }
            if (parameter.getDataType() == ProcessConstants.AdeptDataType.INTEGER) continue;
            String message2 = "The data type of the return parameter must be INTEGER.";
            this.addReportEntry(CheckReport.ResultType.FAILURE, message2);
        }
        TreeMap<Integer, Parameter> readByPosition = new TreeMap<Integer, Parameter>();
        this.getAndCheckParameterPositions(ActivityConstants.AccessType.READ, nonVirtualInputParams, readByPosition);
        int pos = 1;
        Iterator iterator = readByPosition.keySet().iterator();
        while (iterator.hasNext()) {
            int paramPos = (Integer)iterator.next();
            if (paramPos != pos) {
                String message8 = String.format("The parameter positions are not connected. Expected position %s for parameter '%s' but found position %s", pos, ((Parameter)readByPosition.get(paramPos)).getName(), paramPos);
                this.addReportEntry(CheckReport.ResultType.FAILURE, message8);
                break;
            }
            ++pos;
        }
    }

    protected void checkGUIContext(AbstractActivity activity) {
        if (!activity.getGUIContextID().equals("NullContext")) {
            String message = String.format("Activity requires a null GUI context.", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
        }
    }

    protected void getAndCheckParameterPositions(ActivityConstants.AccessType accessType, Set<Parameter> parameters, Map<Integer, Parameter> byPosition) {
        for (Parameter parameter : parameters) {
            String message;
            int position;
            boolean posNotSet;
            String name;
            if (parameter.isVirtual() || (name = parameter.getName()).equals("STDERR") || name.equals("STDIN") || name.equals("STDOUT")) continue;
            String positionString = parameter.getConfiguration().getString("position");
            boolean bl = posNotSet = positionString == null || positionString.equals("");
            if (posNotSet) {
                String message2 = String.format("%s Parameter '%s' missing the position in the activity type parameter configuration.", new Object[]{accessType, parameter.getName()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, message2);
                continue;
            }
            try {
                position = Integer.parseInt(positionString);
            }
            catch (NumberFormatException numberFormatException) {
                message = String.format("%s Parameter '%s' has an invalid position value in the activity type parameter configuration.", new Object[]{accessType, parameter.getName()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                continue;
            }
            if (byPosition.containsKey(position)) {
                message = String.format("%s Parameter '%s' has position which is used by another parameter.", new Object[]{accessType, parameter.getName()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                continue;
            }
            byPosition.put(position, parameter);
        }
    }
}

