/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.exesupport.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.ProgressMonitor;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import de.aristaflow.adept2.model.runtimeenvironment.TaskState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericExeExecutionEnvironment
extends ExecutionEnvironment {
    public static final String ATC_ARGUMENTS = "CommandLineArguments";
    public static final String ATC_COMMAND_URI = "CommandURI";
    public static final String PATC_POSITION = "position";
    public static final String PNAME_STDIN = "STDIN";
    public static final String PNAME_STDOUT = "STDOUT";
    public static final String PNAME_STDERR = "STDERR";
    protected Process exeProcess = null;
    private int signal;
    protected final boolean hasReturnParameter;
    protected final boolean hasStdInParameter;
    protected final boolean hasStdOutParameter;
    protected final boolean hasStdErrParameter;
    protected InputStream stdInInput;

    public GenericExeExecutionEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
        this.hasStdInParameter = activityInstance.getParameter(PNAME_STDIN, ActivityConstants.AccessType.READ) != null;
        this.hasStdOutParameter = activityInstance.getParameter(PNAME_STDOUT, ActivityConstants.AccessType.WRITE) != null;
        this.hasStdErrParameter = activityInstance.getParameter(PNAME_STDERR, ActivityConstants.AccessType.WRITE) != null;
        boolean localHasReturnParameter = false;
        for (ProcessModelParameter parameter : activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
            String paramPos = parameter.getConfiguration().getString(PATC_POSITION);
            if (paramPos == null || !paramPos.equals("0")) continue;
            localHasReturnParameter = true;
            break;
        }
        this.hasReturnParameter = localHasReturnParameter;
    }

    @Override
    public void run() {
        RuntimeEnvironment runtimeEnvironment = this.sessionContext.getRuntimeEnvironment();
        ProgressMonitor progressMonitor = this.sessionContext.getProgressMonitor();
        Object[] parameterValues = null;
        if (!this.exitAfterSignal(runtimeEnvironment)) {
            parameterValues = this.getInputParameterValues();
        }
        if (this.hasStdInParameter) {
            ProcessModelParameter parameter = this.activityInstance.getParameter(PNAME_STDIN, ActivityConstants.AccessType.READ);
            try {
                String name = parameter.getName();
                DataContext dataContext = this.sessionContext.getDataContext();
                switch (parameter.getDataType()) {
                    case BOOLEAN: {
                        boolean b = dataContext.retrieveBooleanParameterValue(name);
                        this.stdInInput = new ByteArrayInputStream(Boolean.toString(b).getBytes());
                        break;
                    }
                    case DATE: {
                        Date date = dataContext.retrieveDateParameterValue(name);
                        this.stdInInput = new ByteArrayInputStream(Long.toString(date.getTime()).getBytes());
                        break;
                    }
                    case FLOAT: {
                        double d = dataContext.retrieveFloatParameterValue(name);
                        this.stdInInput = new ByteArrayInputStream(Double.toString(d).getBytes());
                        break;
                    }
                    case INTEGER: {
                        long l = dataContext.retrieveIntegerParameterValue(name);
                        this.stdInInput = new ByteArrayInputStream(Long.toString(l).getBytes());
                        break;
                    }
                    case STRING: {
                        String s = dataContext.retrieveStringParameterValue(name);
                        this.stdInInput = new ByteArrayInputStream(s.getBytes());
                        break;
                    }
                    case URI: {
                        URI uri = dataContext.retrieveURIParameterValue(name);
                        this.stdInInput = new ByteArrayInputStream(uri.toASCIIString().getBytes());
                        break;
                    }
                    case USERDEFINED: {
                        UDTValue udtValue = dataContext.retrieveUDTParameterValue(name);
                        this.stdInInput = udtValue.getValueAsStream();
                        break;
                    }
                    default: {
                        String message = "Unknown parameter type: " + (Object)((Object)parameter.getDataType());
                        String state = "Unknown parameter type.";
                        throw new ApplicationFailedException(message, state, 1100004L);
                    }
                }
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                String message = String.format("Parameter '%s' expected to have type '%s'", new Object[]{parameter.getName(), parameter.getDataType()});
                throw new ApplicationEnvironmentException(message, -401001L);
            }
            catch (NoSuchParameterException noSuchParameterException) {
                String message = "Parameter expected to exist: " + parameter.getName();
                throw new ApplicationEnvironmentException(message, -401000L);
            }
        }
        if (!this.exitAfterSignal(runtimeEnvironment)) {
            String commandLineParameters = this.activityInstance.getConfiguration().getString(ATC_ARGUMENTS);
            this.logger.info("Command line parameters: " + commandLineParameters);
            Object[] commandLine = this.createParameterStringForExeApplication(commandLineParameters, parameterValues);
            this.logger.info("Command line after parsing: " + Arrays.toString(commandLine));
            progressMonitor.beginTask(-1);
            progressMonitor.setTaskState(TaskState.CALCULATING);
            URI executablePath = this.absolutePathToExecutable(this.activityInstance.getConfiguration().getURI(ATC_COMMAND_URI));
            this.startExeApplication(executablePath, (String[])commandLine);
        }
        if (!this.exitAfterSignal(runtimeEnvironment)) {
            this.terminateExeApplication(parameterValues);
        }
        progressMonitor.setTaskState(TaskState.FINISHED);
        progressMonitor.endTask();
    }

    @Override
    public boolean reset() {
        if (this.exeProcess != null) {
            this.exeProcess.destroy();
        }
        return this.signal(28);
    }

    @Override
    public boolean signal(int signal) {
        this.signal = signal;
        return true;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        if (this.exeProcess != null) {
            this.exeProcess.destroy();
        }
        return this.signal(14336);
    }

    protected boolean exitAfterSignal(RuntimeEnvironment runtimeEnvironment) {
        boolean ret = false;
        if (Thread.interrupted() && runtimeEnvironment.dispatch()) {
            switch (this.signal) {
                case 14336: {
                    throw new ApplicationFailedException("EXE-Component was killed", "ADEPT2:GenericExeExecEnvironment:ApplicationKilled", 1400000L);
                }
                case 28: {
                    ret = true;
                    runtimeEnvironment.applicationReset();
                }
            }
        }
        return ret;
    }

    protected void startExeApplication(URI path, String[] commandString) {
        Object[] command = new String[commandString.length + 1];
        command[0] = path.getPath();
        System.arraycopy(commandString, 0, command, 1, commandString.length);
        Runtime rt = Runtime.getRuntime();
        this.logger.info("Executing command '" + Arrays.toString(command) + "'.");
        try {
            this.exeProcess = rt.exec((String[])command);
        }
        catch (IOException e1) {
            this.logger.log(Level.SEVERE, String.format("An IO Exception occurred while executing '%s'! Aborting!", Arrays.toString(command)), e1);
            throw new ApplicationFailedException("The EXE-Component could not be started, an IOException was raised. Cancelling execution", "ADEPT2:GenericExeExecEnvironment:EXEStartFailed", 1000000L, e1);
        }
    }

    protected void terminateExeApplication(Object[] outputParameters) {
        boolean isExeProcessTerminated = false;
        boolean exitAfterSignal = false;
        RuntimeEnvironment runtimeEnvironment = this.sessionContext.getRuntimeEnvironment();
        final ByteArrayOutputStream stdErrOutput = new ByteArrayOutputStream();
        final ByteArrayOutputStream stdOutOutput = new ByteArrayOutputStream();
        final CountDownLatch stdErrOutLatch = new CountDownLatch(2);
        final Logger logger = this.logger;
        Thread stdErrThread = new Thread(new Runnable(){

            @Override
            public void run() {
                InputStream errorStream = GenericExeExecutionEnvironment.this.exeProcess.getErrorStream();
                try {
                    try {
                        int r;
                        while ((r = errorStream.read()) != -1) {
                            stdErrOutput.write(r);
                        }
                        stdErrOutput.close();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.INFO, "Problem reading STDERR of the process.", ioe);
                        stdErrOutLatch.countDown();
                    }
                }
                finally {
                    stdErrOutLatch.countDown();
                }
            }
        }, String.valueOf(Thread.currentThread().getName()) + "-STDERR");
        stdErrThread.start();
        Thread stdOutThread = new Thread(new Runnable(){

            @Override
            public void run() {
                InputStream outputStream = GenericExeExecutionEnvironment.this.exeProcess.getInputStream();
                try {
                    try {
                        int r;
                        while ((r = outputStream.read()) != -1) {
                            stdOutOutput.write(r);
                        }
                        stdOutOutput.close();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.INFO, "Problem reading STDOUT of the process.", ioe);
                        stdErrOutLatch.countDown();
                    }
                }
                finally {
                    stdErrOutLatch.countDown();
                }
            }
        }, String.valueOf(Thread.currentThread().getName()) + "-STDOUT");
        stdOutThread.start();
        Thread stdInThread = new Thread(new Runnable(){

            @Override
            public void run() {
                OutputStream outputStream = GenericExeExecutionEnvironment.this.exeProcess.getOutputStream();
                try {
                    try {
                        if (GenericExeExecutionEnvironment.this.hasStdInParameter) {
                            int i;
                            while ((i = GenericExeExecutionEnvironment.this.stdInInput.read()) != -1) {
                                outputStream.write(i);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Problem writing STDIN of the process.", e);
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            logger.log(Level.INFO, "Problem closing STDIN of the process (might already be closed to previous IOException).", e2);
                        }
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Problem closing STDIN of the process (might already be closed to previous IOException).", e);
                    }
                }
            }
        }, String.valueOf(Thread.currentThread().getName()) + "-STDIN");
        stdInThread.start();
        while (!isExeProcessTerminated) {
            try {
                this.exeProcess.waitFor();
                isExeProcessTerminated = true;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                isExeProcessTerminated = exitAfterSignal = this.exitAfterSignal(runtimeEnvironment);
            }
        }
        Thread.interrupted();
        boolean stdOutErrTerminated = false;
        while (!stdOutErrTerminated) {
            try {
                stdErrOutLatch.await();
                stdOutErrTerminated = true;
            }
            catch (InterruptedException ie) {
                logger.log(Level.INFO, "Interrupted while waiting for the output reader threads to finish.", ie);
            }
        }
        try {
            ByteArrayInputStream stdErr = new ByteArrayInputStream(stdErrOutput.toByteArray());
            if (this.hasStdErrParameter) {
                this.storeOutput(stdErr, this.activityInstance.getParameter(PNAME_STDERR, ActivityConstants.AccessType.WRITE));
            } else {
                this.logOutput(new InputStreamReader(stdErr), Level.INFO, "STD_ERR");
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problem storing / logging STDERR of the process.", e);
        }
        try {
            ByteArrayInputStream stdOut = new ByteArrayInputStream(stdOutOutput.toByteArray());
            if (this.hasStdOutParameter) {
                this.storeOutput(stdOut, this.activityInstance.getParameter(PNAME_STDOUT, ActivityConstants.AccessType.WRITE));
            } else {
                this.logOutput(new InputStreamReader(stdOut), Level.INFO, "STD_OUT");
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problem storing / logging STDOUT of the process.", e);
        }
        int exitValue = Integer.MIN_VALUE;
        if (!exitAfterSignal) {
            exitValue = this.exeProcess.exitValue();
            logger.info("The EXE-Component has an exitValue of " + exitValue);
        }
        if (!this.exitAfterSignal(runtimeEnvironment)) {
            this.writeOutputValues(exitValue, outputParameters);
            if (exitValue == 0 || this.hasReturnParameter) {
                runtimeEnvironment.applicationClosed();
            } else {
                String message = String.format("The EXE process returned a value unequal 0 (exit code: %s)! Application failed", exitValue);
                throw new ApplicationFailedException(message, "ADEPT2:GenericExeExecEnvironment:EXEExitCode:" + exitValue, 1000001L);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public String[] createParameterStringForExeApplication(String commandStringTemplate, Object[] parameterValues) {
        result = new ArrayList<String>();
        i = 0;
        ** GOTO lbl12
        {
            ++i;
            do {
                if (i < commandStringTemplate.length() && Character.isWhitespace(commandStringTemplate.charAt(i))) continue block0;
                if (i >= commandStringTemplate.length()) break block0;
                command = new StringBuilder();
                i = this.parseNextCommand(commandStringTemplate, parameterValues, command, i);
                result.add(command.toString());
lbl12:
                // 2 sources

            } while (i < commandStringTemplate.length());
        }
        return result.toArray(new String[result.size()]);
    }

    private int parseNextCommand(String commandStringTemplate, Object[] parameterValues, StringBuilder command, int currentIndex) {
        int i = currentIndex;
        boolean block = false;
        int commandStart = i;
        char currentChar = commandStringTemplate.charAt(i);
        while (i < commandStringTemplate.length()) {
            block0 : switch (currentChar) {
                case '\\': {
                    if (++i >= commandStringTemplate.length()) {
                        this.logger.severe(String.format("Spurious '\\' at the end of the Command String '%s'", commandStringTemplate));
                        break;
                    }
                    currentChar = commandStringTemplate.charAt(i);
                    switch (currentChar) {
                        case '\"': 
                        case '%': 
                        case '\\': {
                            command.append(currentChar);
                            break block0;
                        }
                    }
                    this.logger.warning(String.format("Unnecessarily escaped char '%s' in Command String '%s' (at Position %d), ignoring!", Character.valueOf(currentChar), commandStringTemplate, i));
                    command.append(currentChar);
                    break;
                }
                case '%': {
                    if (i + 1 >= commandStringTemplate.length()) {
                        this.logger.severe(String.format("Spurious '%%' at the end of the Command String '%s'", commandStringTemplate));
                        break;
                    }
                    StringBuilder paramIndex = new StringBuilder(2);
                    currentChar = commandStringTemplate.charAt(i + 1);
                    while (Character.isDigit(currentChar)) {
                        paramIndex.append(currentChar);
                        if (++i + 1 >= commandStringTemplate.length()) break;
                        currentChar = commandStringTemplate.charAt(i + 1);
                    }
                    if (paramIndex.length() == 0) {
                        this.logger.severe(String.format("Incorrect use of '%%', no Parameter number given in Command String '%s' (at Position %d)", commandStringTemplate, i));
                        command.append('%');
                        break;
                    }
                    int paramPos = Integer.parseInt(paramIndex.toString()) - 1;
                    command.append(this.getParameterValue(parameterValues, paramPos));
                    break;
                }
                case '\"': {
                    if (block) {
                        if (i + 1 < commandStringTemplate.length() && !Character.isWhitespace(commandStringTemplate.charAt(i + 1))) {
                            this.logger.warning(String.format("No Whitespace between block end and next parameter in Command String '%s'(at Position %d)", commandStringTemplate, i + 1));
                            break;
                        }
                        ++i;
                        while (i < commandStringTemplate.length() && Character.isWhitespace(commandStringTemplate.charAt(i))) {
                            ++i;
                        }
                        return i;
                    }
                    if (i == commandStart) {
                        block = true;
                        break;
                    }
                    this.logger.warning(String.format("Unescaped Blockmarker inside command in Command String '%s' (at Position %d)", commandStringTemplate, i));
                    block = true;
                    break;
                }
                default: {
                    command.append(currentChar);
                }
            }
            if (++i >= commandStringTemplate.length()) break;
            currentChar = commandStringTemplate.charAt(i);
            if (!Character.isWhitespace(currentChar)) continue;
            if (!block) {
                while (i < commandStringTemplate.length() && Character.isWhitespace(commandStringTemplate.charAt(i))) {
                    ++i;
                }
                return i;
            }
            command.append(currentChar);
            if (++i >= commandStringTemplate.length()) break;
            currentChar = commandStringTemplate.charAt(i);
            while (i < commandStringTemplate.length() && Character.isWhitespace(currentChar)) {
                command.append(currentChar);
                currentChar = commandStringTemplate.charAt(++i);
            }
        }
        if (block) {
            this.logger.severe(String.format("Block not closed in '%s'", commandStringTemplate));
        }
        return i;
    }

    private String getParameterValue(Object[] parameterValues, int paramPos) {
        if (paramPos >= 0 && paramPos < parameterValues.length) {
            if (parameterValues[paramPos] != null) {
                return parameterValues[paramPos].toString();
            }
            String msg = String.format("No valid value for parameter at position '%s' provided for '%s' ('%s').", paramPos, this.activityInstance.getName(), this.activityInstance.getConfiguration().getString(ATC_COMMAND_URI));
            this.logger.warning(msg);
            return "";
        }
        String msg = String.format("Parameter at position '%s' not provided for '%s' ('%s').", paramPos, this.activityInstance.getName(), this.activityInstance.getConfiguration().getString(ATC_COMMAND_URI));
        this.logger.warning(msg);
        return "";
    }

    private URI absolutePathToExecutable(URI executablePath) {
        if (new File(executablePath).exists()) {
            return executablePath;
        }
        try {
            URL url = this.getExecutableAsResource(executablePath.toString());
            if (url != null) {
                return url.toURI();
            }
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, String.format("URI Syntax exception while trying to get the the executable '%s' from the classloader!", executablePath), e);
        }
        String[] stringArray = System.getenv("PATH").split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            StringBuilder filename = new StringBuilder(path);
            filename.append(File.separatorChar);
            filename.append(executablePath.toString());
            File executableFile = new File(filename.toString());
            if (executableFile.exists()) {
                return executableFile.toURI();
            }
            ++n2;
        }
        String message = String.format("Could not find the executable '%s'! Please check the configuration of the activity and/or the correct installation of the application!", executablePath);
        this.logger.severe(message);
        throw new ApplicationEnvironmentException(message, 1000002L);
    }

    private URL getExecutableAsResource(String executable) {
        URL ret = this.getClass().getClassLoader().getResource(executable);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private void storeOutput(InputStream inputStream, ProcessModelParameter parameter) throws IOException {
        try {
            String name = parameter.getName();
            if (parameter.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                int r;
                StringBuilder string = new StringBuilder();
                while ((r = inputStream.read()) != -1) {
                    string.append((char)r);
                }
                this.sessionContext.getDataContext().storeStringParameterValue(name, string.toString());
            } else if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                ADEPT2UDTValue value = new ADEPT2UDTValue(parameter.getUDTName(), inputStream);
                this.sessionContext.getDataContext().storeUDTParameterValue(name, value);
            }
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            String message = String.format("Parameter '%s' expected to have type '%s'", new Object[]{parameter.getName(), parameter.getDataType()});
            throw new ApplicationEnvironmentException(message, -401001L);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            String message = "Parameter expected to exist: " + parameter.getName();
            throw new ApplicationEnvironmentException(message, -401000L);
        }
    }

    private void logOutput(InputStreamReader outputReader, Level level, String prefix) throws IOException {
        int r;
        StringBuilder s = new StringBuilder();
        while ((r = outputReader.read()) != -1) {
            s.append((char)r);
        }
        this.logger.log(level, String.format("%1$s: %2$s", prefix, s.toString()));
    }
}

