/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.htmltemplates.environments;

import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.extensions.htmltemplates.HTMLTemplateTools;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.ui.htmlgui.HTMLContext;
import de.aristaflow.adept2.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class HTMLTemplateEnvironment
extends ExecutionEnvironment {
    private Map<String, ProcessConstants.AdeptDataType> params;
    private String form;
    private File fileRoot = new File(SystemProperties.getDataDir(), "HTMLTemplateFiles");

    public HTMLTemplateEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
        if (!this.fileRoot.exists() && !this.fileRoot.mkdirs()) {
            this.logger.warning(String.format("The directory %s could not be created!", this.fileRoot));
        }
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        HTMLContext guiContext = (HTMLContext)sessionContext.getGUIContext();
        ActivityConfiguration atc = this.activityInstance.getConfiguration();
        if (atc.getAllEntries().contains("Form") && !"".equals(atc.getString("Form"))) {
            this.form = new String(Base64.decode(atc.getString("Form")));
        } else if (atc.getAllEntries().contains("FormFile") && !"".equals(atc.getString("FormFile"))) {
            BufferedReader br;
            File file = new File(this.fileRoot, atc.getString("FormFile"));
            try {
                br = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Form file not found!", e);
            }
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line).append('\n');
                }
                br.close();
            }
            catch (IOException e) {
                throw new RuntimeException("IOException reading form file!", e);
            }
            this.form = sb.toString();
        } else {
            throw new RuntimeException("No form attribute!");
        }
        this.params = HTMLTemplateTools.parseInputParameters(this.form);
        String baseURL = guiContext.getURL().toString();
        DataContext dataContext = sessionContext.getDataContext();
        String resultForm = this.performReplacements(baseURL, dataContext);
        guiContext.setInitialContent(resultForm);
    }

    @Override
    public void run() {
        HTMLContext guiContext = (HTMLContext)this.sessionContext.getGUIContext();
        while (true) {
            try {
                Map<String, String> reply;
                while (true) {
                    if ((reply = guiContext.waitForReply()) == null) {
                        throw new ApplicationFailedException("No response from client.", "No response", 9999L);
                    }
                    if (!reply.containsKey("action") || !"file".equals(reply.get("action"))) break;
                    String fileName = reply.get("file");
                    File file = new File(this.fileRoot, fileName);
                    try {
                        guiContext.setResponse(new HTMLContext.Response(202, this.getMimeTypeForFile(file), new FileInputStream(file)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        guiContext.setResponse(new HTMLContext.Response(404, "text/plain", "File not found: " + fileName));
                    }
                }
                this.storeParameters(reply);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private String getMimeTypeForFile(File file) {
        if (file.getName().endsWith(".css")) {
            return "text/css";
        }
        if (file.getName().endsWith(".js")) {
            return "text/javascript";
        }
        if (file.getName().endsWith(".png")) {
            return "image/png";
        }
        return "application/octet-stream";
    }

    /*
     * Unable to fully structure code
     */
    private void storeParameters(Map<String, String> reply) {
        dataContext = this.sessionContext.getDataContext();
        block9: for (ProcessModelParameter parameter : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
            if (!reply.containsKey(parameter.getName())) {
                this.logger.info("Skipping HTTP parameter w/o parameter in form: " + parameter.getName());
                continue;
            }
            try {
                switch (HTMLTemplateEnvironment.$SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$AdeptDataType()[parameter.getDataType().ordinal()]) {
                    case 3: {
                        dataContext.storeStringParameterValue(parameter.getName(), reply.get(parameter.getName()));
                        break;
                    }
                    case 5: {
                        stringDate = reply.get(parameter.getName());
                        pattern = parameter.getConfiguration().getString("DateFormat");
                        dateFormat = pattern != null ? new SimpleDateFormat(pattern, Locale.US) : DateFormat.getDateTimeInstance();
                        dateFormat.setLenient(true);
                        date = null;
                        try {
                            date = dateFormat.parse(stringDate);
                        }
                        catch (ParseException v0) {
                            if (parameter.isOptional()) ** GOTO lbl24
                            message = String.format("Could not parse %s into a date, following format %s.", new Object[]{stringDate, pattern});
                            throw new ApplicationFailedException(message, "Invalid Date Format", 1100001L);
                        }
lbl24:
                        // 2 sources

                        if (date == null) continue block9;
                        dataContext.storeDateParameterValue(parameter.getName(), date);
                    }
                }
            }
            catch (InvalidDataTypeException e) {
                message = "Unexpected data type in parameter " + parameter.getName() + " expected " + (Object)this.params.get(parameter.getName());
                throw new ApplicationEnvironmentException(message, -401001L, e);
            }
            catch (NoSuchParameterException e) {
                message = "Expected parameter " + parameter.getName() + " to exist.";
                throw new ApplicationEnvironmentException(message, -401000L, e);
            }
        }
    }

    private String performReplacements(String baseURL, DataContext dataContext) {
        String resultForm = this.form;
        for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : this.params.entrySet()) {
            String pattern = "%" + ParameterRefTools.toTypeKey(entry.getValue()) + ":" + entry.getKey() + "%";
            String valueString = this.getValueString(dataContext, entry.getValue(), entry.getKey());
            resultForm = resultForm.replaceAll(pattern, valueString);
        }
        resultForm = resultForm.replaceAll("%BaseURL%", baseURL);
        return resultForm;
    }

    private String getValueString(DataContext dataContext, ProcessConstants.AdeptDataType type, String parameterName) {
        ActivityConfiguration atc;
        ProcessModelParameter parameter = this.activityInstance.getParameter(parameterName, ActivityConstants.AccessType.READ);
        if (parameter == null) {
            ActivityConfiguration atc2 = this.activityInstance.getConfiguration();
            if (atc2.getAllEntries().contains("Default." + parameterName)) {
                return atc2.getString("Default." + parameterName);
            }
            return "";
        }
        String ret = null;
        try {
            switch (type) {
                case STRING: {
                    ret = dataContext.retrieveStringParameterValue(parameterName);
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.toString(dataContext.retrieveBooleanParameterValue(parameterName));
                    break;
                }
                case INTEGER: {
                    ret = Long.toString(dataContext.retrieveIntegerParameterValue(parameterName));
                    break;
                }
                case FLOAT: {
                    ret = Double.toString(dataContext.retrieveFloatParameterValue(parameterName));
                    break;
                }
                case URI: {
                    ret = dataContext.retrieveURIParameterValue(parameterName).toString();
                    break;
                }
                case DATE: {
                    Date date = dataContext.retrieveDateParameterValue(parameterName);
                    String pattern = parameter.getConfiguration().getString("DateFormat");
                    if (pattern != null) {
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
                        ret = sdf.format(date);
                    } else {
                        ret = date.toString();
                    }
                    break;
                }
                default: {
                    throw new ApplicationFailedException("Unsupported type: " + (Object)((Object)type), "Unsupported type", 1100004L);
                }
            }
        }
        catch (InvalidDataTypeException e) {
            String message = "Unexpected data type in parameter " + parameterName + " expected " + (Object)((Object)type);
            throw new ApplicationEnvironmentException(message, -401001L, e);
        }
        catch (NoSuchParameterException noSuchParameterException) {}
        if ((ret == null || ret.equals("")) && (atc = this.activityInstance.getConfiguration()).getAllEntries().contains("Default." + parameterName)) {
            ret = atc.getString("Default." + parameterName);
        }
        return ret != null ? ret : "";
    }
}

