/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.javasupport;

import de.aristaflow.adept2.extensions.javasupport.annotations.Description;
import de.aristaflow.adept2.extensions.javasupport.annotations.DeveloperDescription;
import de.aristaflow.adept2.extensions.javasupport.annotations.GUIContext;
import de.aristaflow.adept2.extensions.javasupport.annotations.IdentifierID;
import de.aristaflow.adept2.extensions.javasupport.annotations.Optional;
import de.aristaflow.adept2.extensions.javasupport.annotations.SupportsViewOnly;
import de.aristaflow.adept2.extensions.javasupport.annotations.VirtualParameters;
import de.aristaflow.adept2.extensions.javasupport.annotations.WorkflowOperation;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.ConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.util.ClassLoaderRepository;

public abstract class AbstractBundleCreator {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final ActivityModelFactory amf;
    private final boolean checkAnnotation;
    private static final String DEFAULT_UDT_NO_UDT_NAME = null;
    protected static final String DEFAULT_OPERATION_DESCRIPTION = "";
    protected static final String DEFAULT_OPERATION_DEVELOPER_DESCRIPTION = "";
    protected static final String DEFAULT_STAFF_ASSIGNMENT_RULE = "Agent(id=8)";
    private final Set<ActivityTemplateDefinition> bundleOperations = new HashSet<ActivityTemplateDefinition>();
    protected final Set<JarFile> bundleJarFiles = new HashSet<JarFile>();
    protected URLClassLoader classLoader;
    protected List<String> atClassPath;
    protected final Map<UUID, JarFile> code = new HashMap<UUID, JarFile>();
    protected final Operation operation;
    protected final ConfigurationSet configurationSet;

    protected AbstractBundleCreator(ActivityModelFactory amf, boolean checkAnnotation, Operation operation, ConfigurationSet configurationSet) {
        ArgChecks.checkForNull(operation, "operation");
        ArgChecks.checkForNull(amf, "amf");
        this.amf = amf;
        this.checkAnnotation = checkAnnotation;
        this.operation = operation;
        this.configurationSet = configurationSet;
    }

    protected void addClass(Class<?> clazz) throws ClassNotFoundException {
        this.bundleOperations.addAll(this.createATDsForClass(clazz));
    }

    public Reader getCode(UUID codeID) {
        if (!this.code.containsKey(codeID)) {
            throw new IllegalArgumentException(String.format("Code ID '%s' not known.", codeID));
        }
        JarFile jarFile = this.code.get(codeID);
        File file = new File(jarFile.getName());
        try {
            return new FileReader(file);
        }
        catch (FileNotFoundException e) {
            String message = String.format("Could not find the JarFile at '%s'.", jarFile.getName());
            throw new RuntimeException(message, e);
        }
    }

    public Set<ActivityTemplateDefinition> getActivityTemplateDefinitions() {
        return Collections.unmodifiableSet(this.bundleOperations);
    }

    protected void addClassFiles(Set<String> classes, JarFile jarFile) {
        ClassNameFilter filter = new ClassNameFilter();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!filter.accept(null, name)) continue;
            name = name.substring(0, name.length() - 6);
            name = name.replace('/', '.');
            classes.add(name);
        }
    }

    protected Set<ActivityTemplateDefinition> createATDsForClass(Class<?> clazz) throws ClassNotFoundException {
        this.logger.info("Adding operations of class " + clazz);
        try {
            HashSet<ActivityTemplateDefinition> operations = new HashSet<ActivityTemplateDefinition>();
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (this.checkAnnotation) {
                    if (method.isAnnotationPresent(WorkflowOperation.class)) {
                        this.logger.info(String.format("Adding '%s' of class '%s'", method, clazz));
                        operations.add(this.createATDFromMethod(method));
                    } else {
                        this.logger.info(String.format("Skipping '%s' of class '%s' - no workflow operation.", method, clazz));
                    }
                } else if (this.isObjectMethod(method)) {
                    this.logger.info(String.format("Skipping '%s' of class '%s' - no workflow operation.", method, clazz));
                } else {
                    this.logger.info(String.format("Adding '%s' of class '%s'", method, clazz));
                    operations.add(this.createATDFromMethod(method));
                }
                ++n2;
            }
            return operations;
        }
        catch (NoClassDefFoundError e) {
            String message = "A referenced class could not be found, the class path is probably incomplete.";
            throw new ClassNotFoundException(message, e);
        }
    }

    private boolean isObjectMethod(Method method) {
        Method[] methodArray = Object.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.equals(method)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ActivityTemplateDefinition createATDFromMethod(Method method) {
        if (this.checkAnnotation && !method.isAnnotationPresent(WorkflowOperation.class)) {
            throw new IllegalArgumentException();
        }
        UUID id = this.getNextActivityTemplateDefinitionID();
        String name = method.getName();
        String description = "";
        if (method.isAnnotationPresent(Description.class)) {
            description = method.getAnnotation(Description.class).value();
        }
        String developerDescription = "";
        if (method.isAnnotationPresent(DeveloperDescription.class)) {
            developerDescription = method.getAnnotation(DeveloperDescription.class).value();
        }
        ParameterChangePolicy parameterChangePolicy = ParameterChangePolicy.ADD_VIRTUAL;
        Collection<ActivityModelParameter> inputParameters = this.createInputParameters(method);
        Collection<ActivityModelParameter> outputParameters = this.createOutputParameters(method);
        this.addVirtualParameters(method, inputParameters, outputParameters);
        String staffAssignmentRule = DEFAULT_STAFF_ASSIGNMENT_RULE;
        String guiContextID = null;
        if (method.isAnnotationPresent(GUIContext.class)) {
            guiContextID = method.getAnnotation(GUIContext.class).value();
        }
        ExecutionControlProperties ecp = new ExecutionControlProperties(false, false, false);
        boolean supportsViewOnly = method.isAnnotationPresent(SupportsViewOnly.class);
        PluginDataContainer pdc = this.amf.createPluginDataContainer(null, null);
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        long revision = 0L;
        State state = State.IN_DEVELOPMENT;
        List<String> classPath = this.atClassPath;
        Boolean isSingleton = false;
        boolean supportsTestExecution = false;
        String licenceInformation = "";
        InheritedConfigurationDescription configurationDescription = this.amf.createInheritedConfigurationDescription(this.operation.getConfigurationDescription(), new HashMap<String, ConfigurationDescription.ConfigurationEntry>());
        HashMap<String, String> activityConfiguration = new HashMap<String, String>();
        String javaClass = method.getDeclaringClass().getCanonicalName();
        activityConfiguration.put("ClassName", javaClass);
        activityConfiguration.put("MethodName", method.getName());
        Set<String> fixedForChildren = activityConfiguration.keySet();
        InheritedActivityConfiguration configuration = this.amf.createInheritedActivityConfiguration(this.operation.getConfiguration(), activityConfiguration, null, null, fixedForChildren);
        ActivityTemplateDefinition atd = this.amf.createActivityTemplateDefinition(this.operation, this.configurationSet, id, name, description, developerDescription, revision, state, null, classPath, isSingleton, null, guiContextID, ecp, supportsViewOnly, supportsTestExecution, null, licenceInformation, configurationDescription, configuration, null, parameterChangePolicy, inputParameters, outputParameters, null, staffAssignmentRule, pdc, userAttributes);
        return atd;
    }

    protected UUID getNextActivityTemplateDefinitionID() {
        return UUIDTools.createRandomUUID();
    }

    protected Collection<ActivityModelParameter> createInputParameters(Method method) {
        HashSet<ActivityModelParameter> parameters = new HashSet<ActivityModelParameter>();
        Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
        int i = 0;
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Class<?> type = classArray[n2];
            String description = name = this.getParameterName(method, i);
            String developerDescription = "parameter" + i;
            ProcessConstants.AdeptDataType dataType = this.getAdeptDataTypeForNativeJavaType(type);
            String udtName = DEFAULT_UDT_NO_UDT_NAME;
            if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
                udtName = type.getCanonicalName();
            }
            UUID identifierID = ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
            boolean isOptional = false;
            Annotation[] annotationArray = allParameterAnnotations[i];
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                if (!(annotation instanceof IdentifierID) && annotation instanceof Optional) {
                    isOptional = true;
                }
                ++n4;
            }
            boolean isVirtual = false;
            Boolean isFailure = false;
            HashMap<String, String> activityTypeSpecificData = new HashMap<String, String>();
            activityTypeSpecificData.put("position", Integer.toString(i + 1));
            activityTypeSpecificData.put("NativeDataType", type.getCanonicalName());
            InheritedActivityConfiguration configuration = this.amf.createInheritedActivityConfiguration(null, activityTypeSpecificData, null, null, null);
            ActivityModelParameter parameter = this.amf.createParameter(name, description, developerDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, null, null, configuration, null, null);
            parameters.add(parameter);
            ++i;
            ++n2;
        }
        return parameters;
    }

    protected Collection<ActivityModelParameter> createOutputParameters(Method method) {
        HashSet<ActivityModelParameter> parameters = new HashSet<ActivityModelParameter>();
        if (method.getReturnType() == Void.class) {
            return parameters;
        }
        String name = this.getResultName(method);
        String description = "return parameter";
        String developerDescription = "return parameter";
        ProcessConstants.AdeptDataType dataType = this.getAdeptDataTypeForNativeJavaType(method.getReturnType());
        String udtName = DEFAULT_UDT_NO_UDT_NAME;
        if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            udtName = method.getReturnType().getCanonicalName();
        }
        UUID identifierID = ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
        method.isAnnotationPresent(IdentifierID.class);
        boolean isOptional = method.isAnnotationPresent(Optional.class);
        boolean isVirtual = false;
        Boolean isFailure = false;
        HashMap<String, String> activityTypeSpecificData = new HashMap<String, String>();
        activityTypeSpecificData.put("position", Integer.toString(0));
        activityTypeSpecificData.put("NativeDataType", method.getReturnType().getSimpleName());
        InheritedActivityConfiguration configuration = this.amf.createInheritedActivityConfiguration(null, activityTypeSpecificData, null, null, null);
        ActivityModelParameter parameter = this.amf.createParameter(name, description, developerDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, null, null, configuration, null, null);
        parameters.add(parameter);
        return parameters;
    }

    protected void addVirtualParameters(Method method, Collection<ActivityModelParameter> inputParameters, Collection<ActivityModelParameter> outputParameters) {
        if (!method.isAnnotationPresent(VirtualParameters.class)) {
            return;
        }
    }

    protected String getParameterName(Method method, int index) {
        LocalVariable localVariable;
        ClassLoaderRepository repository = new ClassLoaderRepository(method.getDeclaringClass().getClassLoader());
        Repository.setRepository((org.apache.bcel.util.Repository)repository);
        JavaClass javaClass = Repository.lookupClass(method.getDeclaringClass());
        String defaultReturn = "parameter" + (index + 1);
        org.apache.bcel.classfile.Method method2 = javaClass.getMethod(method);
        if (method2 == null) {
            return defaultReturn;
        }
        LocalVariableTable localVariableTable = method2.getLocalVariableTable();
        if (localVariableTable == null) {
            return defaultReturn;
        }
        int shift = 0;
        if (!method2.isStatic()) {
            shift = 1;
        }
        if ((localVariable = localVariableTable.getLocalVariableTable()[index + shift]) == null) {
            return defaultReturn;
        }
        return localVariable.getName();
    }

    protected String getResultName(Method method) {
        return "return";
    }

    private ProcessConstants.AdeptDataType getAdeptDataTypeForNativeJavaType(Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Short.TYPE || type == Short.class || type == Byte.TYPE || type == Byte.class) {
            return ProcessConstants.AdeptDataType.INTEGER;
        }
        if (type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class) {
            return ProcessConstants.AdeptDataType.FLOAT;
        }
        if (type == String.class) {
            return ProcessConstants.AdeptDataType.STRING;
        }
        if (type == URI.class) {
            return ProcessConstants.AdeptDataType.URI;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ProcessConstants.AdeptDataType.BOOLEAN;
        }
        return ProcessConstants.AdeptDataType.USERDEFINED;
    }

    static class ClassNameFilter
    implements FilenameFilter {
        ClassNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".class") && name.indexOf("$") == -1;
        }
    }
}

