/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.javasupport;

import de.aristaflow.adept2.extensions.javasupport.AbstractBundleCreator;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.Operation;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;

public class JavaBundleCreator
extends AbstractBundleCreator {
    public JavaBundleCreator(ActivityModelFactory amf, JarFile jarFile, Set<JarFile> auxiliaryJarFiles, Operation javaOperation, ConfigurationSet configurationSet, String ... origClassNames) throws ClassNotFoundException {
        super(amf, false, javaOperation, configurationSet);
        String[] classNames = origClassNames;
        this.bundleJarFiles.add(jarFile);
        this.bundleJarFiles.addAll(auxiliaryJarFiles);
        LinkedList<URL> urls = new LinkedList<URL>();
        try {
            urls.add(new File(jarFile.getName()).toURL());
            for (JarFile file : auxiliaryJarFiles) {
                urls.add(new File(file.getName()).toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        URL[] urlsArray = urls.toArray(new URL[urls.size()]);
        this.atClassPath = this.getClassPathFromFiles(jarFile, auxiliaryJarFiles);
        this.classLoader = AccessController.doPrivileged(new PrivilegedActionImpl(urlsArray));
        if (classNames.length == 0) {
            HashSet<String> classes = new HashSet<String>();
            this.addClassFiles(classes, jarFile);
            classNames = classes.toArray(new String[classes.size()]);
        }
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> name;
            String className = stringArray[n2];
            try {
                name = this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.addClass(name);
            ++n2;
        }
    }

    private List<String> getClassPathFromFiles(JarFile jarFile, Set<JarFile> auxiliaryJarFiles) {
        String libDir = "${arflow:arflow.libdir}/extensions/";
        LinkedList<String> classPath = new LinkedList<String>();
        classPath.add(String.valueOf(libDir) + new File(jarFile.getName()).getName());
        for (JarFile file : auxiliaryJarFiles) {
            classPath.add(String.valueOf(libDir) + new File(file.getName()).getName());
        }
        return classPath;
    }

    private static final class PrivilegedActionImpl
    implements PrivilegedAction<URLClassLoader> {
        private final URL[] urlsArray;

        PrivilegedActionImpl(URL[] urlsArray) {
            this.urlsArray = urlsArray;
        }

        @Override
        public URLClassLoader run() {
            return new URLClassLoader(this.urlsArray, this.getClass().getClassLoader());
        }
    }
}

