/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.javasupport.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.extensions.javasupport.checks.JavaCheckTools;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.configuration.Configuration;

public class JavaCheck
extends AbstractExecutableComponentCheck {
    private static final String CHECK_ID = "Java Activity Check";

    public JavaCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.java.StaticJavaCall", CHECK_ID);
    }

    public JavaCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    public void performCheckSpi(AbstractActivity activity) {
        String nativeDataType;
        this.checkGUIContext(activity.getGUIContextID());
        ActivityConfiguration conf = activity.getConfiguration();
        String className = conf.getString("ClassName");
        this.isValidClassName(className);
        for (Parameter parameter : activity.getParameters(ActivityConstants.AccessType.READ)) {
            nativeDataType = parameter.getConfiguration().getString("NativeDataType");
            this.checkDataType(ActivityConstants.AccessType.READ, parameter.getName(), parameter.getDataType(), nativeDataType);
        }
        for (Parameter parameter : activity.getParameters(ActivityConstants.AccessType.WRITE)) {
            nativeDataType = parameter.getConfiguration().getString("NativeDataType");
            this.checkDataType(ActivityConstants.AccessType.WRITE, parameter.getName(), parameter.getDataType(), nativeDataType);
        }
        TreeMap<Integer, Parameter> treeMap = new TreeMap<Integer, Parameter>();
        this.getAndCheckParameterPositions(ActivityConstants.AccessType.READ, activity.getParameters(ActivityConstants.AccessType.READ), treeMap);
        int pos = 1;
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int paramPos = (Integer)iterator.next();
            if (paramPos != pos) {
                String message = String.format("The parameter positions are not connected. Expected position %s for parameter '%s' but found position %s", pos, ((Parameter)treeMap.get(paramPos)).getName(), paramPos);
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                break;
            }
            ++pos;
        }
        TreeMap<Integer, Parameter> writtenByPosition = new TreeMap<Integer, Parameter>();
        this.getAndCheckParameterPositions(ActivityConstants.AccessType.WRITE, activity.getParameters(ActivityConstants.AccessType.WRITE), writtenByPosition);
        Iterator iterator2 = writtenByPosition.keySet().iterator();
        while (iterator2.hasNext()) {
            String outputNativeDataType;
            String inputNativeDataType;
            String message;
            int paramPos = (Integer)iterator2.next();
            if (paramPos == 0) continue;
            Parameter output = (Parameter)writtenByPosition.get(paramPos);
            if (output.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) {
                String message2 = String.format("Output parameter '%s' is intended to be altered via side effects, but is not of type USERDEFINED (only mutable objects are allowed).", ((Parameter)writtenByPosition.get(paramPos)).getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message2);
                continue;
            }
            Parameter input = (Parameter)treeMap.get(paramPos);
            if (input.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) {
                message = String.format("Output parameter '%s' is intended to be altered via side effects, but its corresponding input parameter is not of type USERDEFINED (only mutable objects are allowed).", ((Parameter)writtenByPosition.get(paramPos)).getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                continue;
            }
            if (!input.getUDTName().equals(output.getUDTName())) {
                message = String.format("Output parameter '%s' is intended to be altered via side effects, its user defined type is not matching the user defined type of its corresponding input parameter.", ((Parameter)writtenByPosition.get(paramPos)).getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
            }
            if ((inputNativeDataType = input.getConfiguration().getString("NativeDataType")).equals(outputNativeDataType = output.getConfiguration().getString("NativeDataType"))) continue;
            String message3 = String.format("Output parameter '%s' is intended to be altered via side effects, its native data type is not matching the native data type of its corresponding input parameter.", ((Parameter)writtenByPosition.get(paramPos)).getName());
            this.addReportEntry(CheckReport.ResultType.FAILURE, message3);
        }
    }

    protected void getAndCheckParameterPositions(ActivityConstants.AccessType accessType, Collection<? extends Parameter> parameters, Map<Integer, Parameter> byPosition) {
        for (Parameter parameter : parameters) {
            String message;
            int position;
            String positionString = parameter.getConfiguration().getString("position");
            if (positionString == null || positionString.equals("")) {
                String message2 = String.format("%s Parameter '%s' missing the position in the activity type parameter configuration.", new Object[]{accessType, parameter.getName()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, message2);
                continue;
            }
            try {
                position = Integer.parseInt(positionString);
            }
            catch (NumberFormatException numberFormatException) {
                message = String.format("%s Parameter '%s' has an invalid position value in the activity type parameter configuration.", new Object[]{accessType, parameter.getName()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                continue;
            }
            if (byPosition.containsKey(position)) {
                message = String.format("%s Parameter '%s' has position which is used by another parameter.", new Object[]{accessType, parameter.getName()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                continue;
            }
            byPosition.put(position, parameter);
        }
    }

    protected void isValidClassName(String className) {
        if (className == null || className.equals("")) {
            String message = String.format("There is no class name provided for the activity.", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
            return;
        }
        if (!JavaCheckTools.isValidTypeName(className)) {
            String message = String.format("The class name provided for the activity is not a valid qualified class name.", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
            return;
        }
    }

    public void checkDataType(ActivityConstants.AccessType accessType, String name, ProcessConstants.AdeptDataType dataType, String nativeDataType) {
        String[] allowedTypes;
        if (dataType == ProcessConstants.AdeptDataType.STRING || dataType == ProcessConstants.AdeptDataType.URI) {
            return;
        }
        if (dataType != ProcessConstants.AdeptDataType.USERDEFINED && (nativeDataType == null || nativeDataType.equals(""))) {
            String message = String.format("No native data type is provided for %s parameter '%s'. Hint: the native data type may be required for overloaded methods.", new Object[]{accessType, name});
            this.addReportEntry(CheckReport.ResultType.INFO, message);
            return;
        }
        if (nativeDataType == null || nativeDataType.equals("")) {
            String message = String.format("No native data type is provided for %s parameter '%s'. The The parameter is of type user defined, providing the native data type is required.", new Object[]{accessType, name});
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
            return;
        }
        if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            this.isValidClassName(nativeDataType);
            return;
        }
        if (dataType == ProcessConstants.AdeptDataType.URI || dataType == ProcessConstants.AdeptDataType.STRING) {
            return;
        }
        switch (dataType) {
            case BOOLEAN: {
                allowedTypes = new String[]{"boolean", "Boolean"};
                break;
            }
            case DATE: {
                allowedTypes = new String[]{"long", "Long", "java.util.Date", "java.util.Calendar"};
                break;
            }
            case FLOAT: {
                allowedTypes = new String[]{"float", "Float", "double", "Double"};
                break;
            }
            case INTEGER: {
                allowedTypes = new String[]{"boolean", "Boolean", "char", "Character", "byte", "Byte", "int", "Integer", "long", "Long"};
                break;
            }
            case STRING: 
            case URI: 
            case USERDEFINED: {
                assert (false) : "Unreachable code";
                allowedTypes = new String[]{};
                break;
            }
            default: {
                assert (false) : "Unkknown data type: " + (Object)((Object)dataType);
                allowedTypes = new String[]{};
            }
        }
        HashSet typeSet = new HashSet(allowedTypes.length);
        Collections.addAll(typeSet, allowedTypes);
        if (!typeSet.contains(nativeDataType)) {
            String message = String.format("The native data type '%s' provided for %s parameter '%s' is incompatible with its ADEPT2 data type %s.", new Object[]{nativeDataType, accessType, name, dataType});
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
            return;
        }
    }

    public boolean checkGUIContext(String guiContextID) {
        boolean allOK = true;
        if (!guiContextID.equals("NullContext")) {
            allOK = false;
            String message = String.format("The Java environment only supports the %s context, but the context %s is used.", "NullContext", guiContextID);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
        }
        return allOK;
    }
}

