/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.javasupport.checks;

import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JavaCheckTools {
    static final String CHECK_ID = "Java Activity Check";
    protected static final Logger logger = LoggerTools.getLogger(JavaCheckTools.class);

    public static boolean isValidTypeName(String typeName) {
        String className = typeName.replaceAll(Pattern.quote("[]"), "");
        char[] charArray = className.toCharArray();
        boolean idStart = true;
        int i = 0;
        while (i < charArray.length) {
            int currentCodePoint = Character.codePointAt(charArray, i);
            if (idStart) {
                if (!Character.isJavaIdentifierStart(currentCodePoint)) {
                    return false;
                }
                idStart = false;
            } else if (currentCodePoint == 46) {
                if (idStart) {
                    return false;
                }
                idStart = true;
            } else if (!Character.isJavaIdentifierPart(currentCodePoint)) {
                return false;
            }
            ++i;
        }
        return Character.codePointAt(charArray, charArray.length - 1) != 46;
    }
}

