/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.javasupport.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;

public class GenericJavaMethodExecutionEnvironment
extends ExecutionEnvironment {
    public static final String GENERIC_JAVA_OPERATTION_NAME = "Generic Java Operation";
    public static final String ATC_CLASS_NAME = "ClassName";
    public static final String ATC_METHOD_NAME = "MethodName";
    public static final String PATC_POSITION = "position";
    public static final String PATC_NATIVE_DATA_TYPE = "NativeDataType";

    public GenericJavaMethodExecutionEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        RuntimeEnvironment runtime = this.sessionContext.getRuntimeEnvironment();
        ActivityConfiguration configuration = this.activityInstance.getConfiguration();
        String className = configuration.getString(ATC_CLASS_NAME);
        String methodName = configuration.getString(ATC_METHOD_NAME);
        if (methodName == null) {
            methodName = this.activityInstance.getOperationName();
        }
        Object javaObject = null;
        Class<?>[] operationParameterTypes = this.getInputParameterTypes();
        Object[] operationParameterValues = this.getInputParameterValues();
        this.checkOutputParameterTypes(operationParameterTypes.length);
        try {
            Class<?> javaClass = Class.forName(className);
            Method javaMethod = javaClass.getMethod(methodName, operationParameterTypes);
            try {
                javaObject = this.createObject(javaClass, operationParameterTypes, operationParameterValues);
            }
            catch (IllegalAccessException iae) {
                String errorMessage = "Insufficient rights to access constructor for '" + className + "'. Trying to call method statically.";
                this.logger.log(Level.SEVERE, errorMessage, iae);
            }
            catch (InstantiationException ie) {
                String errorMessage = "Class '" + className + "' cannot be instantiated. Trying " + "to call method statically.";
                this.logger.log(Level.SEVERE, errorMessage, ie);
            }
            catch (InvocationTargetException ite) {
                String errorMessage = "Constructor of class '" + className + "' threw an '" + ite + "'. Trying to call method statically.";
                this.logger.log(Level.SEVERE, errorMessage, ite);
            }
            Object returnValue = javaMethod.invoke(javaObject, operationParameterValues);
            this.writeOutputValues(returnValue, operationParameterValues);
            runtime.applicationClosed();
        }
        catch (ClassNotFoundException cnfe) {
            String errorMessage = "Java class '" + className + "' not found in classpath. " + "Application failed.";
            this.logger.log(Level.SEVERE, errorMessage, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            String errorMessage = String.format("Java method '%1$s.%2$s' does not exist with the specified parameters. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, nsme);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericJavaMethodExecEnvironment:NoSuchMethod", 1100000L, nsme);
        }
        catch (IllegalArgumentException iae) {
            String errorMessage = String.format("The method '%1$s.%2$s' does not have a valid instance to be called on. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, iae);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericJavaMethodExecEnvironment:IllegalArgument", 1100001L, iae);
        }
        catch (IllegalAccessException iae) {
            String errorMessage = String.format("Insufficient rights to access '%1$s.%2$s'. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, iae);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericJavaMethodExecEnvironment:IllegalAccess", 1100002L, iae);
        }
        catch (InvocationTargetException ite) {
            String errorMessage = String.format("Method '%1$s.%2$s' threw an InvocationTargetException. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, ite);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericJavaMethodExecEnvironment:InvocationTarget", 1100003L, ite);
        }
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    protected void checkOutputParameterTypes(int numberOfOperationParameters) {
        Set<ProcessModelParameter> outputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        for (ProcessModelParameter parameter : outputParameters) {
            String pos = parameter.getConfiguration().getString(PATC_POSITION);
            if (pos == null) {
                this.logger.info("No position set for parameter " + parameter.getName());
                continue;
            }
            int position = Integer.parseInt(pos);
            if (position <= 0 || position > numberOfOperationParameters) continue;
            String parameterName = parameter.getName();
            if (parameter.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) {
                String errorMessage = String.format("Output parameter '%1s' must be of type AdeptDataType.USERDEFINED", parameterName);
                this.logger.log(Level.SEVERE, errorMessage);
                throw new ApplicationEnvironmentException(errorMessage, 1100004L);
            }
            ProcessModelParameter correspondingInputParameter = this.activityInstance.getParameter(parameterName, ActivityConstants.AccessType.READ);
            if (correspondingInputParameter != null) {
                pos = correspondingInputParameter.getConfiguration().getString(PATC_POSITION);
                int correspondingPosition = -1;
                if (pos != null) {
                    correspondingPosition = Integer.parseInt(pos);
                } else {
                    this.logger.info("No position set for parameter " + correspondingInputParameter.getName());
                }
                assert (correspondingPosition == position) : String.format("The output parameter '%1s' and its corresponding input parameter have different positions!", parameterName);
                if (correspondingInputParameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) continue;
                String errorMessage = String.format("The corresponding input parameter to the output parameter '%1s' must be of type AdeptDataType.USERDEFINED!", parameterName);
                this.logger.log(Level.SEVERE, errorMessage);
                throw new ApplicationEnvironmentException(errorMessage, 1100004L);
            }
            String errorMessage = "For the output parameter '" + parameterName + "' does not exist a corresponding input parameter. This " + "is illegal for a Java-method.";
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationEnvironmentException(errorMessage, 1100005L);
        }
    }

    private String getNativeDataType(ProcessModelParameter parameter, boolean output) {
        return parameter.getConfiguration().getString(PATC_NATIVE_DATA_TYPE);
    }

    @Override
    protected Class<?> getCorrespondingJavaClass(ProcessModelParameter parameter, boolean output) {
        Class<Comparable<Boolean>> ret;
        String nativeDataType = this.getNativeDataType(parameter, output);
        String dataType = nativeDataType == null ? parameter.getDataType().name() : nativeDataType;
        if (dataType.equals("boolean")) {
            ret = Boolean.TYPE;
        } else if (dataType.equals("char")) {
            ret = Character.TYPE;
        } else if (dataType.equals("byte")) {
            ret = Byte.TYPE;
        } else if (dataType.equals("short")) {
            ret = Short.TYPE;
        } else if (dataType.equals("int")) {
            ret = Integer.TYPE;
        } else if (dataType.equals("long")) {
            ret = Long.TYPE;
        } else if (dataType.equals("float")) {
            ret = Float.TYPE;
        } else if (dataType.equals("double")) {
            ret = Double.TYPE;
        } else {
            try {
                ret = Class.forName(dataType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ret = super.getCorrespondingJavaClass(parameter, output);
            }
        }
        return ret;
    }

    @Override
    protected Object integerToNativeTypedValue(Long value, ProcessModelParameter parameter, boolean output) {
        Object ret;
        String nativeDataType = this.getNativeDataType(parameter, output);
        if (nativeDataType != null) {
            if (nativeDataType.equals("boolean") || nativeDataType.equals("Boolean")) {
                ret = value != 0L;
            } else if (nativeDataType.equals("char") || nativeDataType.equals("Character")) {
                ret = Character.valueOf((char)value.intValue());
            } else if (nativeDataType.equals("byte") || nativeDataType.equals("Byte")) {
                ret = value.byteValue();
            } else if (nativeDataType.equals("short") || nativeDataType.equals("Short")) {
                ret = value.shortValue();
            } else if (nativeDataType.equals("int") || nativeDataType.equals("Integer")) {
                ret = value.intValue();
            } else if (nativeDataType.equals("long") || nativeDataType.equals("Long")) {
                ret = value;
            } else {
                ret = value;
                this.logger.warning(String.format("Parameter '%s' (%s) can not be converted to native data type '%s'.", new Object[]{parameter.getName(), parameter.getDataType(), nativeDataType}));
            }
        } else {
            ret = super.integerToNativeTypedValue(value, parameter, output);
        }
        return ret;
    }

    @Override
    protected Object floatToNativeTypedValue(Double value, ProcessModelParameter parameter, boolean output) {
        Object ret;
        String nativeDataType = this.getNativeDataType(parameter, output);
        if (nativeDataType != null) {
            if (nativeDataType.equals("float") || nativeDataType.equals("Float")) {
                ret = Float.valueOf(value.floatValue());
            } else if (nativeDataType.equals("double") || nativeDataType.equals("Double")) {
                ret = value;
            } else {
                ret = value;
                this.logger.warning(String.format("Parameter '%s' (%s) can not be converted to native data type '%s'.", new Object[]{parameter.getName(), parameter.getDataType(), nativeDataType}));
            }
        } else {
            ret = super.floatToNativeTypedValue(value, parameter, output);
        }
        return ret;
    }

    @Override
    protected Object dateToNativeTypedValue(Date value, ProcessModelParameter parameter, boolean output) {
        Object ret;
        String nativeDataType = this.getNativeDataType(parameter, output);
        if (nativeDataType != null) {
            if (nativeDataType.equals("long") || nativeDataType.equals("Long")) {
                ret = value.getTime();
            } else if (nativeDataType.equals("java.util.Date")) {
                ret = value;
            } else if (nativeDataType.equals("java.util.Calendar")) {
                ret = Calendar.getInstance();
                ((Calendar)ret).setTime(value);
            } else {
                ret = value;
                this.logger.warning(String.format("Parameter '%s' (%s) can not be converted to native data type '%s'.", new Object[]{parameter.getName(), parameter.getDataType(), nativeDataType}));
            }
        } else {
            ret = super.dateToNativeTypedValue(value, parameter, output);
        }
        return ret;
    }

    @Override
    protected Long objectToInteger(Object value, ProcessModelParameter parameter, boolean output) {
        Long ret = null;
        String nativeDataType = this.getNativeDataType(parameter, output);
        if (nativeDataType != null && !nativeDataType.equals("")) {
            if (nativeDataType.equals("boolean") || nativeDataType.equals("Boolean")) {
                long longValue = (Boolean)value != false ? 1L : 0L;
                ret = longValue;
            } else if (nativeDataType.equals("char") || nativeDataType.equals("Character")) {
                long longValue = ((Character)value).charValue();
                ret = longValue;
            } else if (nativeDataType.equals("byte") || nativeDataType.equals("Byte")) {
                long longValue = ((Byte)value).longValue();
                ret = longValue;
            } else if (nativeDataType.equals("short") || nativeDataType.equals("Short")) {
                long longValue = ((Short)value).longValue();
                ret = longValue;
            } else if (nativeDataType.equals("int") || nativeDataType.equals("Integer")) {
                long longValue = ((Integer)value).longValue();
                ret = longValue;
            } else if (nativeDataType.equals("long") || nativeDataType.equals("Long")) {
                ret = (Long)value;
            } else {
                this.logger.warning(String.format("Parameter '%s' (native data type '%s' can not be converted to %s.", new Object[]{parameter.getName(), nativeDataType, parameter.getDataType()}));
            }
        } else {
            ret = super.objectToInteger(value, parameter, output);
        }
        return ret;
    }

    @Override
    protected Double objectToFloat(Object value, ProcessModelParameter parameter, boolean output) {
        Double ret = null;
        String nativeDataType = this.getNativeDataType(parameter, output);
        if (nativeDataType != null && !nativeDataType.equals("")) {
            if (nativeDataType.equals("float") || nativeDataType.equals("Float")) {
                double doubleValue = ((Float)value).doubleValue();
                ret = doubleValue;
            } else if (nativeDataType.equals("double") || nativeDataType.equals("Double")) {
                ret = (Double)value;
            } else {
                this.logger.warning(String.format("Parameter '%1$s' (native data type '%2$s' can not be converted to FLOAT.", parameter.getName(), nativeDataType));
            }
        } else {
            ret = super.objectToFloat(value, parameter, output);
        }
        return ret;
    }

    @Override
    protected Date objectToDate(Object value, ProcessModelParameter parameter, boolean output) {
        Date ret = null;
        String nativeDataType = this.getNativeDataType(parameter, output);
        if (nativeDataType != null && !nativeDataType.equals("")) {
            if (nativeDataType.equals("long") || nativeDataType.equals("Long")) {
                ret = new Date((Long)value);
            } else if (nativeDataType.equals("java.util.Date")) {
                ret = (Date)value;
            } else if (nativeDataType.equals("java.util.Calendar")) {
                ret = ((Calendar)value).getTime();
            } else {
                this.logger.warning(String.format("Parameter '%s' (native data type '%s' can not be converted to %s.", new Object[]{parameter.getName(), nativeDataType, parameter.getDataType()}));
            }
        } else {
            ret = super.objectToDate(value, parameter, output);
        }
        return ret;
    }

    protected Object createObject(Class<?> javaClass, Class<?>[] inputParameterTypes, Object[] inputParameterValues) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object ret;
        try {
            Constructor<?> javaConstructor = javaClass.getConstructor(new Class[0]);
            ret = javaConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ret = null;
        }
        return ret;
    }
}

