/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.javasupport.environments;

import de.aristaflow.adept2.extensions.javasupport.environments.GenericJavaMethodExecutionEnvironment;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ComponentObjectInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Level;

public class JavaByteArrayReturnEE
extends GenericJavaMethodExecutionEnvironment {
    public JavaByteArrayReturnEE(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    protected UDTValue objectToUserdefined(Object value, ProcessModelParameter parameter, boolean output) {
        UDTValue ret;
        try {
            Array.getByte(value, 1);
            byte[] byteArray = new byte[Array.getLength(value)];
            int i = 0;
            while (i < byteArray.length) {
                byteArray[i] = Array.getByte(value, i);
                ++i;
            }
            ret = new ADEPT2UDTValue(parameter.getUDTName(), byteArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ret = super.objectToUserdefined(value, parameter, output);
        }
        return ret;
    }

    @Override
    protected Object userdefinedToNativeTypedValue(UDTValue value, ProcessModelParameter parameter, boolean output) {
        Object ret;
        try {
            ComponentObjectInputStream ois = new ComponentObjectInputStream(value.getValueAsStream());
            ret = ois.readObject();
        }
        catch (IOException iOException) {
            ret = value.getValueAsArray();
        }
        catch (ClassNotFoundException cnfe) {
            String errorMessage = String.format("Unable to convert the value of a UDTValue ('%1$s') to an object because the corresponding class is not found.", parameter.getName());
            this.logger.log(Level.SEVERE, errorMessage, cnfe);
            throw new ApplicationEnvironmentException(errorMessage, -402200L);
        }
        return ret;
    }
}

