/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.javasupport.environments;

import de.aristaflow.adept2.extensions.javasupport.environments.GenericJavaMethodExecutionEnvironment;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class JavaObjectGraphMethodEnvironment
extends GenericJavaMethodExecutionEnvironment {
    public JavaObjectGraphMethodEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        RuntimeEnvironment runtime = this.sessionContext.getRuntimeEnvironment();
        String methodName = this.activityInstance.getOperationName();
        Class<?>[] activityInputParameterTypes = this.getInputParameterTypes();
        this.checkOutputParameterTypes(activityInputParameterTypes.length);
        Class<?> javaClass = activityInputParameterTypes[0];
        String className = javaClass.getName();
        Class[] objectParameterTypes = new Class[activityInputParameterTypes.length - 1];
        System.arraycopy(activityInputParameterTypes, 1, objectParameterTypes, 0, objectParameterTypes.length);
        Object[] activityInputParameterValues = this.getInputParameterValues();
        Object javaObject = activityInputParameterValues[0];
        Object[] objectParameterValues = new Object[activityInputParameterValues.length - 1];
        System.arraycopy(activityInputParameterValues, 1, objectParameterValues, 0, objectParameterValues.length);
        try {
            Method javaMethod = javaClass.getMethod(methodName, objectParameterTypes);
            Object returnValue = javaMethod.invoke(javaObject, objectParameterValues);
            System.arraycopy(objectParameterValues, 0, activityInputParameterValues, 1, objectParameterValues.length);
            this.writeOutputValues(returnValue, activityInputParameterValues);
            runtime.applicationClosed();
        }
        catch (NoSuchMethodException nsme) {
            String errorMessage = String.format("Java method '%1$s.%2$s' does not exist with the specified parameters. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, nsme);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:JavaObjectGraphMethodEnvironment:NoSuchMethod", 1100000L, nsme);
        }
        catch (IllegalArgumentException iae) {
            String errorMessage = String.format("The method '%1$s.%2$s' does not have a valid instance to be called on. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, iae);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:JavaObjectGraphMethodEnvironment:IllegalArgument", 1100001L, iae);
        }
        catch (IllegalAccessException iae) {
            String errorMessage = String.format("Insufficient rights to access '%1$s.%2$s'. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, iae);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:JavaObjectGraphMethodEnvironment:IllegalAccess", 1100002L, iae);
        }
        catch (InvocationTargetException ite) {
            String errorMessage = String.format("Method '%1$s.%2$s' threw an InvocationTargetException. Application failed.", className, methodName);
            this.logger.log(Level.SEVERE, errorMessage, ite);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:JavaObjectGraphMethodEnvironment:InvocationTarget", 1100003L, ite);
        }
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }
}

