/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.mailsupport.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.extensions.tools.checks.AbstractStringFormatComponentCheck;
import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LocaleTools;
import de.aristaflow.adept2.util.StringTools;
import java.util.Locale;
import org.apache.commons.configuration.Configuration;

public class FormattingMailComponentCheck
extends AbstractStringFormatComponentCheck {
    public static final String ID = "de.aristaflow.tools.mail.FormattingMailer#Check";

    public FormattingMailComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super(checkProvider, "de.aristaflow.tools.mail.FormattingMailer", ID);
    }

    public FormattingMailComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        String msg;
        ActivityConfiguration conf = activity.getConfiguration();
        AbstractStringFormatComponent.FormatStyle formatStyle = null;
        if (this.checkDualStringInputParameter(activity, "FormatStyle") && conf.getString("FormatStyle") != null && (formatStyle = AbstractStringFormatComponent.FormatStyle.fromToken(conf.getString("FormatStyle"))) == null) {
            String msg2 = "The specified format style '%s' in the activity configuration field '%s' is not one of the allowed values: %s";
            msg2 = String.format(msg2, conf.getString("FormatStyle"), "FormatStyle", StringTools.join(", ", (Object[])AbstractStringFormatComponent.FormatStyle.values()));
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg2);
        }
        this.performCheck(activity, formatStyle);
        Locale formatLocale = null;
        if (this.checkDualStringInputParameter(activity, "FormatLocale") && conf.getString("FormatLocale") != null && (formatLocale = LocaleTools.parseLocaleString(conf.getString("FormatLocale"))) == null) {
            String msg3 = "The specified format locale '%s' in the activity configuration field '%s' doesn't seem to be valid!";
            msg3 = String.format(msg3, conf.getString("FormatLocale"), "FormatLocale");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg3);
        }
        Object[] testFormatArguments = FormattingMailComponentCheck.getTestFormatArguments(activity.getParameters(ActivityConstants.AccessType.READ));
        if (this.checkDualStringInputParameter(activity, "MailSubject") && conf.getString("MailSubject") != null && formatStyle != null && formatLocale != null) {
            try {
                AbstractStringFormatComponent.format(formatStyle, conf.getString("MailSubject"), formatLocale, testFormatArguments);
            }
            catch (AbstractStringFormatComponent.FormatException formatException) {
                msg = "The email subject specified in the activity configuration field '%s' can't be formatted! Also check the format style and format arguments.";
                msg = String.format(msg, "MailSubject");
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        }
        if (this.checkDualStringInputParameter(activity, "MailBody") && conf.getString("MailBody") != null) {
            try {
                AbstractStringFormatComponent.format(formatStyle, conf.getString("MailBody"), formatLocale, testFormatArguments);
            }
            catch (AbstractStringFormatComponent.FormatException formatException) {
                msg = "The email body specified in the activity configuration field '%s' can't be formatted! Also check the format style and format arguments.";
                msg = String.format(msg, "MailBody");
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        }
        this.checkDualStringInputParameter(activity, "MailTo");
        this.checkDualStringInputParameter(activity, "MailFrom");
        this.checkConfEntrySet(conf, "MailSMTPHostname");
    }
}

