/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.mailsupport.environments;

import de.aristaflow.adept2.base.mail.EmailAttachment;
import de.aristaflow.adept2.base.mail.EmailToolkit;
import de.aristaflow.adept2.extensions.mailsupport.environments.MailTools;
import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.LocaleTools;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.mail.EmailException;

public class FormattingMailComponent
extends AbstractStringFormatComponent {
    public static final String EC_NAME = "de.aristaflow.tools.mail.FormattingMailer";
    private byte retries;
    private long retrySleepTime;

    public FormattingMailComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        Long confRetries = this.activityInstance.getConfiguration().getInteger("MailErrorRetries");
        this.retries = confRetries == null ? (byte)3 : confRetries.byteValue();
        Long confSleepTime = this.activityInstance.getConfiguration().getInteger("MailErrorRetryWaitTime");
        this.retrySleepTime = confSleepTime == null ? 300000L : confSleepTime;
    }

    @Override
    public void initResume(int savePointID, SessionContext sessionContext) {
        super.initResume(savePointID, sessionContext);
        this.init(sessionContext);
        this.retries = sessionContext.getRuntimeEnvironment().getApplicationState(1)[0];
    }

    @Override
    public void run() {
        String formatLocaleString;
        Locale formatLocale;
        String formatStyleString = this.getDualInputParameterValue("FormatStyle", ProcessConstants.AdeptDataType.STRING, String.class);
        AbstractStringFormatComponent.FormatStyle formatStyle = AbstractStringFormatComponent.FormatStyle.fromToken(formatStyleString);
        if (formatStyle == null) {
            formatStyle = AbstractStringFormatComponent.FormatStyle.PRINTF_FORMATTER;
        }
        if ((formatLocale = LocaleTools.parseLocaleString(formatLocaleString = this.getDualInputParameterValue("FormatLocale", ProcessConstants.AdeptDataType.STRING, String.class))) == null) {
            formatLocale = Locale.getDefault();
        }
        String from = this.getDualInputParameterValue("MailFrom", ProcessConstants.AdeptDataType.STRING, String.class);
        String to = this.getDualInputParameterValue("MailTo", ProcessConstants.AdeptDataType.STRING, String.class);
        String subject = this.getDualInputParameterValue("MailSubject", ProcessConstants.AdeptDataType.STRING, String.class);
        String body = this.getDualInputParameterValue("MailBody", ProcessConstants.AdeptDataType.STRING, String.class);
        Object[] formatArguments = this.getFormatArguments();
        try {
            from = FormattingMailComponent.format(formatStyle, from, formatLocale, formatArguments);
            to = FormattingMailComponent.format(formatStyle, to, formatLocale, formatArguments);
            subject = FormattingMailComponent.format(formatStyle, subject, formatLocale, formatArguments);
            body = FormattingMailComponent.format(formatStyle, body, formatLocale, formatArguments);
        }
        catch (AbstractStringFormatComponent.FormatException ex) {
            String msg = "Formatting one of the strings failed!";
            throw new ApplicationFailedException(msg, null, 0L, ex);
        }
        try {
            this.sendViaToolkit(from, to, subject, body);
        }
        catch (EmailException e) {
            if (this.retries > 0 && EmailToolkit.checkException(e)) {
                this.sessionContext.getRuntimeEnvironment().setApplicationState(1, new byte[]{this.retries = (byte)(this.retries - 1)});
                this.sessionContext.getRuntimeEnvironment().applicationSuspended(this.retrySleepTime);
                return;
            }
            this.handleException((Exception)((Object)e));
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private Set<String> getUsedParameters() {
        HashSet<String> ret = new HashSet<String>();
        Parameter[] parameterArray = FormattingMailComponent.getFormatArgumentParameters(this.activityInstance.getParameters(ActivityConstants.AccessType.READ));
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            ret.add(p.getName());
            ++n2;
        }
        return ret;
    }

    private void sendViaToolkit(String from, String to, String subject, String body) throws EmailException {
        Boolean tls;
        String msg;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        String hostname = conf.getString("MailSMTPHostname");
        int smtpport = 0;
        if (conf.getInteger("MailSMTPPort") != null) {
            smtpport = conf.getInteger("MailSMTPPort").intValue();
        }
        String username = conf.getString("MailSMTPUsername");
        String password = conf.getString("MailSMTPPassword");
        try {
            if (password != null && password.length() > 0) {
                password = ConfigurationTools.parsePassword(password);
            }
        }
        catch (IllegalArgumentException iae) {
            msg = String.format("The password could not be decrypted, already decrypted? [%s]", iae.getMessage());
            this.logger.info(msg);
        }
        catch (GeneralSecurityException gse) {
            msg = String.format("The password could not be decrypted, already decrypted? [%s]", gse.getMessage());
            this.logger.info(msg);
        }
        boolean useTLS = (tls = conf.getBoolean("MailSMTPUseTLS")) == null ? false : tls;
        Boolean ssl = conf.getBoolean("MailSMTPUseSSL");
        boolean useSSL = ssl == null ? false : ssl;
        Boolean otf = conf.getBoolean("MailSMTPOvertrustful");
        boolean overtrustful = otf == null ? false : otf;
        List<EmailAttachment> attachments = MailTools.getAttachments(this.logger, this.activityInstance.getParameters(ActivityConstants.AccessType.READ), this.sessionContext.getDataContext(), this.getUsedParameters(), this.activityInstance.getName());
        EmailToolkit.sendMail(from, to.split(";"), null, null, subject, body, attachments, hostname, smtpport, username, password, useTLS, useSSL, overtrustful);
    }

    private void handleException(Exception e) {
        if (this.activityInstance.getParameter("Error", ActivityConstants.AccessType.WRITE) != null) {
            try {
                this.sessionContext.getDataContext().storeStringParameterValue("Error", e.getMessage());
            }
            catch (InvalidDataTypeException e1) {
                String errorMessage = "Could not write the output parameter 'Error', because the parameter type is not the expected one!";
                throw new ApplicationEnvironmentException(errorMessage, -401001L, e1);
            }
            catch (NoSuchParameterException e1) {
                String errorMessage = "Could not write the output parameter 'Error' to the data context, because there is no output parameter 'Error' registered!";
                throw new ApplicationEnvironmentException(errorMessage, -401000L, e1);
            }
        } else {
            throw new ApplicationFailedException("Could not send the email.", "", 0L, e);
        }
    }
}

