/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.mailsupport.environments;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.mailservice.MailService;
import de.aristaflow.adept2.extensions.mailsupport.environments.MailTools;
import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.mail.SerialisableAttachment;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.LocaleTools;
import de.aristaflow.adept2.util.types.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FormattingMailComponentViaMailService
extends AbstractStringFormatComponent {
    public static final String EC_NAME = "de.aristaflow.tools.mail.FormattingMailer";
    protected final Registry registry;
    private byte retries;
    private long retrySleepTime;

    public FormattingMailComponentViaMailService(ActivityInstance activityInstance, Registry registry) {
        super(activityInstance);
        this.registry = registry;
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        Long confRetries = this.activityInstance.getConfiguration().getInteger("MailErrorRetries");
        this.retries = confRetries == null ? (byte)3 : confRetries.byteValue();
        Long confSleepTime = this.activityInstance.getConfiguration().getInteger("MailErrorRetryWaitTime");
        this.retrySleepTime = confSleepTime == null ? 300000L : confSleepTime;
    }

    @Override
    public void initResume(int savePointID, SessionContext sessionContext) {
        super.initResume(savePointID, sessionContext);
        this.init(sessionContext);
        this.retries = sessionContext.getRuntimeEnvironment().getApplicationState(1)[0];
    }

    @Override
    public void run() {
        String formatLocaleString;
        Locale formatLocale;
        String formatStyleString = this.getDualInputParameterValue("FormatStyle", ProcessConstants.AdeptDataType.STRING, String.class);
        AbstractStringFormatComponent.FormatStyle formatStyle = AbstractStringFormatComponent.FormatStyle.fromToken(formatStyleString);
        if (formatStyle == null) {
            formatStyle = AbstractStringFormatComponent.FormatStyle.PRINTF_FORMATTER;
        }
        if ((formatLocale = LocaleTools.parseLocaleString(formatLocaleString = this.getDualInputParameterValue("FormatLocale", ProcessConstants.AdeptDataType.STRING, String.class))) == null) {
            formatLocale = Locale.getDefault();
        }
        String from = this.getDualInputParameterValue("MailFrom", ProcessConstants.AdeptDataType.STRING, String.class);
        String to = this.getDualInputParameterValue("MailTo", ProcessConstants.AdeptDataType.STRING, String.class);
        String subject = this.getDualInputParameterValue("MailSubject", ProcessConstants.AdeptDataType.STRING, String.class);
        String body = this.getDualInputParameterValue("MailBody", ProcessConstants.AdeptDataType.STRING, String.class);
        Object[] formatArguments = this.getFormatArguments();
        try {
            from = FormattingMailComponentViaMailService.format(formatStyle, from, formatLocale, formatArguments);
            to = FormattingMailComponentViaMailService.format(formatStyle, to, formatLocale, formatArguments);
            subject = FormattingMailComponentViaMailService.format(formatStyle, subject, formatLocale, formatArguments);
            body = FormattingMailComponentViaMailService.format(formatStyle, body, formatLocale, formatArguments);
        }
        catch (AbstractStringFormatComponent.FormatException ex) {
            String msg = "Formatting one of the strings failed!";
            throw new ApplicationFailedException(msg, null, 0L, ex);
        }
        try {
            Map<String, Pair<Throwable, Boolean>> errors = this.sendViaMailService(from, to, subject, body);
            for (Map.Entry<String, Pair<Throwable, Boolean>> entry : errors.entrySet()) {
                if (this.retries <= 0 || !entry.getValue().getSecond().booleanValue()) continue;
                this.sessionContext.getRuntimeEnvironment().setApplicationState(1, new byte[]{this.retries = (byte)(this.retries - 1)});
                this.sessionContext.getRuntimeEnvironment().applicationSuspended(this.retrySleepTime);
                return;
            }
        }
        catch (ServiceNotKnownException e) {
            this.handleException(e);
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private Set<String> getUsedParameters() {
        HashSet<String> ret = new HashSet<String>();
        Parameter[] parameterArray = FormattingMailComponentViaMailService.getFormatArgumentParameters(this.activityInstance.getParameters(ActivityConstants.AccessType.READ));
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            ret.add(p.getName());
            ++n2;
        }
        return ret;
    }

    private Map<String, Pair<Throwable, Boolean>> sendViaMailService(String from, String to, String subject, String body) throws ServiceNotKnownException {
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        MailService ms = this.registry.getServiceOfType(session, "MailService", MailService.class);
        List<SerialisableAttachment> attachments = MailTools.getSerialisableAttachments(this.logger, this.activityInstance.getParameters(ActivityConstants.AccessType.READ), this.sessionContext.getDataContext(), this.getUsedParameters(), this.activityInstance.getName());
        if (attachments == null || attachments.isEmpty()) {
            return ms.sendMail(session, from, Arrays.asList(to.split(";")), subject, body);
        }
        return ms.sendMail(session, from, Arrays.asList(to.split(";")), subject, body, attachments);
    }

    private void handleException(Exception e) {
        if (this.activityInstance.getParameter("Error", ActivityConstants.AccessType.WRITE) != null) {
            try {
                this.sessionContext.getDataContext().storeStringParameterValue("Error", e.getMessage());
            }
            catch (InvalidDataTypeException e1) {
                String errorMessage = "Could not write the output parameter 'Error', because the parameter type is not the expected one!";
                throw new ApplicationEnvironmentException(errorMessage, -401001L, e1);
            }
            catch (NoSuchParameterException e1) {
                String errorMessage = "Could not write the output parameter 'Error' to the data context, because there is no output parameter 'Error' registered!";
                throw new ApplicationEnvironmentException(errorMessage, -401000L, e1);
            }
        } else {
            throw new ApplicationFailedException("Could not send the email.", "", 0L, e);
        }
    }
}

