/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.mailsupport.environments;

import de.aristaflow.adept2.base.mail.EmailAttachment;
import de.aristaflow.adept2.extensions.datatypes.FileUDT;
import de.aristaflow.adept2.extensions.mailsupport.environments.UDTAttachment;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.mail.ByteArrayAttachment;
import de.aristaflow.adept2.model.mail.SerialisableAttachment;
import de.aristaflow.adept2.model.mail.URLAttachment;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class MailTools {
    public static final String CONF_MAIL_FROM = "MailFrom";
    public static final String CONF_MAIL_TO = "MailTo";
    public static final String CONF_MAIL_SUBJECT = "MailSubject";
    public static final String CONF_MAIL_BODY = "MailBody";
    public static final String CONF_MAIL_SMTP_HOSTNAME = "MailSMTPHostname";
    public static final String CONF_MAIL_SMTP_PORT = "MailSMTPPort";
    public static final String CONF_MAIL_SMTP_USERNAME = "MailSMTPUsername";
    public static final String CONF_MAIL_SMTP_PASSWORD = "MailSMTPPassword";
    public static final String CONF_MAIL_SMTP_USETLS = "MailSMTPUseTLS";
    public static final String CONF_MAIL_SMTP_USESSL = "MailSMTPUseSSL";
    public static final String CONF_MAIL_SMTP_OVERTRUSTFUL = "MailSMTPOvertrustful";
    static final String MAIL_TO_SEPARATOR = ";";
    public static final String CONF_MAIL_RETRIES = "MailErrorRetries";
    public static final String CONF_MAIL_RETRY_WAIT_TIME = "MailErrorRetryWaitTime";

    static List<EmailAttachment> getAttachments(Logger logger, Collection<ProcessModelParameter> inParams, DataContext context, Set<String> usedParameters, String activityName) {
        ArrayList<EmailAttachment> list = new ArrayList<EmailAttachment>();
        for (ProcessModelParameter param : inParams) {
            String pname = param.getName();
            try {
                String msg;
                if (param.getDataType() == ProcessConstants.AdeptDataType.URI) {
                    if (usedParameters.contains(pname)) {
                        msg = String.format("Ignore parameter '%s' as attachment, since it is used as format argument.", pname);
                        logger.info(msg);
                        continue;
                    }
                    URI uri = context.retrieveURIParameterValue(pname);
                    try {
                        URL url = uri.toURL();
                        int lastIndexOf = url.getPath().lastIndexOf(".");
                        String fileName = lastIndexOf > 0 ? pname.concat(url.getPath().substring(lastIndexOf)) : pname;
                        list.add(new EmailAttachment(url, fileName, param.getDescription()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        msg = String.format("Ignore parameter '%s' as attachment, due to a MalformedURLException ('%s' could not be converted to an URL)!", pname, uri);
                        logger.finer(msg);
                    }
                    continue;
                }
                if (param.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    UDTValue udt = context.retrieveUDTParameterValue(pname);
                    String udtName = udt.getUserDefinedType();
                    if (udtName.equals("FileUDT")) {
                        FileUDT fileUDT = new FileUDT(udt);
                        list.add(new UDTAttachment(fileUDT, fileUDT.getFileName(), param.getDescription()));
                        continue;
                    }
                    list.add(new UDTAttachment(udt, pname, param.getDescription()));
                    continue;
                }
                msg = String.format("Ignore parameter '%s' as attachment, due to its data type '%s'.", new Object[]{pname, param.getDataType()});
                logger.finest(msg);
            }
            catch (InvalidDataTypeException idte) {
                logger.warning(String.format("The input parameter '%1$s' is of type '%2$s' in the data context of activity '%3$s.", new Object[]{pname, idte.getActualDataType(), activityName}));
            }
            catch (NoSuchParameterException noSuchParameterException) {
                logger.warning(String.format("There is no input parameter of name '%1$s' in the data context of activity '%2$s'.", pname, activityName));
            }
        }
        return list;
    }

    static List<SerialisableAttachment> getSerialisableAttachments(Logger logger, Collection<ProcessModelParameter> inParams, DataContext context, Set<String> usedParameters, String activityName) {
        ArrayList<SerialisableAttachment> list = new ArrayList<SerialisableAttachment>();
        for (ProcessModelParameter param : inParams) {
            String pname = param.getName();
            try {
                String msg;
                if (param.getDataType() == ProcessConstants.AdeptDataType.URI) {
                    if (usedParameters.contains(pname)) {
                        msg = String.format("Ignore parameter '%s' as attachment, since it is used as format argument.", pname);
                        logger.info(msg);
                        continue;
                    }
                    URI uri = context.retrieveURIParameterValue(pname);
                    try {
                        URL url = uri.toURL();
                        int lastIndexOf = url.getPath().lastIndexOf(".");
                        String fileName = lastIndexOf > 0 ? pname.concat(url.getPath().substring(lastIndexOf)) : pname;
                        list.add(new URLAttachment(fileName, param.getDescription(), url));
                    }
                    catch (MalformedURLException malformedURLException) {
                        msg = String.format("Ignore parameter '%s' as attachment, due to a MalformedURLException ('%s' could not be converted to an URL)!", pname, uri);
                        logger.finer(msg);
                    }
                    continue;
                }
                if (param.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    UDTValue udt = context.retrieveUDTParameterValue(pname);
                    String udtName = udt.getUserDefinedType();
                    if (udtName.equals("FileUDT")) {
                        FileUDT fileUDT = new FileUDT(udt);
                        list.add(new ByteArrayAttachment(fileUDT.getFileName(), param.getDescription(), fileUDT.getMimetype(), fileUDT.getData()));
                        continue;
                    }
                    list.add(new de.aristaflow.adept2.model.mail.UDTAttachment(pname, param.getDescription(), udt));
                    continue;
                }
                msg = String.format("Ignore parameter '%s' as attachment, due to its data type '%s'.", new Object[]{pname, param.getDataType()});
                logger.finest(msg);
            }
            catch (InvalidDataTypeException idte) {
                logger.warning(String.format("The input parameter '%1$s' is of type '%2$s' in the data context of activity '%3$s.", new Object[]{pname, idte.getActualDataType(), activityName}));
            }
            catch (NoSuchParameterException noSuchParameterException) {
                logger.warning(String.format("There is no input parameter of name '%1$s' in the data context of activity '%2$s'.", pname, activityName));
            }
        }
        return list;
    }
}

