/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.mailsupport.environments;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.mailservice.MailService;
import de.aristaflow.adept2.core.runtimemanager.executionenvironments.SystemExecutionEnvironment;
import de.aristaflow.adept2.extensions.mailsupport.environments.MailTools;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.mail.SerialisableAttachment;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.types.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SimpleMailEEViaMailService
extends SystemExecutionEnvironment {
    @Deprecated
    private static final String CFG_FROM = "from";
    private byte retries;
    private long retrySleepTime;

    public SimpleMailEEViaMailService(ActivityInstance activityInstance, Registry registry) {
        super(activityInstance, registry);
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        Long confRetries = this.activityInstance.getConfiguration().getInteger("MailErrorRetries");
        this.retries = confRetries == null ? (byte)3 : confRetries.byteValue();
        Long confSleepTime = this.activityInstance.getConfiguration().getInteger("MailErrorRetryWaitTime");
        this.retrySleepTime = confSleepTime == null ? 300000L : confSleepTime;
    }

    @Override
    public void initResume(int savePointID, SessionContext sessionContext) {
        super.initResume(savePointID, sessionContext);
        this.init(sessionContext);
        this.retries = sessionContext.getRuntimeEnvironment().getApplicationState(1)[0];
    }

    @Override
    public void run() {
        String body;
        String subject;
        String to;
        DataContext dataContext = this.sessionContext.getDataContext();
        String identifier = "to";
        try {
            to = dataContext.retrieveStringParameterValue(identifier);
            identifier = "subject";
            subject = dataContext.retrieveStringParameterValue(identifier);
            identifier = "body";
            body = dataContext.retrieveStringParameterValue(identifier);
        }
        catch (InvalidDataTypeException e) {
            String errorMessage = "Could not read the input parameter '" + identifier + "', because the " + "parameter type is not the expected one!";
            throw new ApplicationEnvironmentException(errorMessage, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String errorMessage = "Could not read the input parameter '" + identifier + "' from the data " + "context, because there is no input parameter '" + identifier + "' registered!";
            throw new ApplicationEnvironmentException(errorMessage, -401000L, e);
        }
        try {
            ActivityConfiguration conf = this.activityInstance.getConfiguration();
            String from = conf.getString("MailFrom");
            if (from == null) {
                from = conf.getString(CFG_FROM);
            }
            if (from == null || from.length() < 1) {
                throw new ApplicationEnvironmentException("The sender of the email must be set!", -1L);
            }
            Map<String, Pair<Throwable, Boolean>> errors = this.sendViaMailService(from, to, subject, body);
            for (Map.Entry<String, Pair<Throwable, Boolean>> entry : errors.entrySet()) {
                if (this.retries > 0 && entry.getValue().getSecond().booleanValue()) {
                    this.sessionContext.getRuntimeEnvironment().setApplicationState(1, new byte[]{this.retries = (byte)(this.retries - 1)});
                    this.sessionContext.getRuntimeEnvironment().applicationSuspended(this.retrySleepTime);
                    return;
                }
                this.handleException(entry.getValue().getFirst());
            }
        }
        catch (ServiceNotKnownException e) {
            this.handleException(e);
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private Map<String, Pair<Throwable, Boolean>> sendViaMailService(String from, String to, String subject, String body) throws ServiceNotKnownException {
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        MailService ms = this.registry.getServiceOfType(session, "MailService", MailService.class);
        List<SerialisableAttachment> attachments = MailTools.getSerialisableAttachments(this.logger, this.activityInstance.getParameters(ActivityConstants.AccessType.READ), this.sessionContext.getDataContext(), new HashSet<String>(), this.activityInstance.getName());
        if (attachments == null || attachments.isEmpty()) {
            return ms.sendMail(session, from, Arrays.asList(to.split(";")), subject, body);
        }
        return ms.sendMail(session, from, Arrays.asList(to.split(";")), subject, body, attachments);
    }

    private void handleException(Throwable e) {
        if (this.activityInstance.getParameter("Error", ActivityConstants.AccessType.WRITE) != null) {
            try {
                this.sessionContext.getDataContext().storeStringParameterValue("Error", e.getMessage());
            }
            catch (InvalidDataTypeException e1) {
                String errorMessage = "Could not write the output parameter 'Error', because the parameter type is not the expected one!";
                throw new ApplicationEnvironmentException(errorMessage, -401001L, e1);
            }
            catch (NoSuchParameterException e1) {
                String errorMessage = "Could not write the output parameter 'Error' to the data context, because there is no output parameter 'Error' registered!";
                throw new ApplicationEnvironmentException(errorMessage, -401000L, e1);
            }
        } else {
            throw new ApplicationFailedException("Could not send the email.", "", -1L, e);
        }
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }
}

