/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.mailsupport.environments;

import de.aristaflow.adept2.base.mail.EmailAttachment;
import de.aristaflow.adept2.base.mail.EmailToolkit;
import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.extensions.mailsupport.environments.MailTools;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.mail.EmailException;

public class SimpleMailExecutionEnvironment
extends ExecutionEnvironment {
    @Deprecated
    private static final String CFG_FROM = "from";
    @Deprecated
    private static final String CFG_HOSTNAME = "hostname";
    @Deprecated
    private static final String CFG_SMTPPORT = "smtpport";
    @Deprecated
    private static final String CFG_USERNAME = "username";
    @Deprecated
    private static final String CFG_PASSWORD = "password";
    private byte retries;
    private long retrySleepTime;

    public SimpleMailExecutionEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        Long confRetries = this.activityInstance.getConfiguration().getInteger("MailErrorRetries");
        this.retries = confRetries == null ? (byte)3 : confRetries.byteValue();
        Long confSleepTime = this.activityInstance.getConfiguration().getInteger("MailErrorRetryWaitTime");
        this.retrySleepTime = confSleepTime == null ? 300000L : confSleepTime;
    }

    @Override
    public void initResume(int savePointID, SessionContext sessionContext) {
        super.initResume(savePointID, sessionContext);
        this.init(sessionContext);
        this.retries = sessionContext.getRuntimeEnvironment().getApplicationState(1)[0];
    }

    @Override
    public void run() {
        String body;
        String subject;
        String to;
        DataContext dataContext = this.sessionContext.getDataContext();
        String identifier = "to";
        try {
            to = dataContext.retrieveStringParameterValue(identifier);
            identifier = "subject";
            subject = dataContext.retrieveStringParameterValue(identifier);
            identifier = "body";
            body = dataContext.retrieveStringParameterValue(identifier);
        }
        catch (InvalidDataTypeException e) {
            String errorMessage = "Could not read the input parameter '" + identifier + "', because the " + "parameter type is not the expected one!";
            throw new ApplicationEnvironmentException(errorMessage, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String errorMessage = "Could not read the input parameter '" + identifier + "' from the data " + "context, because there is no input parameter '" + identifier + "' registered!";
            throw new ApplicationEnvironmentException(errorMessage, -401000L, e);
        }
        try {
            ActivityConfiguration conf = this.activityInstance.getConfiguration();
            String from = conf.getString("MailFrom");
            if (from == null) {
                from = conf.getString(CFG_FROM);
            }
            if (from == null || from.length() < 1) {
                throw new ApplicationEnvironmentException("The sender of the email must be set!", -1L);
            }
            this.sendViaToolkit(from, to, subject, body);
        }
        catch (EmailException e) {
            if (this.retries > 0 && EmailToolkit.checkException(e)) {
                this.sessionContext.getRuntimeEnvironment().setApplicationState(1, new byte[]{this.retries = (byte)(this.retries - 1)});
                this.sessionContext.getRuntimeEnvironment().applicationSuspended(this.retrySleepTime);
                return;
            }
            this.handleException((Exception)((Object)e));
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private void sendViaToolkit(String from, String to, String subject, String body) throws EmailException {
        String msg;
        String password;
        String username;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        String hostname = conf.getString("MailSMTPHostname");
        if (hostname == null) {
            hostname = conf.getString(CFG_HOSTNAME);
        }
        if (hostname == null || hostname.length() < 1) {
            throw new ApplicationEnvironmentException("The smtp hostname must be set to send emails!", -1L);
        }
        int smtpport = 0;
        Long port = conf.getInteger("MailSMTPPort");
        if (port == null) {
            port = conf.getInteger(CFG_SMTPPORT);
        }
        if (port != null) {
            smtpport = port.intValue();
        }
        if ((username = conf.getString("MailSMTPUsername")) == null) {
            username = conf.getString(CFG_USERNAME);
        }
        if ((password = conf.getString("MailSMTPPassword")) == null) {
            password = conf.getString(CFG_PASSWORD);
        }
        try {
            if (password != null && password.length() > 0) {
                password = ConfigurationTools.parsePassword(password);
            }
        }
        catch (IllegalArgumentException iae) {
            msg = String.format("The password could not be decrypted, already decrypted? [%s]", iae.getMessage());
            this.logger.info(msg);
        }
        catch (GeneralSecurityException gse) {
            msg = String.format("The password could not be decrypted, already decrypted? [%s]", gse.getMessage());
            this.logger.info(msg);
        }
        List<EmailAttachment> attachments = MailTools.getAttachments(this.logger, this.activityInstance.getParameters(ActivityConstants.AccessType.READ), this.sessionContext.getDataContext(), new HashSet<String>(), this.activityInstance.getName());
        Boolean tls = conf.getBoolean("MailSMTPUseTLS");
        boolean useTLS = tls == null ? false : tls;
        Boolean ssl = conf.getBoolean("MailSMTPUseSSL");
        boolean useSSL = ssl == null ? false : ssl;
        Boolean otf = conf.getBoolean("MailSMTPOvertrustful");
        boolean overtrustful = otf == null ? false : otf;
        EmailToolkit.sendMail(from, to.split(";"), null, null, subject, body, attachments, hostname, smtpport, username, password, useTLS, useSSL, overtrustful);
    }

    private void handleException(Exception e) {
        if (this.activityInstance.getParameter("Error", ActivityConstants.AccessType.WRITE) != null) {
            try {
                this.sessionContext.getDataContext().storeStringParameterValue("Error", e.getMessage());
            }
            catch (InvalidDataTypeException e1) {
                String errorMessage = "Could not write the output parameter 'Error', because the parameter type is not the expected one!";
                throw new ApplicationEnvironmentException(errorMessage, -401001L, e1);
            }
            catch (NoSuchParameterException e1) {
                String errorMessage = "Could not write the output parameter 'Error' to the data context, because there is no output parameter 'Error' registered!";
                throw new ApplicationEnvironmentException(errorMessage, -401000L, e1);
            }
        } else {
            throw new ApplicationFailedException("Could not send the email.", "", -1L, e);
        }
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }
}

