/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.omaccess.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.core.orgmodelmanager.parser.OrgPolicyParser;
import de.aristaflow.adept2.extensions.omaccess.common.OmacTools;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.paramref.ParameterRefParser;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.CheckReport;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class OrgModelAccessComponentCheck
extends AbstractExecutableComponentCheck {
    public static final String ID = "de.aristaflow.omaccess.OrgModelAccessComponent#Check";

    public OrgModelAccessComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        super("de.aristaflow.omaccess.OrgModelAccessComponent", ID);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        String opName = activity.getOperationName();
        if (opName.equals("getAttribute")) {
            this.checkOp_getAttribute(activity);
        } else if (opName.equals("createEntity")) {
            this.checkOp_createEntity(activity);
        } else if (opName.equals("updateEntity")) {
            this.checkOp_updateEntity(activity);
        } else if (opName.equals("deleteEntity")) {
            this.checkOp_deleteEntity(activity);
        } else if (opName.equals("addRelation")) {
            this.checkOp_addRelation(activity);
        } else if (opName.equals("removeRelation")) {
            this.checkOp_removeRelation(activity);
        } else if (opName.equals("findEntities")) {
            this.checkOp_findEntities(activity);
        } else {
            String msg = "Unknown operation encountered: " + opName;
            this.addReportEntry(CheckReport.ResultType.WARNING, msg);
        }
    }

    private void checkOp_getAttribute(AbstractActivity activity) {
        EntityType entityType;
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.isConfEntrySet(conf, "EntityType")) {
            if (this.checkConfValueAvailable(conf, "EntityType") && (entityType = EntityType.fromPolicyToken(conf.getString("EntityType"))) == null) {
                String msg = "The entry '%s' of the activity's configuration specifies an unknown entity type: %s";
                msg = String.format(msg, "EntityType", conf.getString("EntityType"));
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            Parameter param = activity.getParameter("EntityID", ActivityConstants.AccessType.READ);
            if (param != null) {
                entityType = EntityType.fromIdentifierID(param.getIdentifierID());
                if (entityType == null) {
                    String string2 = "The identifier of input parameter '%s' does not identify an entity type: %s";
                    string2 = String.format(string2, "EntityID", param.getIdentifierID());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, string2);
                }
            } else {
                String string3 = "The entity type must either be supplied in the activity type configuration field '%s' or using an appropriate identifier at the input parameter '%s'!";
                string3 = String.format(string3, "EntityType", "EntityID");
                this.addReportEntry(CheckReport.ResultType.FAILURE, string3);
            }
        }
        if (this.isConfEntrySet(conf, "OrgPolicy")) {
            if (this.checkConfValueAvailable(conf, "OrgPolicy")) {
                String orgPolicyPattern = conf.getString("OrgPolicy");
                OrgPolicyReport orgPolicyReport = new OrgPolicyReport();
                OrgPolicyParser.getInstance().parse(orgPolicyPattern, orgPolicyReport, true, false, false, null);
                if (orgPolicyReport.getOverallResult() == OrgPolicyReport.ResultType.ERROR) {
                    String firstError = null;
                    int i = 0;
                    while (i < orgPolicyReport.getEntryCount()) {
                        firstError = orgPolicyReport.getEntryAt(i).getDescription();
                        ++i;
                    }
                    String msg = "The org policy in the activity configuration field '%s' contains at least one problem: %s";
                    msg = String.format(msg, "OrgPolicy", firstError);
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
                ParameterRefParser parser = SystemDataTools.getParser(orgPolicyPattern);
                while (parser.findNext()) {
                    String msg;
                    String paramName = parser.getParameterRef().getName();
                    Parameter param = activity.getParameter(paramName, ActivityConstants.AccessType.READ);
                    if (param == null) {
                        msg = "The referenced input parameter '%s' does not exist!";
                        msg = String.format(msg, paramName);
                        this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                        continue;
                    }
                    if (parser.getParameterRef().getDataType() == param.getDataType()) continue;
                    msg = "The referenced input parameter '%s' does not have the expected data type %s!";
                    msg = String.format(msg, new Object[]{paramName, parser.getParameterRef().getDataType()});
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
            }
        } else {
            this.checkDualIntegerInputParameter(activity, "EntityID");
        }
        Set<? extends Parameter> outputParams = activity.getParameters(ActivityConstants.AccessType.WRITE);
        for (Parameter parameter : outputParams) {
            this.checkParameter(parameter, ActivityConstants.AccessType.WRITE, ProcessConstants.AdeptDataType.INTEGER, ProcessConstants.AdeptDataType.FLOAT, ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.DATE, ProcessConstants.AdeptDataType.USERDEFINED);
            this.checkATPCFieldPresent(parameter, ActivityConstants.AccessType.WRITE, "AttributeName");
        }
    }

    private void checkOp_createEntity(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.isConfEntrySet(conf, "EntityType")) {
            EntityType entityType;
            if (this.checkConfValueAvailable(conf, "EntityType") && (entityType = EntityType.fromPolicyToken(conf.getString("EntityType"))) == null) {
                String msg = "The entry '%s' of the activity's configuration specifies an unknown entity type: %s";
                msg = String.format(msg, "EntityType", conf.getString("EntityType"));
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            String msg = "The entry '%s' of the activity's configuration is missing.";
            msg = String.format(msg, "EntityType");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        this.checkParameter(activity, "entityID", ActivityConstants.AccessType.WRITE, true, false, ProcessConstants.AdeptDataType.INTEGER);
    }

    private void checkOp_updateEntity(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        EntityType entityType = null;
        if (this.isConfEntrySet(conf, "EntityType")) {
            if (this.checkConfValueAvailable(conf, "EntityType") && (entityType = EntityType.fromPolicyToken(conf.getString("EntityType"))) == null) {
                String msg = "The entry '%s' of the activity's configuration specifies an unknown entity type: %s";
                msg = String.format(msg, "EntityType", conf.getString("EntityType"));
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            String msg = "The entry '%s' of the activity's configuration is missing.";
            msg = String.format(msg, "EntityType");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        if (entityType == EntityType.AGENT && activity.getParameter("agentUserName", ActivityConstants.AccessType.READ) != null) {
            this.checkParameter(activity, "agentUserName", ActivityConstants.AccessType.READ, false, false, ProcessConstants.AdeptDataType.STRING);
        } else {
            this.checkParameter(activity, "entityID", ActivityConstants.AccessType.READ, false, false, ProcessConstants.AdeptDataType.INTEGER);
        }
    }

    private void checkOp_deleteEntity(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        EntityType entityType = null;
        if (this.isConfEntrySet(conf, "EntityType")) {
            if (this.checkConfValueAvailable(conf, "EntityType") && (entityType = EntityType.fromPolicyToken(conf.getString("EntityType"))) == null) {
                String msg = "The entry '%s' of the activity's configuration specifies an unknown entity type: %s";
                msg = String.format(msg, "EntityType", conf.getString("EntityType"));
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            String msg = "The entry '%s' of the activity's configuration is missing.";
            msg = String.format(msg, "EntityType");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        if (entityType == EntityType.AGENT && activity.getParameter("agentUserName", ActivityConstants.AccessType.READ) != null) {
            this.checkParameter(activity, "agentUserName", ActivityConstants.AccessType.READ, false, false, ProcessConstants.AdeptDataType.STRING);
        } else {
            this.checkParameter(activity, "entityID", ActivityConstants.AccessType.READ, false, false, ProcessConstants.AdeptDataType.INTEGER);
        }
    }

    private void checkOp_addRelation(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.isConfEntrySet(conf, "RelationType")) {
            RelationType relationType;
            if (this.checkConfValueAvailable(conf, "RelationType") && (relationType = OmacTools.parseRelationType(conf.getString("RelationType"))) == null) {
                String msg = "The entry '%s' of the activity's configuration specifies an unknown relation type: %s";
                msg = String.format(msg, "RelationType", conf.getString("RelationType"));
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            String msg = "The entry '%s' of the activity's configuration is missing.";
            msg = String.format(msg, "RelationType");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        this.checkDualIntegerInputParameter(activity, "leftEntityID", "LeftEntityID");
        this.checkDualIntegerInputParameter(activity, "rightEntityID", "RightEntityID");
    }

    private void checkOp_removeRelation(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.isConfEntrySet(conf, "RelationType")) {
            RelationType relationType;
            if (this.checkConfValueAvailable(conf, "RelationType") && (relationType = OmacTools.parseRelationType(conf.getString("RelationType"))) == null) {
                String msg = "The entry '%s' of the activity's configuration specifies an unknown relation type: %s";
                msg = String.format(msg, "RelationType", conf.getString("RelationType"));
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            String msg = "The entry '%s' of the activity's configuration is missing.";
            msg = String.format(msg, "RelationType");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        this.checkDualIntegerInputParameter(activity, "leftEntityID", "LeftEntityID");
        this.checkDualIntegerInputParameter(activity, "rightEntityID", "RightEntityID");
    }

    private void checkOp_findEntities(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.isConfEntrySet(conf, "EntityType")) {
            EntityType entityType;
            if (this.checkConfValueAvailable(conf, "EntityType") && (entityType = EntityType.fromPolicyToken(conf.getString("EntityType"))) == null) {
                String msg = "The entry '%s' of the activity's configuration specifies an unknown entity type: %s";
                msg = String.format(msg, "EntityType", conf.getString("EntityType"));
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            String msg = "The entry '%s' of the activity's configuration is missing.";
            msg = String.format(msg, "EntityType");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
    }
}

