/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.omaccess.environments;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.AttributeMetaData;
import de.aristaflow.adept2.core.orgmodelmanager.Filter;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.runtimemanager.executionenvironments.SystemExecutionEnvironment;
import de.aristaflow.adept2.extensions.omaccess.common.OmacTools;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.OrgPolicySystemDataFormatter;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OrgModelAccessComponent
extends SystemExecutionEnvironment {
    private OrgModelManager orgModelManager;

    public OrgModelAccessComponent(ActivityInstance activityInstance, Registry registry) {
        super(activityInstance, registry);
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        SessionToken session = sessionContext.getClientSessionFactory().getSessionToken();
        try {
            this.orgModelManager = this.registry.getServiceOfType(session, "OrgModelManager", OrgModelManager.class);
        }
        catch (ServiceNotKnownException serviceNotKnownException) {
            String msg = "Can not access OrgModel Manager!";
            throw new ApplicationEnvironmentException(msg, 0L);
        }
    }

    @Override
    public void run() {
        String opName = this.activityInstance.getOperationName();
        if (opName.equals("getAttribute")) {
            this.op_getAttribute();
        } else if (opName.equals("createEntity")) {
            this.op_createEntity();
        } else if (opName.equals("updateEntity")) {
            this.op_updateEntity();
        } else if (opName.equals("deleteEntity")) {
            this.op_deleteEntity();
        } else if (opName.equals("addRelation")) {
            this.op_addRelation();
        } else if (opName.equals("removeRelation")) {
            this.op_removeRelation();
        } else if (opName.equals("findEntities")) {
            this.op_findEntities();
        } else {
            String msg = "Unknown operation encountered: " + opName;
            throw new ApplicationEnvironmentException(msg, 0L);
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private void op_getAttribute() {
        String msg;
        ProcessModelParameter param;
        EntityType entityType = null;
        String orgPolicy = null;
        long entityID = Integer.MIN_VALUE;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        if (conf.getString("EntityType") != null) {
            entityType = EntityType.fromPolicyToken(conf.getString("EntityType"));
        }
        if (entityType == null && (param = this.activityInstance.getParameter("EntityID", ActivityConstants.AccessType.READ)) != null) {
            entityType = EntityType.fromIdentifierID(param.getIdentifierID());
        }
        if (entityType == null) {
            String msg2 = "No entity type has been specified!";
            throw new ApplicationEnvironmentException(msg2, 0L);
        }
        if (conf.getString("OrgPolicy") != null) {
            String orgPolicyPattern = conf.getString("OrgPolicy");
            if (entityType != EntityType.AGENT) {
                String msg3 = "The specified entity type %s does not match the resulting entity type of the provided Org Policy '%s'!";
                msg3 = String.format(msg3, new Object[]{entityType, orgPolicyPattern});
                throw new ApplicationEnvironmentException(msg3, 0L);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (ProcessModelParameter inputParam : this.activityInstance.getParameters(ActivityConstants.AccessType.READ)) {
                data.put(inputParam.getName(), this.getInputParameterValue(inputParam.getName()));
            }
            orgPolicy = SystemDataTools.format(OrgPolicySystemDataFormatter.class, orgPolicyPattern, data);
        } else {
            entityID = this.getDualInputParameterValue("EntityID", ProcessConstants.AdeptDataType.INTEGER, Long.class);
        }
        boolean asList = conf.getBoolean("AsList") == null ? false : conf.getBoolean("AsList");
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        try {
            String msg4;
            ArrayList<Long> entityIDs = new ArrayList<Long>();
            if (orgPolicy != null) {
                try {
                    Set<QualifiedAgent> result = this.orgModelManager.getPolicyResolution().resolvePolicy(session, orgPolicy);
                    for (QualifiedAgent agent : result) {
                        entityIDs.add(agent.getAgentID());
                    }
                }
                catch (PolicyResolutionException policyResolutionException) {
                    msg4 = "The provided Org Policy '%s' could not be resolved!";
                    msg4 = String.format(msg4, orgPolicy);
                    throw new ApplicationEnvironmentException(msg4, 0L);
                }
            } else {
                entityIDs.add(entityID);
            }
            if (asList) {
                HashMap lists = new HashMap();
                AttributeMetaData meta = this.orgModelManager.getModelExplorer().getAttributeMetaData(session, entityType);
                for (ProcessModelParameter param2 : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
                    String attrName = param2.getConfiguration().getString("AttributeName");
                    if (attrName == null) {
                        String msg5 = "The output parameter '%s' is missing the activity type configuration field '%s'!";
                        msg5 = String.format(msg5, param2.getName(), "AttributeName");
                        throw new ApplicationEnvironmentException(msg5, 0L);
                    }
                    if (lists.get(param2.getName()) != null) continue;
                    lists.put(param2.getName(), new ArrayList());
                }
                Iterator<Object> iterator = entityIDs.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    Entity entity = this.orgModelManager.getModelExplorer().getEntity(session, entityType, id, new String[0]);
                    for (ProcessModelParameter param3 : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
                        String attrName = param3.getConfiguration().getString("AttributeName");
                        List list = (List)lists.get(param3.getName());
                        if (attrName.equalsIgnoreCase("fullName") && meta.get(attrName) == null) {
                            String fullName = String.valueOf(entity.getString("firstName")) + " " + entity.getString("lastName");
                            list.add(fullName);
                            continue;
                        }
                        if (param3.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) {
                            String msg6 = "The output parameter's '%s' data type must be %s to store a list!";
                            msg6 = String.format(msg6, new Object[]{param3.getName(), ProcessConstants.AdeptDataType.USERDEFINED});
                            throw new ApplicationEnvironmentException(msg6, 0L);
                        }
                        if (entity.isNull(attrName)) {
                            list.add(null);
                            continue;
                        }
                        list.add(entity.get(attrName));
                    }
                }
                DataContext dataContext = this.sessionContext.getDataContext();
                for (ProcessModelParameter param4 : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
                    String msg7;
                    List list = (List)lists.get(param4.getName());
                    try {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        new ObjectOutputStream(buffer).writeObject(list);
                        ADEPT2UDTValue udtValue = new ADEPT2UDTValue(param4.getUDTName(), buffer.toByteArray());
                        dataContext.storeUDTParameterValue(param4.getName(), udtValue);
                    }
                    catch (IOException ex) {
                        msg7 = "The list could not be serialised for output parameter '%s'!";
                        msg7 = String.format(msg7, param4.getName());
                        throw new ApplicationEnvironmentException(msg7, 0L, ex);
                    }
                    catch (NoSuchParameterException ex) {
                        msg7 = "The data context of activity '%s' is missing the expected output parameter '%s'!";
                        msg7 = String.format(msg7, this.activityInstance.getName(), param4.getName());
                        throw new ApplicationEnvironmentException(msg7, 0L, ex);
                    }
                    catch (InvalidDataTypeException ex) {
                        msg7 = "The data context of activity '%s' doesn't accept the data type %s of output parameter '%s'!";
                        msg7 = String.format(msg7, new Object[]{this.activityInstance.getName(), ProcessConstants.AdeptDataType.USERDEFINED, param4.getName()});
                        throw new ApplicationEnvironmentException(msg7, 0L, ex);
                    }
                }
            } else {
                if (entityIDs.isEmpty()) {
                    msg4 = "The provided Org Policy '%s' was resolved but did not produce any results!";
                    msg4 = String.format(msg4, orgPolicy);
                    throw new ApplicationFailedException(msg4, null, 0L);
                }
                Entity entity = this.orgModelManager.getModelExplorer().getEntity(session, entityType, (Long)entityIDs.get(0), new String[0]);
                DataContext dataContext = this.sessionContext.getDataContext();
                AttributeMetaData meta = this.orgModelManager.getModelExplorer().getAttributeMetaData(session, entityType);
                block24: for (ProcessModelParameter param5 : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
                    String attrName = param5.getConfiguration().getString("AttributeName");
                    if (attrName == null) {
                        String msg8 = "The output parameter '%s' is missing the activity type configuration field '%s'!";
                        msg8 = String.format(msg8, param5.getName(), "AttributeName");
                        throw new ApplicationEnvironmentException(msg8, 0L);
                    }
                    ProcessConstants.AdeptDataType dataType = null;
                    try {
                        if (attrName.equalsIgnoreCase("fullName") && meta.get(attrName) == null) {
                            dataType = ProcessConstants.AdeptDataType.STRING;
                            String fullName = String.valueOf(entity.getString("firstName")) + " " + entity.getString("lastName");
                            dataContext.storeStringParameterValue(param5.getName(), fullName);
                            continue;
                        }
                        if (meta.get(attrName) == null) {
                            String msg9 = "The attribute '%s' of entity type %s could not be found!";
                            msg9 = String.format(msg9, attrName, entityType.policyToken());
                            throw new ApplicationFailedException(msg9, "", 0L);
                        }
                        DataType omDataType = meta.get(attrName).getDataType();
                        dataType = DataType.toAdeptDataType(omDataType);
                        if (dataType == null || dataType != param5.getDataType()) {
                            String msg10 = "The data type of the attribute '%s' does not map to the output parameter's '%s' data type %s!";
                            msg10 = String.format(msg10, new Object[]{attrName, param5.getName(), param5.getDataType()});
                            throw new ApplicationEnvironmentException(msg10, 0L);
                        }
                        if (entity.isNull(attrName)) {
                            dataContext.ignoreValue(param5.getName());
                            continue;
                        }
                        switch (dataType) {
                            case INTEGER: {
                                long value = entity.getInteger(attrName);
                                dataContext.storeIntegerParameterValue(param5.getName(), value);
                                continue block24;
                            }
                            case FLOAT: {
                                double value = entity.getFloat(attrName);
                                dataContext.storeFloatParameterValue(param5.getName(), value);
                                continue block24;
                            }
                            case STRING: {
                                String value = entity.getString(attrName);
                                dataContext.storeStringParameterValue(param5.getName(), value);
                                continue block24;
                            }
                            case DATE: {
                                Date value = entity.getDate(attrName);
                                dataContext.storeDateParameterValue(param5.getName(), value);
                                continue block24;
                            }
                            default: {
                                String msg11 = "The ADEPT data type %s is currently not supported for output parameters!";
                                msg11 = String.format(msg11, new Object[]{dataType});
                                throw new ApplicationEnvironmentException(msg11, 0L);
                            }
                        }
                    }
                    catch (NoSuchParameterException ex) {
                        String msg12 = "The data context of activity '%s' is missing the expected output parameter '%s'!";
                        msg12 = String.format(msg12, this.activityInstance.getName(), param5.getName());
                        throw new ApplicationEnvironmentException(msg12, 0L, ex);
                    }
                    catch (InvalidDataTypeException ex) {
                        String msg13 = "The data context of activity '%s' doesn't accept the data type %s of output parameter '%s'!";
                        msg13 = String.format(msg13, new Object[]{this.activityInstance.getName(), dataType, param5.getName()});
                        throw new ApplicationEnvironmentException(msg13, 0L, ex);
                    }
                }
            }
        }
        catch (OrgModelException orgModelException) {
            msg = "The %s with the ID %d does not exist!";
            msg = String.format(msg, new Object[]{entityType, entityID});
            throw new ApplicationFailedException(msg, null, 0L);
        }
        catch (DataSourceException dataSourceException) {
            msg = "An error occured when accessing the Org Model.";
            msg = String.format(msg, new Object[0]);
            throw new ApplicationEnvironmentException(msg, 0L);
        }
    }

    private void op_createEntity() {
        block17: {
            ActivityConfiguration conf = this.activityInstance.getConfiguration();
            EntityType entityType = this.getEntityType("EntityType");
            Entity entity = new Entity(entityType);
            DataContext dataContext = this.sessionContext.getDataContext();
            block15: for (ProcessModelParameter param : this.activityInstance.getParameters(ActivityConstants.AccessType.READ)) {
                if (param.getName().equals("orgPositionID")) continue;
                try {
                    switch (param.getDataType()) {
                        case INTEGER: {
                            entity.setInteger(param.getName(), dataContext.retrieveIntegerParameterValue(param.getName()));
                            continue block15;
                        }
                        case FLOAT: {
                            entity.setFloat(param.getName(), dataContext.retrieveFloatParameterValue(param.getName()));
                            continue block15;
                        }
                        case STRING: {
                            entity.setString(param.getName(), dataContext.retrieveStringParameterValue(param.getName()));
                            continue block15;
                        }
                        case DATE: {
                            entity.setDate(param.getName(), dataContext.retrieveDateParameterValue(param.getName()));
                            continue block15;
                        }
                        default: {
                            String msg = "The data type %s is not supported in the Org Model!";
                            msg = String.format(msg, new Object[]{param.getDataType()});
                            throw new ApplicationEnvironmentException(msg, 0L);
                        }
                    }
                }
                catch (NoSuchParameterException ex) {
                    String msg = "The data context of activity '%s' is missing the expected input parameter '%s'!";
                    msg = String.format(msg, this.activityInstance.getName(), param.getName());
                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                }
                catch (InvalidDataTypeException ex) {
                    String msg = "The data context of activity '%s' doesn't provide the expected data type %s of input parameter '%s'!";
                    msg = String.format(msg, new Object[]{this.activityInstance.getName(), param.getDataType(), param.getName()});
                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                }
            }
            SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
            try {
                ProcessModelParameter idParam;
                long entityID = this.orgModelManager.getModelChangeOperations().createEntity(session, entity);
                ProcessModelParameter orgPosParam = this.activityInstance.getParameter("orgPositionID", ActivityConstants.AccessType.READ);
                if (entityType == EntityType.AGENT && (orgPosParam != null || conf.getInteger("OrgPositionID") != null)) {
                    long orgPosID = this.getEntityID("orgPositionID", "OrgPositionID");
                    this.orgModelManager.getModelChangeOperations().addRelation(session, RelationType.ORG_POSITION_OCCUPATION, orgPosID, entityID);
                }
                if ((idParam = this.activityInstance.getParameter("entityID", ActivityConstants.AccessType.WRITE)) == null) break block17;
                try {
                    dataContext.storeIntegerParameterValue(idParam.getName(), entityID);
                }
                catch (NoSuchParameterException ex) {
                    String msg = "The data context of activity '%s' is missing the expected output parameter '%s'!";
                    msg = String.format(msg, this.activityInstance.getName(), idParam.getName());
                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                }
                catch (InvalidDataTypeException ex) {
                    String msg = "The data context of activity '%s' doesn't accept the expected data type %s of output parameter '%s'!";
                    msg = String.format(msg, new Object[]{this.activityInstance.getName(), idParam.getDataType(), idParam.getName()});
                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                }
            }
            catch (OrgModelException ex) {
                String msg = "An error occured while performing the operation on the Org Model.";
                throw new ApplicationFailedException(msg, null, 0L, ex);
            }
            catch (DataSourceException ex) {
                String msg = "An error occured when accessing the Org Model.";
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void op_updateEntity() {
        EntityType entityType = this.getEntityType("EntityType");
        Long entityID = null;
        String userName = null;
        if (entityType == EntityType.AGENT && this.activityInstance.getParameter("agentUserName", ActivityConstants.AccessType.READ) != null) {
            userName = (String)this.getInputParameterValue("agentUserName");
        } else {
            entityID = this.getEntityID("entityID", "EntityID");
        }
        Entity entity = new Entity(entityType);
        DataContext dataContext = this.sessionContext.getDataContext();
        block14: for (ProcessModelParameter param : this.activityInstance.getParameters(ActivityConstants.AccessType.READ)) {
            if (param.getName().equals("entityID") || param.getName().equals("agentUserName")) continue;
            try {
                switch (param.getDataType()) {
                    case INTEGER: {
                        entity.setInteger(param.getName(), dataContext.retrieveIntegerParameterValue(param.getName()));
                        continue block14;
                    }
                    case FLOAT: {
                        entity.setFloat(param.getName(), dataContext.retrieveFloatParameterValue(param.getName()));
                        continue block14;
                    }
                    case STRING: {
                        entity.setString(param.getName(), dataContext.retrieveStringParameterValue(param.getName()));
                        continue block14;
                    }
                    case DATE: {
                        entity.setDate(param.getName(), dataContext.retrieveDateParameterValue(param.getName()));
                        continue block14;
                    }
                    default: {
                        String msg = "The data type %s is not supported in the Org Model!";
                        msg = String.format(msg, new Object[]{param.getDataType()});
                        throw new ApplicationEnvironmentException(msg, 0L);
                    }
                }
            }
            catch (NoSuchParameterException ex) {
                String msg = "The data context of activity '%s' is missing the expected input parameter '%s'!";
                msg = String.format(msg, this.activityInstance.getName(), param.getName());
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
            catch (InvalidDataTypeException ex) {
                String msg = "The data context of activity '%s' doesn't provide the expected data type %s of input parameter '%s'!";
                msg = String.format(msg, new Object[]{this.activityInstance.getName(), param.getDataType(), param.getName()});
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
        }
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        try {
            if (userName != null) {
                List<Entity> agent = this.orgModelManager.getModelExplorer().getEntities(session, EntityType.AGENT, "userName", CmpOperator.EQUAL, (Serializable)((Object)userName), new String[0]);
                if (agent.size() <= 0) {
                    String msg = "Agent with User Name '%s' does not exist in the Org Model.";
                    msg = String.format(msg, userName);
                    throw new ApplicationFailedException(msg, null, 0L);
                }
                entityID = agent.get(0).getInteger("id");
            } else {
                try {
                    this.orgModelManager.getModelExplorer().getEntity(session, entityType, entityID, new String[0]);
                }
                catch (OrgModelException ex) {
                    String msg = "%s with ID %d does not exist in the Org Model.";
                    msg = String.format(msg, entityType.toString(), entityID);
                    throw new ApplicationFailedException(msg, null, 0L, ex);
                }
            }
            entity.setInteger("id", entityID);
            this.orgModelManager.getModelChangeOperations().updateEntity(session, entity);
            return;
        }
        catch (OrgModelException ex) {
            String msg = "An error occured while performing the operation on the Org Model.";
            throw new ApplicationFailedException(msg, null, 0L, ex);
        }
        catch (DataSourceException ex) {
            String msg = "An error occured when accessing the Org Model.";
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void op_deleteEntity() {
        EntityType entityType = this.getEntityType("EntityType");
        Long entityID = null;
        String userName = null;
        if (entityType == EntityType.AGENT && this.activityInstance.getParameter("agentUserName", ActivityConstants.AccessType.READ) != null) {
            userName = (String)this.getInputParameterValue("agentUserName");
        } else {
            entityID = this.getEntityID("entityID", "EntityID");
        }
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        try {
            if (userName != null) {
                List<Entity> agent = this.orgModelManager.getModelExplorer().getEntities(session, EntityType.AGENT, "userName", CmpOperator.EQUAL, (Serializable)((Object)userName), new String[0]);
                if (agent.size() <= 0) {
                    String msg = "Agent with User Name '%s' does not exist in the Org Model.";
                    msg = String.format(msg, userName);
                    throw new ApplicationFailedException(msg, null, 0L);
                }
                entityID = agent.get(0).getInteger("id");
            } else {
                try {
                    this.orgModelManager.getModelExplorer().getEntity(session, entityType, entityID, new String[0]);
                }
                catch (OrgModelException ex) {
                    String msg = "%s with ID %d does not exist in the Org Model.";
                    msg = String.format(msg, entityType.toString(), entityID);
                    throw new ApplicationFailedException(msg, null, 0L, ex);
                }
            }
            this.orgModelManager.getModelChangeOperations().deleteEntity(session, entityType, entityID);
            return;
        }
        catch (OrgModelException ex) {
            String msg = "An error occured while performing the operation on the Org Model.";
            throw new ApplicationFailedException(msg, null, 0L, ex);
        }
        catch (DataSourceException ex) {
            String msg = "An error occured when accessing the Org Model.";
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    private void op_addRelation() {
        RelationType relationType;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        if (conf.getString("RelationType") != null) {
            relationType = OmacTools.parseRelationType(conf.getString("RelationType"));
            if (relationType == null) {
                String msg = "The RelationType '%s' is unknown.";
                msg = String.format(msg, conf.getString("RelationType"));
                throw new ApplicationEnvironmentException(msg, 0L);
            }
        } else {
            String msg = "No RelationType has been specified.";
            throw new ApplicationEnvironmentException(msg, 0L);
        }
        long leftID = this.getEntityID("leftEntityID", "LeftEntityID");
        long rightID = this.getEntityID("rightEntityID", "RightEntityID");
        Boolean failOnExist = conf.getBoolean("FailOnExist");
        if (failOnExist == null) {
            failOnExist = true;
        }
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        try {
            boolean exists = this.orgModelManager.getModelExplorer().relationExists(session, relationType, leftID, rightID);
            if (failOnExist.booleanValue() && exists) {
                String msg = "The relation already exists.";
                throw new ApplicationFailedException(msg, null, 0L);
            }
            if (!exists) {
                this.orgModelManager.getModelChangeOperations().addRelation(session, relationType, leftID, rightID);
            }
        }
        catch (OrgModelException ex) {
            String msg = "An error occured while performing the operation on the Org Model.";
            throw new ApplicationFailedException(msg, null, 0L, ex);
        }
        catch (DataSourceException ex) {
            String msg = "An error occured when accessing the Org Model.";
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    private void op_removeRelation() {
        RelationType relationType;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        if (conf.getString("RelationType") != null) {
            relationType = OmacTools.parseRelationType(conf.getString("RelationType"));
            if (relationType == null) {
                String msg = "The RelationType '%s' is unknown.";
                msg = String.format(msg, conf.getString("RelationType"));
                throw new ApplicationEnvironmentException(msg, 0L);
            }
        } else {
            String msg = "No RelationType has been specified.";
            throw new ApplicationEnvironmentException(msg, 0L);
        }
        long leftID = this.getEntityID("leftEntityID", "LeftEntityID");
        long rightID = this.getEntityID("rightEntityID", "RightEntityID");
        Boolean failOnNotExist = conf.getBoolean("FailOnNotExist");
        if (failOnNotExist == null) {
            failOnNotExist = true;
        }
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        try {
            boolean exists = this.orgModelManager.getModelExplorer().relationExists(session, relationType, leftID, rightID);
            if (failOnNotExist.booleanValue() && !exists) {
                String msg = "The relation does not exist.";
                throw new ApplicationFailedException(msg, null, 0L);
            }
            if (exists) {
                this.orgModelManager.getModelChangeOperations().deleteRelation(session, relationType, leftID, rightID);
            }
        }
        catch (OrgModelException ex) {
            String msg = "An error occured while performing the operation on the Org Model.";
            throw new ApplicationFailedException(msg, null, 0L, ex);
        }
        catch (DataSourceException ex) {
            String msg = "An error occured when accessing the Org Model.";
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    private void op_findEntities() {
        String msg;
        EntityType entityType = null;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        if (conf.getString("EntityType") != null) {
            entityType = EntityType.fromPolicyToken(conf.getString("EntityType"));
        }
        if (entityType == null) {
            String msg2 = "No entity type has been specified!";
            throw new ApplicationEnvironmentException(msg2, 0L);
        }
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        Filter filter = new Filter();
        for (ProcessModelParameter param : this.activityInstance.getParameters(ActivityConstants.AccessType.READ)) {
            Object value;
            ProcessConstants.AdeptDataType dataType = param.getDataType();
            switch (param.getDataType()) {
                case INTEGER: {
                    value = this.getInputInteger(param.getName());
                    break;
                }
                case FLOAT: {
                    value = this.getInputFloat(param.getName());
                    break;
                }
                case STRING: {
                    value = this.getInputString(param.getName());
                    break;
                }
                case DATE: {
                    value = this.getInputDate(param.getName());
                    break;
                }
                default: {
                    String msg3 = "The data type '%s' is not supported by this operation.";
                    msg3 = String.format(msg3, new Object[]{dataType});
                    throw new ApplicationEnvironmentException(msg3, 0L);
                }
            }
            filter.addSelection(param.getName(), CmpOperator.EQUAL, value);
        }
        try {
            List<Entity> entities = this.orgModelManager.getModelExplorer().getEntities(session, entityType, filter, new String[0]);
            if (this.activityInstance.getParameter("entityIDs", ActivityConstants.AccessType.WRITE) != null) {
                ArrayList<Long> entityIDs = new ArrayList<Long>();
                for (Entity entity : entities) {
                    entityIDs.add(entity.getInteger("id"));
                }
                this.setOutputList("entityIDs", entityIDs, ProcessConstants.AdeptDataType.INTEGER);
            } else {
                ProcessModelParameter output = this.activityInstance.getParameter("entityID", ActivityConstants.AccessType.WRITE);
                if (entities.isEmpty()) {
                    if (!output.isOptional()) {
                        String msg4 = "No entity could be found but the output parameter is not optional.";
                        throw new ApplicationFailedException(msg4, "", 0L);
                    }
                } else {
                    long entityID = entities.get(0).getInteger("id");
                    this.setOutputInteger("entityID", entityID);
                }
            }
        }
        catch (OrgModelException ex) {
            msg = "An error occured when accessing the Org Model";
            msg = String.format(msg, new Object[0]);
            throw new ApplicationFailedException(msg, "", 0L, ex);
        }
        catch (DataSourceException ex) {
            msg = "An error occured when accessing the Org Model.";
            msg = String.format(msg, new Object[0]);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    protected EntityType getEntityType(String confEntryName) {
        EntityType entityType;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        if (conf.getString(confEntryName) != null) {
            entityType = EntityType.fromPolicyToken(conf.getString(confEntryName));
            if (entityType == null) {
                String msg = "'%s' is not a known entity type!";
                msg = String.format(msg, conf.getString(confEntryName));
                throw new ApplicationEnvironmentException(msg, 0L);
            }
        } else {
            String msg = "No entity type has been specified!";
            throw new ApplicationEnvironmentException(msg, 0L);
        }
        return entityType;
    }

    protected long getEntityID(String parameterName, String confEntryName) {
        Long value = null;
        ProcessModelParameter inParam = this.activityInstance.getParameter(parameterName, ActivityConstants.AccessType.READ);
        if (inParam != null) {
            if (inParam.getDataType() != ProcessConstants.AdeptDataType.INTEGER) {
                String msg = "The input parameter '%s' is not of type %s!";
                msg = String.format(msg, new Object[]{inParam.getName(), ProcessConstants.AdeptDataType.INTEGER});
                throw new IllegalArgumentException(msg);
            }
            value = (Long)this.getInputParameterValue(parameterName);
        }
        if (value == null) {
            value = (long)this.activityInstance.getConfiguration().getInteger(confEntryName);
        }
        return value;
    }

    protected long getInputInteger(String parameterName) throws ApplicationEnvironmentException {
        DataContext dataContext = this.sessionContext.getDataContext();
        try {
            return dataContext.retrieveIntegerParameterValue(parameterName);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected input parameter '%s' does not exist.";
            msg = String.format(msg, parameterName);
            throw new ApplicationEnvironmentException(msg, 1100005L, ex);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The input parameter '%s' does not have the expected data type %s.";
            msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.INTEGER});
            throw new ApplicationEnvironmentException(msg, 1100004L, ex);
        }
    }

    protected double getInputFloat(String parameterName) throws ApplicationEnvironmentException {
        DataContext dataContext = this.sessionContext.getDataContext();
        try {
            return dataContext.retrieveFloatParameterValue(parameterName);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected input parameter '%s' does not exist.";
            msg = String.format(msg, parameterName);
            throw new ApplicationEnvironmentException(msg, 1100005L, ex);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The input parameter '%s' does not have the expected data type %s.";
            msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.FLOAT});
            throw new ApplicationEnvironmentException(msg, 1100004L, ex);
        }
    }

    protected String getInputString(String parameterName) throws ApplicationEnvironmentException {
        DataContext dataContext = this.sessionContext.getDataContext();
        try {
            return dataContext.retrieveStringParameterValue(parameterName);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected input parameter '%s' does not exist.";
            msg = String.format(msg, parameterName);
            throw new ApplicationEnvironmentException(msg, 1100005L, ex);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The input parameter '%s' does not have the expected data type %s.";
            msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.STRING});
            throw new ApplicationEnvironmentException(msg, 1100004L, ex);
        }
    }

    protected Date getInputDate(String parameterName) throws ApplicationEnvironmentException {
        DataContext dataContext = this.sessionContext.getDataContext();
        try {
            return dataContext.retrieveDateParameterValue(parameterName);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected input parameter '%s' does not exist.";
            msg = String.format(msg, parameterName);
            throw new ApplicationEnvironmentException(msg, 1100005L, ex);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The input parameter '%s' does not have the expected data type %s.";
            msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.DATE});
            throw new ApplicationEnvironmentException(msg, 1100004L, ex);
        }
    }

    protected void setOutputInteger(String parameterName, long value) throws ApplicationEnvironmentException {
        DataContext dataContext = this.sessionContext.getDataContext();
        try {
            dataContext.storeIntegerParameterValue(parameterName, value);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected output parameter '%s' does not exist.";
            msg = String.format(msg, parameterName);
            throw new ApplicationEnvironmentException(msg, 1100005L, ex);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The output parameter '%s' does not have the expected data type %s.";
            msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.INTEGER});
            throw new ApplicationEnvironmentException(msg, 1100004L, ex);
        }
    }

    protected void setOutputUDT(String parameterName, UDTValue value) throws ApplicationEnvironmentException {
        DataContext dataContext = this.sessionContext.getDataContext();
        try {
            dataContext.storeUDTParameterValue(parameterName, value);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected output parameter '%s' does not exist.";
            msg = String.format(msg, parameterName);
            throw new ApplicationEnvironmentException(msg, 1100005L, ex);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The output parameter '%s' does not have the expected data type %s.";
            msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.USERDEFINED});
            throw new ApplicationEnvironmentException(msg, 1100004L, ex);
        }
    }

    protected void setOutputList(String parameterName, List<?> value, ProcessConstants.AdeptDataType elementDataType) {
        ADEPT2UDTValue outputUDT;
        try {
            String udtName = elementDataType == null ? "java.util.List" : String.format("java.util.List<%s>", elementDataType.name());
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            new ObjectOutputStream(buffer).writeObject(value);
            outputUDT = new ADEPT2UDTValue(udtName, buffer.toByteArray());
        }
        catch (IOException ex) {
            String msg = "The list for output parameter '%s' could not be serialised.";
            msg = String.format(msg, parameterName);
            throw new ApplicationEnvironmentException(msg, 1100004L, ex);
        }
        this.setOutputUDT(parameterName, outputUDT);
    }
}

