/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.pdfsupport.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.ui.htmlgui.HTMLContext;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Logger;

public class HTMLPDFComponent
extends ExecutionEnvironment {
    private int signal = Integer.MIN_VALUE;
    private final Logger logger = LoggerTools.getLogger(this);
    protected HTMLContext htmlContext;

    public HTMLPDFComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void init(SessionContext sessionContext) {
        this.logger.finest("Entered init");
        super.init(sessionContext);
        this.logger.finest("Executed super.init");
        this.htmlContext = (HTMLContext)sessionContext.getGUIContext();
        this.logger.finest("Got the HTML context");
        InputStream templateStream = HTMLPDFComponent.class.getResourceAsStream("PDFReviewForm.tpl");
        BufferedReader br = new BufferedReader(new InputStreamReader(templateStream));
        StringBuilder htmlTemplate = new StringBuilder();
        try {
            try {
                String line = br.readLine();
                while (line != null) {
                    htmlTemplate.append(line);
                    htmlTemplate.append("\n");
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException iOException) {
                throw new ApplicationFailedException("", "", 1600000L);
            }
        }
        catch (Throwable throwable) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                throw new ApplicationFailedException("", "", 1600000L);
            }
            throw throwable;
        }
        try {
            br.close();
        }
        catch (IOException iOException) {
            throw new ApplicationFailedException("", "", 1600000L);
        }
        boolean udtInput = false;
        StringBuilder formHTML = new StringBuilder("<table>\n");
        TreeSet<ProcessModelParameter> inputParameters = new TreeSet<ProcessModelParameter>(new ParameterComparator());
        inputParameters.addAll(this.activityInstance.getParameters(ActivityConstants.AccessType.READ));
        for (ProcessModelParameter parameter : inputParameters) {
            if (parameter.getName().equals("pdf")) {
                udtInput = true;
                continue;
            }
            formHTML.append("<tr>\n");
            formHTML.append(String.format("<td valign=\"top\">%s</td>\n", parameter.getName()));
            formHTML.append(String.format("<td>%s</td>\n", this.getHTMLForInputParameter(parameter)));
            formHTML.append("</tr>\n");
        }
        TreeSet<ProcessModelParameter> outputParameters = new TreeSet<ProcessModelParameter>(new ParameterComparator());
        outputParameters.addAll(this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE));
        for (ProcessModelParameter parameter : outputParameters) {
            formHTML.append("<tr>\n");
            formHTML.append(String.format("<td valign=\"top\">%s</td>\n", parameter.getName()));
            formHTML.append(String.format("<td>%s</td>\n", this.getHTMLForOutputParameter(parameter)));
            formHTML.append("</tr>\n");
        }
        formHTML.append("</table>");
        String udtInputHTML = "";
        if (udtInput) {
            udtInputHTML = String.format("<center> \n<iframe src=\"%s\" width=\"96%%\" height=\"60%%\">iframe support needed!</iframe>\n</center>", this.htmlContext.getURL("action=pdf"));
        }
        String htmlContent = String.format(htmlTemplate.toString(), this.activityInstance.getName(), this.activityInstance.getName(), this.activityInstance.getDescription(), udtInputHTML, this.htmlContext.getURL(), formHTML.toString());
        this.logger.finest("Finished creating the initial content");
        this.htmlContext.setInitialContent(htmlContent);
        this.logger.finest("Called setInitialContent, leaving init");
    }

    private String getHTMLForInputParameter(ProcessModelParameter parameter) {
        DataContext dataContext = this.sessionContext.getDataContext();
        try {
            switch (parameter.getDataType()) {
                case STRING: {
                    String sValue = dataContext.retrieveStringParameterValue(parameter.getName());
                    return sValue;
                }
                case BOOLEAN: {
                    boolean bValue = dataContext.retrieveBooleanParameterValue(parameter.getName());
                    return bValue ? "Yes" : "No";
                }
            }
        }
        catch (InvalidDataTypeException e) {
            e.printStackTrace();
        }
        catch (NoSuchParameterException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getHTMLForOutputParameter(ProcessModelParameter parameter) {
        String disabled = this.sessionContext.isViewOnly() ? "disabled=\"disabled\"" : "";
        try {
            switch (parameter.getDataType()) {
                case STRING: {
                    String value = "";
                    if (this.sessionContext.isViewOnly()) {
                        value = this.sessionContext.getDataContext().storedStringParameterValue(parameter.getName());
                    }
                    return String.format("<textarea name=\"%s\" cols=\"74\" rows=\"5\" %s>%s</textarea>", parameter.getName(), disabled, value);
                }
                case BOOLEAN: {
                    String checked = "";
                    if (this.sessionContext.isViewOnly() && this.sessionContext.getDataContext().storedBooleanParameterValue(parameter.getName())) {
                        checked = "checked=\"checked\"";
                    }
                    return String.format("<input type=\"checkbox\" name=\"%s\" value=\"true\" %s %s>", parameter.getName(), disabled, checked);
                }
                case USERDEFINED: {
                    return String.format("<input type=\"file\" name=\"%s\">", parameter.getName());
                }
            }
        }
        catch (NoSuchParameterException noSuchParameterException) {
        }
        catch (InvalidDataTypeException invalidDataTypeException) {}
        this.logger.severe("Can't handle output of parameter type " + (Object)((Object)parameter.getDataType()));
        return "";
    }

    @Override
    public void run() {
        this.logger.finest("Entered run");
        DataContext dataContext = this.sessionContext.getDataContext();
        this.logger.finest("Got the data context");
        while (true) {
            block19: {
                try {
                    this.logger.finest("Will call waitForReply() now...");
                    HTMLContext.HTTPReply reply = this.htmlContext.waitForHTTPReply();
                    this.logger.finest("Got a reply: " + reply);
                    String action = reply.getParameters().get("action");
                    this.logger.finest("Action is: " + action);
                    if (action.equals("pdf")) {
                        InputStream pdfStream;
                        try {
                            pdfStream = dataContext.retrieveUDTParameterValue("pdf").getValueAsStream();
                        }
                        catch (InvalidDataTypeException invalidDataTypeException) {
                            throw new ApplicationEnvironmentException("", 1100004L);
                        }
                        catch (NoSuchParameterException noSuchParameterException) {
                            throw new ApplicationEnvironmentException("", -401000L);
                        }
                        this.logger.finest("Got PDF stream from data context, going to set response...");
                        this.htmlContext.setResponse(new HTMLContext.Response(200, "application/pdf", pdfStream));
                        this.logger.finest("Set PDF response");
                    } else if (action.equals("Confirm")) {
                        if (this.sessionContext.isViewOnly()) break;
                        block14: for (ProcessModelParameter parameter : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
                            String name = parameter.getName();
                            String value = reply.getParameters().get(name);
                            if ((value == null || value.equals("")) && parameter.isOptional()) continue;
                            try {
                                switch (parameter.getDataType()) {
                                    case BOOLEAN: {
                                        dataContext.storeBooleanParameterValue(name, Boolean.valueOf(value));
                                        continue block14;
                                    }
                                    case STRING: {
                                        dataContext.storeStringParameterValue(name, value);
                                        continue block14;
                                    }
                                    case USERDEFINED: {
                                        byte[] stream = value.getBytes();
                                        String userDefinedType = parameter.getUDTName();
                                        ADEPT2UDTValue udtValue = new ADEPT2UDTValue(userDefinedType, stream);
                                        dataContext.storeUDTParameterValue(name, udtValue);
                                        continue block14;
                                    }
                                    default: {
                                        throw new ApplicationEnvironmentException("Environment can't handle type " + (Object)((Object)parameter.getDataType()), -401001L);
                                    }
                                }
                            }
                            catch (InvalidDataTypeException invalidDataTypeException) {
                                throw new ApplicationEnvironmentException("", 1100004L);
                            }
                            catch (NoSuchParameterException noSuchParameterException) {
                                throw new ApplicationEnvironmentException("", -401000L);
                            }
                        }
                        break;
                    }
                    this.logger.finest("Finished handling the request");
                }
                catch (InterruptedException interruptedException) {
                    this.logger.finest("Caught interrupt, calling dispatch.");
                    this.sessionContext.getRuntimeEnvironment().dispatch();
                    this.logger.finest("Dispatch called, got signal " + this.signal);
                    if (this.signal == Integer.MIN_VALUE) continue;
                    if (this.signal == 7) {
                        this.sessionContext.getRuntimeEnvironment().applicationClosed();
                        break;
                    }
                    if (this.signal != 7168) break block19;
                    throw new ApplicationFailedException("", "", 1800000L);
                }
            }
            this.logger.finest("while(true) still active...");
        }
        this.logger.finest("Calling application closed.");
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        this.signal = 7;
        return true;
    }

    @Override
    public boolean kill() {
        this.signal = 7168;
        return true;
    }

    private static class ParameterComparator
    implements Comparator<ProcessModelParameter>,
    Serializable {
        private static final long serialVersionUID = -7457548142336872773L;

        ParameterComparator() {
        }

        @Override
        public int compare(ProcessModelParameter o1, ProcessModelParameter o2) {
            int nameCompare = o1.getName().compareTo(o2.getName());
            String o1Pos = o1.getConfiguration().getString("position");
            String o2Pos = o2.getConfiguration().getString("position");
            int positionCompare = 0;
            if (o1Pos != null && o2Pos != null) {
                positionCompare = Integer.parseInt(o1Pos) - Integer.parseInt(o2Pos);
            }
            if (positionCompare != 0) {
                return positionCompare;
            }
            return nameCompare;
        }
    }
}

