/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport;

import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DatabaseComponentHelpers {
    private static Logger logger = LoggerTools.getLogger(DatabaseComponentHelpers.class);
    private static final Pattern LIST_PATTERN = Pattern.compile("^java\\.util\\.List<(.*)>$");

    public static void setInputParam(ProcessModelParameter inParam, DataContext dataContext, PreparedStatement pstmt, int columnIndex, String activityInstanceName) throws SQLException {
        Integer typeCode;
        Object valueObject = DatabaseComponentHelpers.getInputParameterValue(inParam, dataContext, activityInstanceName);
        try {
            typeCode = pstmt.getParameterMetaData().getParameterType(columnIndex);
        }
        catch (SQLException sQLException) {
            typeCode = null;
        }
        try {
            if (inParam.getDataType() == ProcessConstants.AdeptDataType.STRING && valueObject instanceof String && pstmt.getParameterMetaData().getPrecision(columnIndex) > 0) {
                int stringLength = ((String)valueObject).length();
                int columnWidth = pstmt.getParameterMetaData().getPrecision(columnIndex);
                if (stringLength > pstmt.getParameterMetaData().getPrecision(columnIndex)) {
                    String msg = "The string value of parameter '%s' might be too large to be stored in the database (string length: %d; reported column width: %d).";
                    msg = String.format(msg, inParam.getName(), stringLength, columnWidth);
                    logger.warning(msg);
                }
            }
        }
        catch (SQLException sQLException) {}
        switch (inParam.getDataType()) {
            case INTEGER: 
            case FLOAT: 
            case STRING: 
            case BOOLEAN: {
                if (typeCode == null) {
                    pstmt.setObject(columnIndex, valueObject);
                    break;
                }
                pstmt.setObject(columnIndex, valueObject, typeCode);
                break;
            }
            case URI: {
                URI value = (URI)valueObject;
                String valueString = value == null ? null : value.toString();
                pstmt.setString(columnIndex, valueString);
                break;
            }
            case DATE: {
                long valueMillis;
                java.util.Date value = (java.util.Date)valueObject;
                long l = valueMillis = value == null ? Long.MIN_VALUE : value.getTime();
                if (typeCode == null) {
                    if (value == null) {
                        pstmt.setObject(columnIndex, null, 93);
                        break;
                    }
                    pstmt.setObject(columnIndex, new Timestamp(valueMillis));
                    break;
                }
                if (typeCode == 91) {
                    Date date = value == null ? null : new Date(valueMillis);
                    pstmt.setDate(columnIndex, date, JDBCTools.createUTCCalendar());
                    break;
                }
                if (typeCode == 92) {
                    Time time = value == null ? null : new Time(valueMillis);
                    pstmt.setTime(columnIndex, time, JDBCTools.createUTCCalendar());
                    break;
                }
                Timestamp timestamp = value == null ? null : new Timestamp(valueMillis);
                pstmt.setTimestamp(columnIndex, timestamp, JDBCTools.createUTCCalendar());
                break;
            }
            case USERDEFINED: {
                UDTValue value = (UDTValue)valueObject;
                byte[] valueBytes = value == null ? null : value.getValueAsArray();
                pstmt.setBytes(columnIndex, valueBytes);
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)inParam.getDataType()) + " not supported/implemented"));
            }
        }
    }

    public static Object getInputParameterValue(ProcessModelParameter param, DataContext dataContext, String activityInstanceName) {
        Object value;
        block13: {
            ProcessConstants.AdeptDataType type = param.getDataType();
            value = null;
            try {
                if (dataContext.isNull(param.getName())) break block13;
                switch (type) {
                    case BOOLEAN: {
                        value = dataContext.retrieveBooleanParameterValue(param.getName());
                        break;
                    }
                    case INTEGER: {
                        value = dataContext.retrieveIntegerParameterValue(param.getName());
                        break;
                    }
                    case FLOAT: {
                        value = dataContext.retrieveFloatParameterValue(param.getName());
                        break;
                    }
                    case STRING: {
                        value = dataContext.retrieveStringParameterValue(param.getName());
                        break;
                    }
                    case URI: {
                        value = dataContext.retrieveURIParameterValue(param.getName());
                        break;
                    }
                    case DATE: {
                        value = dataContext.retrieveDateParameterValue(param.getName());
                        break;
                    }
                    case USERDEFINED: {
                        value = dataContext.retrieveUDTParameterValue(param.getName());
                        break;
                    }
                    default: {
                        assert (false) : String.format("Data type '%1$s' of parameter '%2$s' not supported.", new Object[]{type, param.getName()});
                        break;
                    }
                }
            }
            catch (NoSuchParameterException ex) {
                String msg = "There is no input parameter of name '%1$s' in the data context of activity '%2$s'.";
                msg = String.format(msg, param.getName(), activityInstanceName);
                logger.log(Level.WARNING, msg, ex);
            }
            catch (InvalidDataTypeException ex) {
                String msg = "The input parameter '%1$s' is of type '%2$s' in the data context of activity '%3$s.";
                msg = String.format(msg, new Object[]{param.getName(), ex.getActualDataType(), activityInstanceName});
                logger.log(Level.WARNING, msg, ex);
            }
        }
        return value;
    }

    public static void processResultSet(ResultSet rs, Collection<ProcessModelParameter> outParams, DataContext dataContext, String activityInstanceName) {
        HashMap listOutput = new HashMap();
        Matcher listMatcher = LIST_PATTERN.matcher("");
        String paramName = null;
        ProcessConstants.AdeptDataType paramDataType = null;
        try {
            for (ProcessModelParameter param : outParams) {
                paramName = param.getName();
                paramDataType = param.getDataType();
                boolean isListParam = false;
                if (param.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && listMatcher.reset(param.getUDTName()).matches()) {
                    String elementDataTypeString = listMatcher.group(1);
                    try {
                        ProcessConstants.AdeptDataType.valueOf(elementDataTypeString);
                        isListParam = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (param.getConfiguration().getString("ColumnIndex") != null) {
                    int columnCount = rs.getMetaData().getColumnCount();
                    int columnIndex = Integer.parseInt(param.getConfiguration().getString("ColumnIndex"));
                    if (columnIndex >= columnCount) {
                        String msg = "The result set produced by the SQL statement of activity '%s' only contains %d columns, but the output parameter '%s' requires the column with the (0-based) index %d!";
                        msg = String.format(msg, activityInstanceName, columnCount, param.getName(), columnIndex);
                        throw new ApplicationEnvironmentException(msg, 0L);
                    }
                    if (isListParam) {
                        listOutput.put(columnIndex, new ArrayList());
                        continue;
                    }
                    DatabaseComponentHelpers.readColumnByIndex(rs, dataContext, param, columnIndex);
                    continue;
                }
                if (param.getConfiguration().getString("ColumnName") == null) continue;
                String columnName = param.getConfiguration().getString("ColumnName");
                try {
                    rs.findColumn(columnName);
                }
                catch (SQLException sQLException) {
                    String msg = "The result set produced by the SQL statement of activity '%s' apparently does not contain a column with the name '%s' as required by the output parameter '%s'!";
                    msg = String.format(msg, activityInstanceName, columnName, param.getName());
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                if (isListParam) {
                    listOutput.put(columnName, new ArrayList());
                    continue;
                }
                DatabaseComponentHelpers.readColumnByName(rs, dataContext, param, columnName);
            }
            if (listOutput.size() > 0) {
                do {
                    for (ProcessModelParameter param : outParams) {
                        paramName = param.getName();
                        paramDataType = param.getDataType();
                        for (Map.Entry entry : listOutput.entrySet()) {
                            String columnName = null;
                            int columnIndex = -1;
                            if (entry.getKey() instanceof Integer) {
                                columnIndex = (Integer)entry.getKey();
                            } else {
                                columnName = (String)entry.getKey();
                            }
                            ((List)entry.getValue()).add(DatabaseComponentHelpers.readColumnForList(rs, param, columnName, columnIndex));
                        }
                    }
                } while (rs.next());
            }
            for (ProcessModelParameter param : outParams) {
                List list;
                paramName = param.getName();
                paramDataType = param.getDataType();
                if (param.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || !listMatcher.reset(param.getUDTName()).matches()) continue;
                if (param.getConfiguration().getString("ColumnIndex") != null) {
                    int columnIndex = Integer.parseInt(param.getConfiguration().getString("ColumnIndex"));
                    list = (List)listOutput.get(columnIndex);
                } else {
                    String columnName = param.getConfiguration().getString("ColumnName");
                    list = (List)listOutput.get(columnName);
                }
                try {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(byteOut);
                    out.writeObject(list);
                    ADEPT2UDTValue value = new ADEPT2UDTValue(param.getUDTName(), byteOut.toByteArray());
                    dataContext.storeUDTParameterValue(param.getName(), value);
                }
                catch (IOException iOException) {}
            }
        }
        catch (NoSuchParameterException ex) {
            String msg = "The data context of activity '%s' is missing the expected output parameter '%s'!";
            msg = String.format(msg, activityInstanceName, paramName);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The data context of activity '%s' doesn't accept the data type %s of parameter '%s'!";
            msg = String.format(msg, new Object[]{activityInstanceName, paramDataType, paramName});
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
        catch (URISyntaxException ex) {
            String msg = "The string value retrieved from the SQL SELECT statement for parameter '%s' in activity '%s' is no valid URI!";
            msg = String.format(msg, paramName, activityInstanceName);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
        catch (SQLException ex) {
            String msg = "An error occured while reading a value from the result set produced by the SQL SELECT statement of activity '%s' for parameter '%s'! Maybe the column isn't compatible to the expected data type %s?";
            msg = String.format(msg, new Object[]{activityInstanceName, paramName, paramDataType});
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    public static void readColumnByIndex(ResultSet rs, DataContext dataContext, ProcessModelParameter param, int columnIndex) throws NoSuchParameterException, InvalidDataTypeException, SQLException, URISyntaxException {
        ++columnIndex;
        switch (param.getDataType()) {
            case BOOLEAN: {
                boolean value = rs.getBoolean(columnIndex);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeBooleanParameterValue(param.getName(), value);
                break;
            }
            case INTEGER: {
                long value = rs.getLong(columnIndex);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeIntegerParameterValue(param.getName(), value);
                break;
            }
            case FLOAT: {
                double value = rs.getDouble(columnIndex);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeFloatParameterValue(param.getName(), value);
                break;
            }
            case STRING: {
                String value = rs.getString(columnIndex);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeStringParameterValue(param.getName(), value);
                break;
            }
            case URI: {
                String valueString = rs.getString(columnIndex);
                URI value = new URI(valueString);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeURIParameterValue(param.getName(), value);
                break;
            }
            case DATE: {
                int typeCode = rs.getMetaData().getColumnType(columnIndex);
                java.util.Date value = typeCode == 91 ? rs.getDate(columnIndex, JDBCTools.createUTCCalendar()) : (typeCode == 92 ? rs.getTime(columnIndex, JDBCTools.createUTCCalendar()) : rs.getTimestamp(columnIndex, JDBCTools.createUTCCalendar()));
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeDateParameterValue(param.getName(), value);
                break;
            }
            case USERDEFINED: {
                byte[] valueBytes = rs.getBytes(columnIndex);
                ADEPT2UDTValue value = new ADEPT2UDTValue(param.getUDTName(), valueBytes);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeUDTParameterValue(param.getName(), value);
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)param.getDataType()) + " not supported/implemented"));
            }
        }
    }

    public static void readColumnByName(ResultSet rs, DataContext dataContext, ProcessModelParameter param, String columnName) throws NoSuchParameterException, InvalidDataTypeException, SQLException, URISyntaxException {
        switch (param.getDataType()) {
            case BOOLEAN: {
                boolean value = rs.getBoolean(columnName);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeBooleanParameterValue(param.getName(), value);
                break;
            }
            case INTEGER: {
                long value = rs.getLong(columnName);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeIntegerParameterValue(param.getName(), value);
                break;
            }
            case FLOAT: {
                double value = rs.getDouble(columnName);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeFloatParameterValue(param.getName(), value);
                break;
            }
            case STRING: {
                String value = rs.getString(columnName);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeStringParameterValue(param.getName(), value);
                break;
            }
            case URI: {
                String valueString = rs.getString(columnName);
                URI value = new URI(valueString);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeURIParameterValue(param.getName(), value);
                break;
            }
            case DATE: {
                int columnIndex = 1;
                ResultSetMetaData meta = rs.getMetaData();
                int i = 1;
                while (i <= meta.getColumnCount()) {
                    if (meta.getColumnName(i).equalsIgnoreCase(columnName)) {
                        columnIndex = i;
                        break;
                    }
                    ++i;
                }
                int typeCode = meta.getColumnType(columnIndex);
                java.util.Date value = typeCode == 91 ? rs.getDate(columnName, JDBCTools.createUTCCalendar()) : (typeCode == 92 ? rs.getTime(columnName, JDBCTools.createUTCCalendar()) : rs.getTimestamp(columnName, JDBCTools.createUTCCalendar()));
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeDateParameterValue(param.getName(), value);
                break;
            }
            case USERDEFINED: {
                byte[] valueBytes = rs.getBytes(columnName);
                ADEPT2UDTValue value = new ADEPT2UDTValue(param.getUDTName(), valueBytes);
                if (rs.wasNull()) {
                    dataContext.ignoreValue(param.getName());
                    break;
                }
                dataContext.storeUDTParameterValue(param.getName(), value);
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)param.getDataType()) + " not supported/implemented"));
            }
        }
    }

    public static Object readColumnForList(ResultSet rs, Parameter param, String columnName, int columnIndex) throws NoSuchParameterException, InvalidDataTypeException, SQLException, URISyntaxException {
        Object valueObject;
        ++columnIndex;
        Matcher listMatcher = LIST_PATTERN.matcher(param.getUDTName());
        listMatcher.matches();
        ProcessConstants.AdeptDataType dataType = ProcessConstants.AdeptDataType.valueOf(listMatcher.group(1));
        switch (dataType) {
            case BOOLEAN: {
                boolean value = columnName != null ? rs.getBoolean(columnName) : rs.getBoolean(columnIndex);
                valueObject = rs.wasNull() ? null : Boolean.valueOf(value);
                break;
            }
            case INTEGER: {
                long value = columnName != null ? rs.getLong(columnName) : rs.getLong(columnIndex);
                valueObject = rs.wasNull() ? null : Long.valueOf(value);
                break;
            }
            case FLOAT: {
                double value = columnName != null ? rs.getDouble(columnName) : rs.getDouble(columnIndex);
                valueObject = rs.wasNull() ? null : Double.valueOf(value);
                break;
            }
            case STRING: {
                String value = columnName != null ? rs.getString(columnName) : rs.getString(columnIndex);
                valueObject = value;
                break;
            }
            case URI: {
                String valueString = columnName != null ? rs.getString(columnName) : rs.getString(columnIndex);
                URI value = new URI(valueString);
                valueObject = value;
                break;
            }
            case DATE: {
                java.util.Date value;
                int typeCode;
                ResultSetMetaData meta = rs.getMetaData();
                if (columnName != null) {
                    columnIndex = 1;
                    int i = 1;
                    while (i <= meta.getColumnCount()) {
                        if (meta.getColumnName(i).equalsIgnoreCase(columnName)) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                if ((typeCode = meta.getColumnType(columnIndex)) == 91) {
                    value = columnName != null ? rs.getDate(columnName, JDBCTools.createUTCCalendar()) : rs.getDate(columnIndex, JDBCTools.createUTCCalendar());
                } else if (typeCode == 92) {
                    value = columnName != null ? rs.getTime(columnName, JDBCTools.createUTCCalendar()) : rs.getTime(columnIndex, JDBCTools.createUTCCalendar());
                } else {
                    java.util.Date date = value = columnName != null ? rs.getTimestamp(columnName, JDBCTools.createUTCCalendar()) : rs.getTimestamp(columnIndex, JDBCTools.createUTCCalendar());
                }
                if (rs.wasNull()) {
                    valueObject = null;
                    break;
                }
                valueObject = value;
                break;
            }
            case USERDEFINED: {
                byte[] value = columnName != null ? rs.getBytes(columnName) : rs.getBytes(columnIndex);
                valueObject = value;
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)param.getDataType()) + " not supported/implemented"));
            }
        }
        return valueObject;
    }

    private DatabaseComponentHelpers() {
    }
}

