/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.checks;

import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.util.CheckReport;

public class AbstractDatabaseComponentCheck
extends AbstractExecutableComponentCheck {
    protected AbstractDatabaseComponentCheck(AllExecutableComponentChecks checkProvider, String activityTypeID, String checkID) {
        super(activityTypeID, checkID);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.isConfEntrySet(conf, "DB.DataSourceName")) {
            String dataSourceName = conf.getString("DB.DataSourceName");
            if (dataSourceName == null || dataSourceName.length() == 0) {
                this.reportMissingConfEntry("DB.DataSourceName");
            }
        } else {
            String dbConnectionURL;
            if (conf.getString("DB.Driver") == null || conf.getString("DB.Driver").equals("")) {
                this.reportMissingConfEntry("DB.Driver");
            }
            if ((dbConnectionURL = conf.getString("DB.ConnectionURL")) == null || dbConnectionURL.equals("")) {
                this.reportMissingConfEntry("DB.ConnectionURL");
            }
            if (conf.getString("DB.UserName") == null || conf.getString("DB.UserName").equals("")) {
                this.reportMissingConfEntry("DB.UserName");
            }
            if (conf.getString("DB.Password") == null) {
                this.reportMissingConfEntry("DB.Password");
            }
        }
    }

    protected void reportMissingConfEntry(String fieldName) {
        String msg = "The entry '%s' of the activity's configuration is missing or has no value!";
        msg = String.format(msg, fieldName);
        this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
    }
}

