/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.checks;

import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.extensions.sqlsupport.Constants;
import de.aristaflow.adept2.extensions.sqlsupport.checks.AbstractDatabaseComponentCheck;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.paramref.IOParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.util.CheckReport;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class DatabaseAccessComponentCheck
extends AbstractDatabaseComponentCheck {
    private static final String CHECK_ID = "de.aristaflow.db.SQL#Check";

    public DatabaseAccessComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super(checkProvider, "de.aristaflow.db.SQL", CHECK_ID);
    }

    public DatabaseAccessComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    public void performCheckSpi(AbstractActivity activity) {
        super.performCheckSpi(activity);
        String opName = activity.getOperationName();
        if (opName.equals("executeStatements")) {
            this.checkOp_executeStatements(activity);
        } else if (opName.equals("dynamicInsert")) {
            this.checkOp_dynamicInsert(activity);
        } else {
            String msg = "Unknown operation encountered: " + opName;
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
    }

    private void checkOp_executeStatements(AbstractActivity activity) {
        block29: {
            Set<? extends Parameter> outputParams;
            HashSet<String> writtenFromStoredProc;
            block27: {
                String msg;
                Parameter parameter;
                block30: {
                    block28: {
                        ActivityConfiguration conf = activity.getConfiguration();
                        String sqlStatementsString = conf.getString("SQLStatements");
                        if (sqlStatementsString == null) {
                            this.reportMissingConfEntry("SQLStatements");
                        }
                        writtenFromStoredProc = new HashSet<String>();
                        if (sqlStatementsString != null) {
                            if (sqlStatementsString.trim().equals("")) {
                                String msg2 = "The SQL statement is an empty or blank string!";
                                this.addReportEntry(CheckReport.ResultType.FAILURE, msg2);
                            } else {
                                List<String> rawStatements;
                                try {
                                    rawStatements = SQLTools.parseSQLStringToStatements(sqlStatementsString, null);
                                }
                                catch (IOException ex) {
                                    String string2 = "The SQL statements string '%s' could not be parsed!";
                                    string2 = String.format(string2, sqlStatementsString);
                                    throw new ApplicationEnvironmentException(string2, 0L, ex);
                                }
                                HashSet<String> unusedInputParams = new HashSet<String>();
                                for (Parameter parameter2 : activity.getParameters(ActivityConstants.AccessType.READ)) {
                                    unusedInputParams.add(parameter2.getName());
                                }
                                for (String string : rawStatements) {
                                    ParameterRef ref;
                                    int n;
                                    int n2;
                                    ParameterRef[] parameterRefArray;
                                    ParameterRef[] refs;
                                    boolean isStoredProcedureCall = Constants.STORED_PROCEDURE_CALL_PATTERN.matcher(string).matches();
                                    if (isStoredProcedureCall) {
                                        refs = ParameterRefTools.findIOParameterReferences(string, null);
                                        this.checkInputParameterReferences(refs, activity);
                                        this.checkOutputParameterReferences((IOParameterRef[])refs, activity);
                                        parameterRefArray = refs;
                                        n2 = refs.length;
                                        n = 0;
                                        while (n < n2) {
                                            ref = parameterRefArray[n];
                                            unusedInputParams.remove(((IOParameterRef)ref).getName());
                                            ++n;
                                        }
                                        parameterRefArray = refs;
                                        n2 = refs.length;
                                        n = 0;
                                        while (n < n2) {
                                            ref = parameterRefArray[n];
                                            String outName = ((IOParameterRef)ref).getOutputName();
                                            if (outName != null) {
                                                if (writtenFromStoredProc.contains(outName)) {
                                                    String msg4 = "The output parameter '%s' is written at least twice!";
                                                    msg4 = String.format(msg4, outName);
                                                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg4);
                                                } else {
                                                    writtenFromStoredProc.add(outName);
                                                }
                                            }
                                            ++n;
                                        }
                                        continue;
                                    }
                                    refs = ParameterRefTools.findParameterReferences(string, null);
                                    this.checkInputParameterReferences(refs, activity);
                                    parameterRefArray = refs;
                                    n2 = refs.length;
                                    n = 0;
                                    while (n < n2) {
                                        ref = parameterRefArray[n];
                                        unusedInputParams.remove(ref.getName());
                                        ++n;
                                    }
                                }
                                for (String string : unusedInputParams) {
                                    String msg5 = "The input parameter '%s' is never used!";
                                    msg5 = String.format(msg5, string);
                                    this.addReportEntry(CheckReport.ResultType.INFO, msg5);
                                }
                            }
                        }
                        this.checkInputParameters(activity);
                        boolean serialiseResultSet = Boolean.parseBoolean(conf.getString("SerialiseResultSet"));
                        outputParams = activity.getParameters(ActivityConstants.AccessType.WRITE);
                        if (!serialiseResultSet) break block27;
                        if (outputParams.size() == 1) break block28;
                        String string3 = "With '%s' set to 'true' exactly one output parameter must exist and it must have the data type %s and the UDT name 'java.sql.ResultSet'!";
                        string3 = String.format(string3, new Object[]{"SerialiseResultSet", ProcessConstants.AdeptDataType.USERDEFINED});
                        this.addReportEntry(CheckReport.ResultType.FAILURE, string3);
                        break block29;
                    }
                    parameter = (Parameter)outputParams.iterator().next();
                    if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && parameter.getUDTName().equals("java.sql.ResultSet")) break block30;
                    msg = "With '%s' set to 'true' exactly one output parameter must exist and it must have the data type %s and the UDT name 'java.sql.ResultSet'!";
                    msg = String.format(msg, new Object[]{"SerialiseResultSet", ProcessConstants.AdeptDataType.USERDEFINED});
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                    break block29;
                }
                if (parameter.getConfiguration().getAllEntries().size() == 0) break block29;
                msg = "The single output parameter '%s' does not need anyactivity type parameter configuration!";
                msg = String.format(msg, parameter.getName());
                this.addReportEntry(CheckReport.ResultType.WARNING, msg);
                break block29;
            }
            for (Parameter parameter : outputParams) {
                String columnIndexString = parameter.getConfiguration().getString("ColumnIndex");
                String columnName = parameter.getConfiguration().getString("ColumnName");
                if (columnIndexString != null && columnName != null) {
                    String msg = "Only one of the activity type parameter configuration fields '%s' and '%s' may be set for the output parameter '%s'!";
                    msg = String.format(msg, "ColumnIndex", "ColumnName", parameter.getName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
                if (columnIndexString != null) {
                    try {
                        int index = Integer.parseInt(columnIndexString);
                        if (index < 0) {
                            String msg = "The activity type parameter configuration field '%s' of the output parameter '%s' has a negative value! The index must be a non-negative number.";
                            msg = String.format(msg, "ColumnIndex", parameter.getName());
                            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        String msg = "The activity type parameter configuration field '%s' of the output parameter '%s' doesn't have a valid integer value! The index must be a non-negative number.";
                        msg = String.format(msg, "ColumnIndex", parameter.getName());
                        this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                    }
                } else if (columnName == null && !writtenFromStoredProc.contains(parameter.getName())) {
                    if (parameter.isOptional()) {
                        String msg = "The optional output parameter '%s' is never written!";
                        msg = String.format(msg, parameter.getName());
                        this.addReportEntry(CheckReport.ResultType.WARNING, msg);
                    } else {
                        String msg = "For the output parameter '%s' a value is neither supplied from a result set nor from the output parameter of stored procedure!";
                        msg = String.format(msg, parameter.getName());
                        this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                    }
                }
                if (columnIndexString == null && columnName == null || !writtenFromStoredProc.contains(parameter.getName())) continue;
                String msg = "The value of output parameter '%s' is supplied from the result set and (at least) one output parameter of a stored procecure call. So it's written at least twice.";
                msg = String.format(msg, parameter.getName());
                this.addReportEntry(CheckReport.ResultType.WARNING, msg);
            }
        }
    }

    private void checkOp_dynamicInsert(AbstractActivity activity) {
        String tableName;
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.checkConfEntrySet(conf, "TableName") && this.checkConfValueAvailable(conf, "TableName") && ((tableName = conf.getString("TableName")).trim().equals("") || tableName.contains(" "))) {
            String msg = "The table name in the activity configuration field '%s' must not be blank or contain spaces!";
            msg = String.format(msg, "TableName");
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
    }

    private void checkInputParameterReferences(ParameterRef[] paramRefs, AbstractActivity activity) {
        ParameterRef[] parameterRefArray = paramRefs;
        int n = paramRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef ref = parameterRefArray[n2];
            if (ref.getName() != null) {
                String msg;
                Parameter param = activity.getParameter(ref.getName(), ActivityConstants.AccessType.READ);
                if (param == null) {
                    msg = "The input parameter '%s' referenced in the SQL statement(s) does not exist!";
                    msg = String.format(msg, ref.getName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                } else if (ref.getDataType() != param.getDataType()) {
                    msg = "The reference to input parameter '%s' has a different data type (%s) than the parameter itself (%s)!";
                    msg = String.format(msg, new Object[]{ref.getName(), ref.getDataType(), param.getDataType()});
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
            }
            ++n2;
        }
    }

    private void checkOutputParameterReferences(IOParameterRef[] paramRefs, AbstractActivity activity) {
        IOParameterRef[] iOParameterRefArray = paramRefs;
        int n = paramRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IOParameterRef ref = iOParameterRefArray[n2];
            if (ref.getOutputName() != null) {
                String msg;
                Parameter param = activity.getParameter(ref.getOutputName(), ActivityConstants.AccessType.WRITE);
                if (param == null) {
                    msg = "The output parameter '%s' referenced in the SQL statement(s) does not exist!";
                    msg = String.format(msg, ref.getOutputName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                } else if (ref.getDataType() != param.getDataType()) {
                    msg = "The reference to output parameter '%s' has a different data type (%s) than the parameter itself (%s)!";
                    msg = String.format(msg, new Object[]{ref.getOutputName(), ref.getDataType(), param.getDataType()});
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
            }
            ++n2;
        }
    }

    private void checkInputParameters(AbstractActivity activity) {
    }
}

