/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public abstract class AbstractDatabaseComponent
extends ExecutionEnvironment {
    protected String dataSourceName;
    protected String driver;
    protected String connectionURL;
    protected String userName;
    protected String password;
    protected DataSource dataSource;

    protected AbstractDatabaseComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        this.dataSourceName = conf.getString("DB.DataSourceName");
        this.driver = conf.getString("DB.Driver");
        this.connectionURL = conf.getString("DB.ConnectionURL");
        this.userName = conf.getString("DB.UserName");
        this.password = conf.getString("DB.Password");
        if (this.password == null) {
            this.password = "";
        } else {
            try {
                this.password = ConfigurationTools.parsePassword(this.password);
            }
            catch (GeneralSecurityException generalSecurityException) {}
        }
        if (this.dataSourceName != null) {
            try {
                InitialContext ctx = new InitialContext();
                Object object = ctx.lookup(this.dataSourceName);
                if (!(object instanceof DataSource)) {
                    String msg = "The object referenced by the logical name '%s' is no javax.sql.DataSource: %s";
                    msg = String.format(msg, this.dataSourceName, object == null ? null : object.getClass().getName());
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                this.dataSource = (DataSource)object;
            }
            catch (NamingException ex) {
                String msg = "Failed to retrieve the DataSource by its logical name '%s'.";
                msg = String.format(msg, this.dataSourceName);
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
        }
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (ClassNotFoundException ex) {
            String msg = String.format("Unable to find specified JDBC-driver '%s'. Please check the path and the configuration.", this.driver);
            this.logger.severe(msg);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
        catch (IllegalAccessException ex) {
            String msg = "Unable to access the constructor of the specified JDBC-driver '%s'. Please check the path and the configuration.";
            msg = String.format(msg, this.driver);
            this.logger.severe(msg);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
        catch (InstantiationException ex) {
            String msg = "Unable to instantiate specified JDBC-driver '%s'. Please check the path and the configuration.";
            msg = String.format(msg, this.driver);
            this.logger.severe(msg);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        return DriverManager.getConnection(this.connectionURL, this.userName, this.password);
    }
}

