/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.environments;

import com.sun.rowset.CachedRowSetImpl;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.extensions.sqlsupport.Constants;
import de.aristaflow.adept2.extensions.sqlsupport.DatabaseComponentHelpers;
import de.aristaflow.adept2.extensions.sqlsupport.environments.AbstractDatabaseComponent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.paramref.IOParameterRef;
import de.aristaflow.adept2.model.common.paramref.IOParameterRefReplacer;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefReplacer;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class DatabaseAccessComponent
extends AbstractDatabaseComponent {
    public DatabaseAccessComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        String opName = this.activityInstance.getOperationName();
        if (opName.equals("executeStatements")) {
            this.op_executeStatements();
        } else if (opName.equals("dynamicInsert")) {
            this.op_dynamicInsert();
        } else {
            String msg = "Unknown operation encountered: " + opName;
            throw new ApplicationEnvironmentException(msg, 0L);
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private void op_executeStatements() {
        List<String> rawStatements;
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        String rawStatementsString = conf.getString("SQLStatements");
        try {
            rawStatements = SQLTools.parseSQLStringToStatements(rawStatementsString, null);
        }
        catch (IOException ex) {
            String msg = "The SQL statements string '%s' could not be parsed!";
            msg = String.format(msg, rawStatementsString);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                int i = 0;
                int size = rawStatements.size();
                while (i < size) {
                    String msg;
                    String statement;
                    Object replacer;
                    String rawStatement = rawStatements.get(i);
                    boolean isFinalStatment = i == size - 1;
                    boolean isStoredProcedureCall = Constants.STORED_PROCEDURE_CALL_PATTERN.matcher(rawStatement).matches();
                    if (isStoredProcedureCall) {
                        replacer = ParameterRefTools.getIOReplacer(rawStatement, null);
                        while (((IOParameterRefReplacer)replacer).findNext()) {
                            ((IOParameterRefReplacer)replacer).replaceWith("?");
                        }
                        statement = ((IOParameterRefReplacer)replacer).getProcessedString();
                    } else {
                        replacer = ParameterRefTools.getReplacer(rawStatement, null);
                        while (((ParameterRefReplacer)replacer).findNext()) {
                            ((ParameterRefReplacer)replacer).replaceWith("?");
                        }
                        statement = ((ParameterRefReplacer)replacer).getProcessedString();
                    }
                    Set<ProcessModelParameter> outParams = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
                    try {
                        if (isStoredProcedureCall) {
                            CallableStatement cstmt = con.prepareCall(statement);
                            pstmt = cstmt;
                            ParameterRef[] refs = ParameterRefTools.listIOParameterReferences(rawStatement, null);
                            this.setInputParamsFromReferences(refs, cstmt);
                            this.registerStoredProcOutputParams((IOParameterRef[])refs, cstmt);
                            cstmt.execute();
                            if (isFinalStatment) {
                                this.processResultSet(pstmt, outParams);
                            }
                            this.readStoredProcOutputParams((IOParameterRef[])refs, cstmt);
                            cstmt = JDBCTools.close(cstmt);
                            pstmt = null;
                        } else {
                            pstmt = con.prepareStatement(statement);
                            ParameterRef[] refs = ParameterRefTools.listParameterReferences(rawStatement, null);
                            this.setInputParamsFromReferences(refs, pstmt);
                            pstmt.execute();
                            if (isFinalStatment) {
                                this.processResultSet(pstmt, outParams);
                            }
                            pstmt = JDBCTools.close(pstmt);
                        }
                    }
                    catch (SQLException ex) {
                        msg = "An error occured while executing the SQL statement '%s'!";
                        msg = String.format(msg, statement);
                        throw new ApplicationFailedException(msg, null, 0L, ex);
                    }
                    catch (RuntimeException ex) {
                        msg = "An error occured while executing the SQL statement '%s'!";
                        msg = String.format(msg, statement);
                        throw new ApplicationFailedException(msg, null, 0L, ex);
                    }
                    ++i;
                }
                con = JDBCTools.close(con);
            }
            catch (SQLException ex) {
                String msg = "An error occured while executing the SQL statements!";
                throw new ApplicationFailedException(msg, null, 0L, ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(con, pstmt);
        }
    }

    private void op_dynamicInsert() {
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        String tableName = conf.getString("TableName");
        Set<ProcessModelParameter> inParams = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO ").append(tableName).append(" (");
        boolean first = true;
        for (ProcessModelParameter inParam : inParams) {
            if (first) {
                first = false;
            } else {
                stmt.append(", ");
            }
            stmt.append(inParam.getName());
        }
        stmt.append(") VALUES (");
        int i = 0;
        int parameterCount = inParams.size();
        while (i < parameterCount) {
            if (i > 0) {
                stmt.append(", ");
            }
            stmt.append("?");
            ++i;
        }
        stmt.append(")");
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            try {
                con = this.getConnection();
                pstmt = con.prepareStatement(stmt.toString());
                int columnIndex = 1;
                for (ProcessModelParameter inParam : inParams) {
                    DatabaseComponentHelpers.setInputParam(inParam, this.sessionContext.getDataContext(), pstmt, columnIndex, this.activityInstance.getName());
                    ++columnIndex;
                }
                pstmt.execute();
                pstmt = JDBCTools.close(pstmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException ex) {
                String msg = "An error occured while executing the INSERT statement!";
                throw new ApplicationFailedException(msg, null, 0L, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)pstmt);
    }

    private void setInputParamsFromReferences(ParameterRef[] paramRefs, PreparedStatement pstmt) throws SQLException {
        int i = 0;
        int length = paramRefs.length;
        while (i < length) {
            ParameterRef ref = paramRefs[i];
            if (ref.getName() != null) {
                ProcessModelParameter param = this.activityInstance.getParameter(ref.getName(), ActivityConstants.AccessType.READ);
                if (param == null) {
                    String msg = "The referenced input parameter '%s' does not exist!";
                    msg = String.format(msg, ref.getName());
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                if (param.getDataType() != ref.getDataType()) {
                    String msg = "The input parameter '%s' and its reference have different data types: %s != %s!";
                    msg = String.format(msg, new Object[]{param.getName(), param.getDataType(), ref.getDataType()});
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                int columnIndex = i + 1;
                DatabaseComponentHelpers.setInputParam(param, this.sessionContext.getDataContext(), pstmt, columnIndex, this.activityInstance.getName());
            }
            ++i;
        }
    }

    private void registerStoredProcOutputParams(IOParameterRef[] paramRefs, CallableStatement cstmt) throws SQLException {
        int i = 0;
        int length = paramRefs.length;
        while (i < length) {
            IOParameterRef ref = paramRefs[i];
            if (ref.getOutputName() != null) {
                ProcessModelParameter param = this.activityInstance.getParameter(ref.getOutputName(), ActivityConstants.AccessType.WRITE);
                if (param == null) {
                    String msg = "The referenced output parameter '%s' does not exist!";
                    msg = String.format(msg, ref.getOutputName());
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                if (param.getDataType() != ref.getDataType()) {
                    String msg = "The output parameter '%s' and its reference have different data types: %s != %s!";
                    msg = String.format(msg, new Object[]{param.getName(), param.getDataType(), ref.getDataType()});
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                switch (param.getDataType()) {
                    case BOOLEAN: {
                        cstmt.registerOutParameter(i + 1, -7);
                        break;
                    }
                    case INTEGER: {
                        cstmt.registerOutParameter(i + 1, -5);
                        break;
                    }
                    case FLOAT: {
                        cstmt.registerOutParameter(i + 1, 8);
                        break;
                    }
                    case STRING: 
                    case URI: {
                        cstmt.registerOutParameter(i + 1, 12);
                        break;
                    }
                    case DATE: {
                        int typeCode = cstmt.getParameterMetaData().getParameterType(i + 1);
                        if (typeCode != 91 && typeCode != 92 && typeCode != 93) {
                            typeCode = 93;
                        }
                        cstmt.registerOutParameter(i + 1, typeCode);
                        break;
                    }
                    case USERDEFINED: {
                        cstmt.registerOutParameter(i + 1, 2004);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)((Object)((Object)param.getDataType()) + " not supported/implemented"));
                    }
                }
            }
            ++i;
        }
    }

    private void readStoredProcOutputParams(IOParameterRef[] paramRefs, CallableStatement cstmt) throws SQLException {
        int i = 0;
        int length = paramRefs.length;
        while (i < length) {
            IOParameterRef ref = paramRefs[i];
            if (ref.getOutputName() != null) {
                String msg;
                ProcessModelParameter param = this.activityInstance.getParameter(ref.getOutputName(), ActivityConstants.AccessType.WRITE);
                DataContext dataContext = this.sessionContext.getDataContext();
                try {
                    switch (param.getDataType()) {
                        case BOOLEAN: {
                            boolean value = cstmt.getBoolean(i + 1);
                            if (cstmt.wasNull()) {
                                dataContext.ignoreValue(param.getName());
                            } else {
                                dataContext.storeBooleanParameterValue(param.getName(), value);
                            }
                            break;
                        }
                        case INTEGER: {
                            long value = cstmt.getLong(i + 1);
                            if (cstmt.wasNull()) {
                                dataContext.ignoreValue(param.getName());
                            } else {
                                dataContext.storeIntegerParameterValue(param.getName(), value);
                            }
                            break;
                        }
                        case FLOAT: {
                            double value = cstmt.getDouble(i + 1);
                            if (cstmt.wasNull()) {
                                dataContext.ignoreValue(param.getName());
                            } else {
                                dataContext.storeFloatParameterValue(param.getName(), value);
                            }
                            break;
                        }
                        case STRING: {
                            String value = cstmt.getString(i + 1);
                            if (cstmt.wasNull()) {
                                dataContext.ignoreValue(param.getName());
                            } else {
                                dataContext.storeStringParameterValue(param.getName(), value);
                            }
                            break;
                        }
                        case URI: {
                            String valueString = cstmt.getString(i + 1);
                            Serializable value = new URI(valueString);
                            if (cstmt.wasNull()) {
                                dataContext.ignoreValue(param.getName());
                            } else {
                                dataContext.storeURIParameterValue(param.getName(), (URI)value);
                            }
                            break;
                        }
                        case DATE: {
                            int typeCode = cstmt.getParameterMetaData().getParameterType(i + 1);
                            Date value = typeCode == 91 ? cstmt.getDate(i + 1, JDBCTools.createUTCCalendar()) : (typeCode == 92 ? cstmt.getTime(i + 1, JDBCTools.createUTCCalendar()) : cstmt.getTimestamp(i + 1, JDBCTools.createUTCCalendar()));
                            if (cstmt.wasNull()) {
                                dataContext.ignoreValue(param.getName());
                            } else {
                                dataContext.storeDateParameterValue(param.getName(), value);
                            }
                            break;
                        }
                        case USERDEFINED: {
                            byte[] valueBytes = cstmt.getBytes(i + 1);
                            Serializable value = new ADEPT2UDTValue(param.getUDTName(), valueBytes);
                            if (cstmt.wasNull()) {
                                dataContext.ignoreValue(param.getName());
                            } else {
                                dataContext.storeUDTParameterValue(param.getName(), (UDTValue)value);
                            }
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)((Object)((Object)param.getDataType()) + " not supported/implemented"));
                        }
                    }
                }
                catch (NoSuchParameterException ex) {
                    msg = "The data context of activity '%s' is missing the expected output parameter '%s'!";
                    msg = String.format(msg, this.activityInstance.getName(), ref.getOutputName());
                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                }
                catch (InvalidDataTypeException ex) {
                    msg = "The data context of activity '%s' doesn't accept the data type %s of parameter '%s'!";
                    msg = String.format(msg, new Object[]{this.activityInstance.getName(), ref.getDataType(), ref.getOutputName()});
                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                }
                catch (URISyntaxException ex) {
                    msg = "The string value retrieved from the SQL SELECT statement for parameter '%s' in activity '%s' is no valid URI!";
                    msg = String.format(msg, param.getName(), this.activityInstance.getName());
                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                }
            }
            ++i;
        }
    }

    private void processResultSet(PreparedStatement pstmt, Collection<ProcessModelParameter> outputParams) throws SQLException {
        boolean serialiseResultSet = Boolean.parseBoolean(this.activityInstance.getConfiguration().getString("SerialiseResultSet"));
        boolean hasMandatoryOutputParams = false;
        for (ProcessModelParameter outputParam : outputParams) {
            ActivityConfiguration conf = outputParam.getConfiguration();
            if (outputParam.isOptional() || conf.getString("ColumnIndex") == null && conf.getString("ColumnName") == null) continue;
            hasMandatoryOutputParams = true;
            break;
        }
        ResultSet rs = null;
        try {
            String msg;
            rs = pstmt.getResultSet();
            if (rs == null) {
                if (serialiseResultSet || hasMandatoryOutputParams) {
                    String msg2 = "The activity '%s' has output parameters but the the SQL statement did not produce a result set!";
                    msg2 = String.format(msg2, this.activityInstance.getName());
                    throw new ApplicationEnvironmentException(msg2, 0L);
                }
                return;
            }
            DataContext dataContext = this.sessionContext.getDataContext();
            if (serialiseResultSet) {
                if (outputParams.size() != 1) {
                    msg = "The activity '%s' must have exactly one output parameter!";
                    msg = String.format(msg, this.activityInstance.getName());
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                ProcessModelParameter outParam = outputParams.iterator().next();
                if (outParam.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || !outParam.getUDTName().equals("java.sql.ResultSet")) {
                    String msg3 = "The single output parameter '%s' of activity '%s' must have the data type %s and the user defined type %s!";
                    msg3 = String.format(msg3, new Object[]{outParam.getName(), this.activityInstance.getName(), ProcessConstants.AdeptDataType.USERDEFINED, outParam.getUDTName()});
                    throw new ApplicationEnvironmentException(msg3, 0L);
                }
                CachedRowSetImpl rowSet = new CachedRowSetImpl();
                rowSet.populate(rs);
                try {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(byteOut);
                    out.writeObject(rowSet);
                    ADEPT2UDTValue value = new ADEPT2UDTValue(outParam.getUDTName(), byteOut.toByteArray());
                    dataContext.storeUDTParameterValue(outParam.getName(), value);
                }
                catch (IOException ex) {
                    String msg4 = "The result set created by activity '%s' could not be serialised!";
                    msg4 = String.format(msg4, this.activityInstance.getName());
                    throw new ApplicationFailedException(msg4, null, 0L, ex);
                }
                catch (NoSuchParameterException ex) {
                    String msg5 = "The data context of activity '%s' is missing the expected output parameter '%s'!";
                    msg5 = String.format(msg5, this.activityInstance.getName(), outParam.getName());
                    throw new ApplicationEnvironmentException(msg5, 0L, ex);
                }
                catch (InvalidDataTypeException ex) {
                    String msg6 = "The data context of activity '%s' doesn't accept the data type %s of parameter '%s'!";
                    msg6 = String.format(msg6, new Object[]{this.activityInstance.getName(), outParam.getDataType(), outParam.getName()});
                    throw new ApplicationEnvironmentException(msg6, 0L, ex);
                }
            } else if (!rs.next()) {
                if (hasMandatoryOutputParams) {
                    msg = "The result set produced by the SQL statement of activity '%s' does not contain any rows!";
                    msg = String.format(msg, this.activityInstance.getName());
                    throw new ApplicationFailedException(msg, null, 0L);
                }
            } else {
                DatabaseComponentHelpers.processResultSet(rs, outputParams, dataContext, this.activityInstance.getName());
            }
            rs = JDBCTools.close(rs);
        }
        finally {
            JDBCTools.closeQuietly(rs);
        }
    }
}

