/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.eventhandler;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.eventmanager.ActivityEventManager;
import de.aristaflow.adept2.core.eventmanager.common.AbstractActivityEventHandler;
import de.aristaflow.adept2.core.runtimeservice.RemoteRuntimeEnvironment;
import de.aristaflow.adept2.extensions.sqlsupport.DatabaseComponentHelpers;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.model.events.EventHandlingException;
import de.aristaflow.adept2.model.events.ResultSetEvent;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.StackTraceTools;
import de.aristaflow.adept2.util.types.Pair;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DBEventActivityHandler
extends AbstractActivityEventHandler {
    protected final ActivityEventManager eventManager;

    public DBEventActivityHandler(Configuration conf, ActivityEventManager eventManager, Registry registry) {
        super(registry, true, false);
        ArgChecks.checkForNull(eventManager, "eventManager");
        this.eventManager = eventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Event eve, boolean consumed) throws EventHandlingException {
        Pair<SessionToken, SimpleSessionContext> newContext;
        String msg;
        boolean ret = false;
        if (!(eve instanceof ResultSetEvent) || consumed) {
            return ret;
        }
        ResultSetEvent event = (ResultSetEvent)eve;
        String sourceID = event.getSourceID();
        Exception innerException = null;
        try {
            Map map = this.contexts;
            synchronized (map) {
                msg = "Try to get context for source '%s'.";
                msg = String.format(msg, sourceID);
                this.logger.finer(msg);
                if (!this.contexts.containsKey(sourceID)) {
                    msg = "The activity for event '%s/%s/%s/%s' (service: '%s') is not registered. Cannot handle it.";
                    msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                    throw new EventHandlingException(msg);
                }
                SimpleSessionContext oldContext = (SimpleSessionContext)this.contexts.get(sourceID);
                EBPInstanceReference activity = oldContext.getEBPInstanceReference();
                msg = "Start activity '%s' with source '%s'.";
                msg = String.format(msg, activity, sourceID);
                this.logger.finest(msg);
                newContext = this.eventManager.startActivity(activity, ProcessConstants.ExecutionMode.PRODUCTION);
            }
        }
        catch (InvalidActivityStateException iase) {
            String msg2 = "Could not start/resume activity for DB event '%s/%s/%s/%s' (service: '%s'). The activity has the wrong state. Maybe it has already been started and the corresponding worklist update is pending.";
            msg2 = String.format(msg2, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg2, iase);
        }
        catch (InvalidInstanceStateException iise) {
            String msg3 = "Could not start/resume activity for DB event '%s/%s/%s/%s'  (service: %s). The corresponding instance has an invalid state for activity execution. Maybe the corresponding worklist update is pending.";
            msg3 = String.format(msg3, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg3, iise);
        }
        catch (InterruptedException ie) {
            String msg4 = "Could not start/resume activity for DB event '%s/%s/%s/%s' (service: %s) since the runtime service is terminating. Try again later.";
            msg4 = String.format(msg4, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg4, ie);
        }
        if (newContext == null) {
            msg = "Could not start/resume activity for DB event '%s/%s/%s/%s' (service: %s). A timeout elasped when waiting for the start/resume of the activity. The activity may be in the wrong state now. Please check and reset it if appropriate.";
            msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg);
        }
        ret = true;
        SessionToken session = newContext.getFirst();
        SimpleSessionContext context = newContext.getSecond();
        try {
            try {
                try {
                    this.processResultSet(event.getResultSet(), context.getActivityInstance(), context.getDataContext());
                    RemoteRuntimeEnvironment environment = this.eventManager.getRuntimeEnvironment();
                    environment.applicationClosed(session, context.getSessionID(), context.getDataContext());
                }
                catch (SQLException sqle) {
                    innerException = sqle;
                    msg = "An SQL exception occurred when handling the DB event '%s/%s/%s/%s' (service: %s). We fail the corresponding activity.";
                    msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                    this.eventManager.getRuntimeEnvironment().applicationFailed(session, context.getSessionID(), msg, "AristaFlow:SQLSupport:ActivityEventHandler:ResultSet:SQLException", 1300001L, context.getDataContext());
                }
                catch (ApplicationEnvironmentException aee) {
                    innerException = aee;
                    this.eventManager.getRuntimeEnvironment().applicationFailed(session, context.getSessionID(), aee.getMessage(), "AristaFlow:SQLSupport:ActivityEventHandler:ApplicationEnvironmentException", aee.getErrorCode(), context.getDataContext());
                }
                catch (ApplicationFailedException afe) {
                    innerException = afe;
                    this.eventManager.getRuntimeEnvironment().applicationFailed(session, context.getSessionID(), afe.getMessage(), afe.getState(), afe.getErrorCode(), context.getDataContext());
                }
            }
            catch (UnknownSessionException use) {
                String innerMsg;
                if (innerException != null) {
                    innerMsg = " Inner exception causing the failing: %s.\n%s";
                    innerMsg = String.format(innerMsg, innerException.getMessage(), StackTraceTools.stackTraceToString(innerException));
                } else {
                    innerMsg = "";
                }
                msg = "Could not %s activity when handling the DB event '%s/%s/%s/%s' (service: %s). The activity is running but we handle the event and terminate the activity. The activity is in the wrong state now. Please reset it.%s";
                msg = String.format(msg, innerException == null ? "close" : "fail", eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()), innerMsg);
                this.logger.log(Level.SEVERE, msg, use);
                this.remove(sourceID);
            }
        }
        finally {
            this.remove(sourceID);
        }
        return ret;
    }

    protected void processResultSet(ResultSet rs, ActivityInstance activity, DataContext dataContext) throws SQLException {
        boolean hasMandatoryOutputParams = false;
        Set<ProcessModelParameter> outParams = activity.getParameters(ActivityConstants.AccessType.WRITE);
        for (Parameter parameter : outParams) {
            ActivityConfiguration conf = parameter.getConfiguration();
            if (parameter.isOptional() || conf.getString("ColumnIndex") == null && conf.getString("ColumnName") == null) continue;
            hasMandatoryOutputParams = true;
            break;
        }
        if (rs.first()) {
            DatabaseComponentHelpers.processResultSet(rs, outParams, dataContext, activity.getName());
        } else if (hasMandatoryOutputParams) {
            String string2 = "The result set produced by the SQL statement of activity '%s' does not contain any rows!";
            string2 = String.format(string2, activity.getName());
            throw new ApplicationFailedException(string2, "AristaFlow:SQLSupport:ActivityEventHandler:MandatoryOutputParameterRequired", 1100005L);
        }
    }
}

