/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.sqlsupport.eventhandler;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.eventmanager.common.AbstractEventHandler;
import de.aristaflow.adept2.core.eventmanager.common.DefaultEventManager;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.model.events.EventHandlingException;
import de.aristaflow.adept2.model.events.ResultSetEvent;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.StringTools;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="ProcessType", isRequired=true, description="The process tye of which to start the \"latest\" template as soon as the event occurs."), @Property(name="IgnoreInputParameter", type=Property.Type.BOOLEAN, defaultValue="true", description="Whether the input parameters of the template to be started should be ignored. This will only work if either the template does not have any input parameters or only optional input parameters."), @Property(name="MarkHandledRows", type=Property.Type.STRING, isRequired=true, restrictions={"oneof/i: None, Insert, Update, Delete"}, description="Determines if and how handled rows are marked as such. They can either be deleted or updated according to the configured columns and values.")})
public class InstanceStartEventHandler
extends AbstractEventHandler {
    protected static final String CONF_INPUT_PARAMETER = "InputParameter";
    protected static final String CONF_PROCESS_TYPE = "ProcessType";
    public static final String CONF_ROW_MARKING = "MarkHandledRows";
    protected final String processType;
    protected final boolean insertRow;
    protected final boolean updateRow;
    protected final boolean deleteRow;
    protected Configuration options;
    protected TemplateReference template;
    protected static final String CONF_IGNORE_INPUT_PARAMETER = "IgnoreInputParameter";
    protected final boolean ignoreInputParameter;
    protected final Configuration paramMapping;
    protected final DefaultEventManager eventManager;
    protected final Registry registry;

    public InstanceStartEventHandler(Configuration conf, DefaultEventManager eventManager, Registry registry) throws ConfigurationException {
        super(registry, true, false);
        ArgChecks.checkForNull(eventManager, "eventManager");
        this.processType = conf.getString(CONF_PROCESS_TYPE);
        this.ignoreInputParameter = conf.getBoolean(CONF_IGNORE_INPUT_PARAMETER);
        String key = String.format("%s.%s", this.processType, CONF_INPUT_PARAMETER);
        this.paramMapping = conf.subset(key);
        this.insertRow = conf.getString(CONF_ROW_MARKING).equalsIgnoreCase("Insert");
        if (this.insertRow) {
            this.options = conf.subset("InsertRow");
        }
        this.updateRow = conf.getString(CONF_ROW_MARKING).equalsIgnoreCase("Update");
        if (this.updateRow) {
            this.options = conf.subset("UpdateRow");
        }
        this.deleteRow = conf.getString(CONF_ROW_MARKING).equalsIgnoreCase("Delete");
        this.eventManager = eventManager;
        this.registry = registry;
        SessionToken session = eventManager.createSession();
        this.template = this.getAndCheckTemplate(session);
        if (this.template == null) {
            String msg = "Cannot retrieve a template for process type '%s'. Please check the templates in the process manager.";
            msg = String.format(msg, this.processType);
            throw new ConfigurationException(String.format(msg, this.processType));
        }
    }

    protected TemplateReference getAndCheckTemplate(SessionToken session) throws ConfigurationException {
        TemplateReference ret = this.eventManager.getLatestTemplateReference(session, this.processType);
        if (ret != null) {
            HashMap<String, Parameter> inputParams = new HashMap<String, Parameter>();
            for (Parameter parameter : ret.getInputParameters()) {
                inputParams.put(parameter.getName(), parameter);
            }
            for (Parameter parameter : inputParams.values()) {
                String name = parameter.getName();
                if (!parameter.isOptional() && this.ignoreInputParameter) {
                    String msg = "Template input parameter '%s' of template '%s' is mandatory but the event handler is configured to ignore all input parameters. Therefore it cannot start an instance of this template.";
                    msg = String.format(msg, name, ret.getID());
                    throw new ConfigurationException(msg);
                }
                if (parameter.isOptional() || !this.paramMapping.subset(name).isEmpty()) continue;
                String msg = "Template input parameter '%s' of template '%s' is mandatory but the event handler has no configuration on where to get its value from. Therefore it cannot start an instance of this template.";
                msg = String.format(msg, name, ret.getID());
                throw new ConfigurationException(msg);
            }
            Iterator iterator = this.paramMapping.getKeys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                int li = key.lastIndexOf(".");
                String name = li > -1 ? key.substring(0, li) : key;
                if (inputParams.containsKey(name)) continue;
                String msg = "There is a configuration for the input parameter '%s' but the template '%s' does not have this input parameter. Please make sure that you the process template/process type is used that you intend to use.";
                msg = String.format(msg, name, ret.getID());
                throw new ConfigurationException(msg);
            }
        }
        return ret;
    }

    @Override
    public boolean handleEvent(Event eve, boolean consumed) throws EventHandlingException {
        boolean ret = false;
        if (!(eve instanceof ResultSetEvent) || consumed) {
            return ret;
        }
        ResultSetEvent event = (ResultSetEvent)eve;
        SessionToken session = this.eventManager.createSession();
        if (this.template == null) {
            try {
                this.template = this.getAndCheckTemplate(session);
            }
            catch (ConfigurationException ce) {
                String msg = "Cannot start an instance of process type '%s' for event '%s/%s/%s/%s' (service: '%s') since there are problems with the configured input parameter.";
                msg = String.format(msg, this.processType, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg, ce);
            }
            if (this.template == null) {
                String msg = "No template for the process type '%s' to be instantiated for event '%s/%s/%s/%s' (service: '%s') found.";
                msg = String.format(msg, this.processType, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg);
            }
        }
        UUID templateID = this.template.getID();
        try {
            ResultSet rs = event.getResultSet();
            if (rs.first()) {
                do {
                    InstanceDataContainer dataContainer = null;
                    if (!this.ignoreInputParameter) {
                        Set<ProcessModelParameter> inParams = this.template.getInputParameters();
                        dataContainer = this.eventManager.createInstanceDataContainer(session, templateID);
                        this.processResultSetRow(rs, inParams, dataContainer, this.paramMapping, templateID);
                    }
                    this.eventManager.createAndStartInstance(session, templateID, dataContainer);
                    this.markHandledRow(rs);
                } while (rs.next());
            }
            ret = true;
        }
        catch (IllegalArgumentException iae) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') since the template does not exist any more. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, iae);
        }
        catch (InvalidTemplateStateException itse) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') since the template is in the wrong state. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, itse);
        }
        catch (InvalidDataContainerException idce) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to problems with the instance data container. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, idce);
        }
        catch (SQLException sqle) {
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to problems when accessing the result set.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, sqle);
        }
        catch (ApplicationEnvironmentException aee) {
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to problems with the mapping of result set columns to parameter.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, aee);
        }
        catch (InvalidDataTypeException idte) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to an input parameter having the wrong data type. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, idte);
        }
        catch (NoSuchParameterException nspe) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to an input parameter not being present in the instance data container. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, nspe);
        }
        catch (URISyntaxException urise) {
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to the result set not providing a valid value for an URI input parameter.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, urise);
        }
        catch (IOException ioe) {
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to a problem when creating an UDT value for an input parameter.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, ioe);
        }
        return ret;
    }

    private void processResultSetRow(ResultSet rs, Collection<? extends Parameter> inParams, InstanceDataContainer dataContainer, Configuration paramMapping, UUID templateID) throws URISyntaxException, SQLException, InvalidDataTypeException, NoSuchParameterException, IOException {
        for (Parameter parameter : inParams) {
            String paramName = parameter.getName();
            String confIndex = String.format("%s.%s", paramName, "ColumnIndex");
            String confName = String.format("%s.%s", paramName, "ColumnName");
            if (paramMapping.getString(confIndex) != null) {
                int columnCount = rs.getMetaData().getColumnCount();
                int columnIndex = Integer.parseInt(paramMapping.getString(confIndex));
                if (columnIndex >= columnCount) {
                    String msg = "The result set produced by the SQL statement for starting an instance of template '%s' only contains %d columns, but the configuration specifies the column with the the (0-based) index %d for the instance input parameter '%s'!";
                    msg = String.format(msg, templateID, columnCount, columnIndex, paramName);
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                this.readColumnByIndex(parameter, rs, dataContainer, columnIndex);
                continue;
            }
            String columnName = paramMapping.getString(confName) != null ? paramMapping.getString(confName) : paramName;
            rs.findColumn(columnName);
            this.readColumnByName(parameter, rs, dataContainer, columnName);
        }
    }

    private void readColumnByIndex(Parameter param, ResultSet rs, InstanceDataContainer dataContainer, int columnIndex) throws NoSuchParameterException, InvalidDataTypeException, SQLException, URISyntaxException {
        String paramName = param.getName();
        ++columnIndex;
        switch (param.getDataType()) {
            case BOOLEAN: {
                boolean value = rs.getBoolean(columnIndex);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setBoolean(paramName, value);
                break;
            }
            case INTEGER: {
                long value = rs.getLong(columnIndex);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setInteger(paramName, value);
                break;
            }
            case FLOAT: {
                double value = rs.getDouble(columnIndex);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setFloat(paramName, value);
                break;
            }
            case STRING: {
                String value = rs.getString(columnIndex);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setString(paramName, value);
                break;
            }
            case URI: {
                String valueString = rs.getString(columnIndex);
                URI value = new URI(valueString);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setURI(paramName, value);
                break;
            }
            case DATE: {
                int typeCode = rs.getMetaData().getColumnType(columnIndex);
                java.util.Date value = typeCode == 91 ? rs.getDate(columnIndex, JDBCTools.createUTCCalendar()) : (typeCode == 92 ? rs.getTime(columnIndex, JDBCTools.createUTCCalendar()) : rs.getTimestamp(columnIndex, JDBCTools.createUTCCalendar()));
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setDate(paramName, value);
                break;
            }
            case USERDEFINED: {
                byte[] valueBytes = rs.getBytes(columnIndex);
                ADEPT2UDTValue value = new ADEPT2UDTValue(param.getUDTName(), valueBytes);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setUDT(paramName, value);
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)param.getDataType()) + " not supported/implemented"));
            }
        }
    }

    private void readColumnByName(Parameter param, ResultSet rs, InstanceDataContainer dataContainer, String columnName) throws NoSuchParameterException, InvalidDataTypeException, SQLException, URISyntaxException {
        String paramName = param.getName();
        switch (param.getDataType()) {
            case BOOLEAN: {
                boolean value = rs.getBoolean(columnName);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setBoolean(paramName, value);
                break;
            }
            case INTEGER: {
                long value = rs.getLong(columnName);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setInteger(paramName, value);
                break;
            }
            case FLOAT: {
                double value = rs.getDouble(columnName);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setFloat(paramName, value);
                break;
            }
            case STRING: {
                String value = rs.getString(columnName);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setString(paramName, value);
                break;
            }
            case URI: {
                String valueString = rs.getString(columnName);
                URI value = new URI(valueString);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setURI(paramName, value);
                break;
            }
            case DATE: {
                int columnIndex = 1;
                ResultSetMetaData meta = rs.getMetaData();
                int i = 1;
                while (i <= meta.getColumnCount()) {
                    if (meta.getColumnName(i).equalsIgnoreCase(columnName)) {
                        columnIndex = i;
                        break;
                    }
                    ++i;
                }
                int typeCode = meta.getColumnType(columnIndex);
                java.util.Date value = typeCode == 91 ? rs.getDate(columnName, JDBCTools.createUTCCalendar()) : (typeCode == 92 ? rs.getTime(columnName, JDBCTools.createUTCCalendar()) : rs.getTimestamp(columnName, JDBCTools.createUTCCalendar()));
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setDate(paramName, value);
                break;
            }
            case USERDEFINED: {
                byte[] valueBytes = rs.getBytes(columnName);
                ADEPT2UDTValue value = new ADEPT2UDTValue(param.getUDTName(), valueBytes);
                if (rs.wasNull()) {
                    dataContainer.setNull(paramName);
                    break;
                }
                dataContainer.setUDT(paramName, value);
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)param.getDataType()) + " not supported/implemented"));
            }
        }
    }

    private void markHandledRow(ResultSet rs) throws SQLException, EventHandlingException {
        if (this.insertRow) {
            Connection con = rs.getStatement().getConnection();
            PreparedStatement stmt = null;
            try {
                String tableName = this.options.getString("Table");
                String[] columnNames = this.options.getString("IdColumns").split("\\s*,\\s*");
                String sql = "INSERT INTO %s (%s) VALUES (%s)";
                sql = String.format(sql, tableName, StringTools.join(", ", columnNames), StringTools.join(", ", StringTools.repeat("?", columnNames.length)));
                stmt = con.prepareStatement(sql);
                int i = 0;
                while (i < columnNames.length) {
                    stmt.setObject(i + 1, rs.getObject(columnNames[i]));
                    ++i;
                }
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly((Statement)stmt);
        } else if (this.deleteRow) {
            rs.deleteRow();
        } else if (this.updateRow) {
            Iterator keys = this.options.getKeys();
            while (keys.hasNext()) {
                int columnIndex;
                String columnName = (String)keys.next();
                try {
                    columnIndex = rs.findColumn(columnName);
                }
                catch (SQLException ex) {
                    String msg = "The column '%s' - configured to be updated by thishandler - could not be found in the result set.";
                    msg = String.format(msg, columnName);
                    throw new EventHandlingException(msg, ex);
                }
                int columnType = rs.getMetaData().getColumnType(columnIndex);
                switch (columnType) {
                    case -6: {
                        rs.updateByte(columnIndex, this.options.getByte(columnName));
                        break;
                    }
                    case 5: {
                        rs.updateShort(columnIndex, this.options.getShort(columnName));
                        break;
                    }
                    case 4: {
                        rs.updateInt(columnIndex, this.options.getInt(columnName));
                        break;
                    }
                    case -5: {
                        rs.updateLong(columnIndex, this.options.getLong(columnName));
                        break;
                    }
                    case 7: {
                        rs.updateFloat(columnIndex, this.options.getFloat(columnName));
                        break;
                    }
                    case 6: 
                    case 8: {
                        rs.updateDouble(columnIndex, this.options.getDouble(columnName));
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (rs.getMetaData().getScale(columnIndex) > 0) {
                            rs.updateDouble(columnIndex, this.options.getDouble(columnName));
                            break;
                        }
                        int precision = rs.getMetaData().getPrecision(columnIndex);
                        if (precision > 10) {
                            rs.updateLong(columnIndex, this.options.getLong(columnName));
                            break;
                        }
                        if (precision > 5) {
                            rs.updateInt(columnIndex, this.options.getInt(columnName));
                            break;
                        }
                        if (precision > 3) {
                            rs.updateShort(columnIndex, this.options.getShort(columnName));
                            break;
                        }
                        rs.updateByte(columnIndex, this.options.getByte(columnName));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        rs.updateString(columnIndex, this.options.getString(columnName));
                        break;
                    }
                    case 91: {
                        rs.updateDate(columnIndex, new Date(System.currentTimeMillis()));
                        break;
                    }
                    case 93: {
                        rs.updateTimestamp(columnIndex, new Timestamp(System.currentTimeMillis()));
                        break;
                    }
                    default: {
                        String columnTypeName = rs.getMetaData().getColumnTypeName(columnIndex);
                        String msg = "The column type %s (%d) of column '%s' is not supported.";
                        msg = String.format(msg, columnTypeName, columnType, columnName);
                        throw new EventHandlingException(msg);
                    }
                }
                rs.updateRow();
            }
        }
    }
}

