/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.systemtools.environments;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.runtimemanager.executionenvironments.SystemExecutionEnvironment;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import java.util.UUID;
import java.util.logging.Level;

public abstract class AbstractProcessSystemComponent
extends SystemExecutionEnvironment {
    public static final String AC_OPERATION = "Operation";
    public static final String PARAM_INSTANCE_ID = "InstanceID";
    public static final String PARAM_NODE_ID = "NodeID";

    public AbstractProcessSystemComponent(ActivityInstance activityInstance, Registry registry) {
        super(activityInstance, registry);
    }

    UUID getInstanceIDOrFail() {
        DataContext dataContext = this.sessionContext.getDataContext();
        String parameterName = PARAM_INSTANCE_ID;
        String value = null;
        try {
            value = dataContext.retrieveStringParameterValue(parameterName);
            return UUID.fromString(value);
        }
        catch (InvalidDataTypeException e) {
            String message = String.format("Parameter '%s' has inconsistent type, expected %s.", new Object[]{parameterName, ProcessConstants.AdeptDataType.STRING});
            throw new ApplicationEnvironmentException(message, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String message = String.format("Expected parameter '%s' to exist.", parameterName);
            throw new ApplicationEnvironmentException(message, -401000L, e);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Unable to parse '%s' to a UUID: %s", value, e.getMessage());
            this.logger.log(Level.WARNING, message, e);
            String state = "No instance ID";
            throw new ApplicationFailedException(message, state, 1100001L);
        }
    }

    ExecutionManager getExecutionManagerOrFail() {
        ExecutionManager executionManager;
        try {
            SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
            executionManager = this.registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class);
        }
        catch (ServiceNotKnownException e) {
            String message = "Execution manager not reachable.";
            String state = "No execution manager";
            throw new ApplicationFailedException(message, state, 1600000L, e);
        }
        return executionManager;
    }

    ProcessModelFactory getProcessModelFactoryOrFail() {
        ProcessModelFactory pmf = null;
        try {
            pmf = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        }
        catch (ServiceNotKnownException e) {
            String message = "Process model factory not reachable.";
            String state = "No process model factory";
            throw new ApplicationFailedException(message, state, 1600000L, e);
        }
        return pmf;
    }
}

