/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.systemtools.environments;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.DeleteNode;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.executionmanager.InstanceChanging;
import de.aristaflow.adept2.extensions.systemtools.environments.AbstractProcessSystemComponent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeReport;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import java.util.UUID;

public class ProcessChangeComponent
extends AbstractProcessSystemComponent {
    public static final String AC_OPERATION_DELETE_NODE = "DeleteNode";
    public static final String AC_OPERATION_DELETE_VAR_PAR_NODES = "DeleteNodesVarPar";

    public ProcessChangeComponent(ActivityInstance activityInstance, Registry registry) {
        super(activityInstance, registry);
    }

    @Override
    public void run() {
        ActivityConfiguration configuration = this.activityInstance.getConfiguration();
        String operation = configuration.getString("Operation");
        if (AC_OPERATION_DELETE_NODE.equals(operation)) {
            this.deleteNode();
        }
    }

    private void deleteNode() {
        UUID instanceID = this.getInstanceIDOrFail();
        if (instanceID.equals(this.sessionContext.getEBPInstanceReference().getInstanceID())) {
            String message = "Tried to change the own instance, this is not possible";
            String state = "Selfchange";
            throw new ApplicationFailedException(message, state, 1600000L);
        }
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        long deleteNodeIDl = this.getDualInputParameterValue("NodeID", ProcessConstants.AdeptDataType.INTEGER, Long.class);
        int deleteNodeID = Long.valueOf(deleteNodeIDl).intValue();
        if ((long)deleteNodeID != deleteNodeIDl) {
            String message = "Illegal node ID, not an integer.";
            String state = "Illegal Node ID";
            throw new ApplicationFailedException(message, state, 1600000L);
        }
        boolean failOnInvalidInstanceState = false;
        this.performChange(new DeleteNodeRunnable(deleteNodeID), session, instanceID, failOnInvalidInstanceState);
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private boolean performChange(ChangeRunnable changeRunnable, SessionToken session, UUID instanceID, boolean failOnInvalidInstanceState) {
        ChangeableInstance instance;
        InstanceChanging instanceChanging = this.getExecutionManagerOrFail().getInstanceChanging();
        try {
            instance = instanceChanging.getInstanceForChanging(session, instanceID);
        }
        catch (InvalidInstanceStateException e) {
            if (failOnInvalidInstanceState) {
                String message = "Instance can not be changed, wrong instance state: " + e.getMessage();
                String state = "Wrong Instance State";
                throw new ApplicationFailedException(message, state, 1600000L, e);
            }
            return false;
        }
        boolean changeSuccessFul = false;
        boolean changed = false;
        try {
            changed = changeRunnable.run(session, instance);
            if (changed) {
                ChangeReport report = instanceChanging.changeAndUnlockInstance(session, instance);
                if (report.newInstanceID == null) {
                    this.logger.info("Changing instance with ID " + instanceID + " failed.");
                } else {
                    changeSuccessFul = true;
                }
            }
        }
        finally {
            if (!changeSuccessFul) {
                instanceChanging.abortInstanceChanging(session, instanceID);
                changed = false;
            }
        }
        return changed;
    }

    public static interface ChangeRunnable {
        public boolean run(SessionToken var1, ChangeableInstance var2);
    }

    static class DeleteNodeRunnable
    implements ChangeRunnable {
        private int deleteNodeID;

        public DeleteNodeRunnable(int deleteNodeID) {
            this.deleteNodeID = deleteNodeID;
        }

        @Override
        public boolean run(SessionToken session, ChangeableInstance instance) {
            boolean successFul = false;
            Node node = instance.getTemplate().getNode(this.deleteNodeID);
            if (DeleteNode.isPossible(instance, node)) {
                StartTransaction.performOperation(instance, null);
                DeleteNode.performOperation(session, instance, node);
                EndTransaction.performOperation(instance, null);
                successFul = true;
            }
            return successFul;
        }
    }
}

