/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.systemtools.environments;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.extensions.systemtools.environments.AbstractProcessSystemComponent;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import java.net.URI;
import java.util.UUID;

public class ProcessInteractionComponent
extends AbstractProcessSystemComponent {
    public final String EC_NAME = "de.aristaflow.systemtools.ProcessInteractionComponent";
    private static final String OP_RESET_ACTIVITY = "ResetActivity";
    private static final String OP_SUSPEND_INSTANCE = "SuspendInstance";
    private static final String OP_RESUME_INSTANCE = "ResumeInstance";
    private static final String OP_ABORT_INSTANCE = "AbortInstance";
    private static final String PARAM_EBP_TYPE = "EBPType";
    private static final String PARAM_TEMPLATE_ID = "TemplateID";
    private static final String PARAM_NODE_ITERATION = "NodeIteration";
    private static final String PARAM_IS_ACTIVITY = "IsActivity";
    private static final String PARAM_PROPAGATE_TO_RUNNING_ACTS = "PropagateToRunningActs";

    public ProcessInteractionComponent(ActivityInstance activityInstance, Registry registry) {
        super(activityInstance, registry);
    }

    @Override
    public void run() {
        String op = this.activityInstance.getConfiguration().getString("Operation");
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        UUID instanceID = this.getInstanceIDOrFail();
        if (OP_RESET_ACTIVITY.equals(op)) {
            this.resetActivity(session, instanceID);
        } else if (OP_SUSPEND_INSTANCE.equals(op)) {
            this.suspendInstance(session, instanceID);
        } else if (OP_RESUME_INSTANCE.equals(op)) {
            this.resumeInstance(session, instanceID);
        } else if (OP_ABORT_INSTANCE.equals(op)) {
            this.abortInstance(session, instanceID);
        } else {
            this.logger.warning(String.format("Undefined operation: %s", op));
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private void resetActivity(SessionToken session, UUID instanceID) {
        ExecutionManager executionManager = this.getExecutionManagerOrFail();
        EBPType type = EBPType.valueOf(this.getDualInputParameterValue(PARAM_EBP_TYPE, ProcessConstants.AdeptDataType.INTEGER, Long.class).byteValue());
        UUID baseTemplateID = UUID.fromString(this.getDualInputParameterValue(PARAM_TEMPLATE_ID, ProcessConstants.AdeptDataType.STRING, String.class));
        int nodeID = this.getDualInputParameterValue("NodeID", ProcessConstants.AdeptDataType.INTEGER, Long.class).intValue();
        int nodeIteration = this.getDualInputParameterValue(PARAM_NODE_ITERATION, ProcessConstants.AdeptDataType.INTEGER, Long.class).intValue();
        boolean isActivity = this.getDualInputParameterValue(PARAM_IS_ACTIVITY, ProcessConstants.AdeptDataType.BOOLEAN, Boolean.class);
        URI[] executionManagerURIs = executionManager.getURIs();
        EBPInstanceReference activity = this.getProcessModelFactoryOrFail().createEBPInstanceReference(type, instanceID, baseTemplateID, nodeID, nodeIteration, isActivity, executionManagerURIs);
        try {
            executionManager.getActivityStarting().resetActivity(session, activity, true);
        }
        catch (InvalidActivityStateException e) {
            String message = "An InvalidActivityStateException occurred while trying to reset a failed activity automatically.";
            String state = "ADEPT2:ProcessSystemComponent:InvalidActivityStateException";
            long code = 1600000L;
            throw new ApplicationFailedException(message, state, code, e);
        }
        catch (InvalidInstanceStateException e) {
            String message = "An InvalidInstanceStateException occurred while trying to reset a failed activity automatically.";
            String state = "ADEPT2:ProcessSystemComponent:InvalidInstanceStateException";
            long code = 1600000L;
            throw new ApplicationFailedException(message, state, code, e);
        }
    }

    private void suspendInstance(SessionToken session, UUID instanceID) {
        boolean propagateToRunningActs = this.getDualInputParameterValue(PARAM_PROPAGATE_TO_RUNNING_ACTS, ProcessConstants.AdeptDataType.BOOLEAN, Boolean.class);
        try {
            this.getExecutionManagerOrFail().getInstanceControl().suspendInstance(session, instanceID, propagateToRunningActs);
        }
        catch (InvalidInstanceStateException e) {
            String message = "An InvalidInstanceStateException occurred while trying to suspend an instance automatically.";
            String state = "ADEPT2:ProcessSystemComponent:InvalidInstanceStateException";
            long code = 1600000L;
            throw new ApplicationFailedException(message, state, code, e);
        }
    }

    private void resumeInstance(SessionToken session, UUID instanceID) {
        try {
            this.getExecutionManagerOrFail().getInstanceControl().resumeInstance(session, instanceID);
        }
        catch (InvalidInstanceStateException e) {
            String message = "An InvalidInstanceStateException occurred while trying to resume an instance automatically.";
            String state = "ADEPT2:ProcessSystemComponent:InvalidInstanceStateException";
            long code = 1600000L;
            throw new ApplicationFailedException(message, state, code, e);
        }
    }

    private void abortInstance(SessionToken session, UUID instanceID) {
        boolean propagateToRunningActs = this.getDualInputParameterValue(PARAM_PROPAGATE_TO_RUNNING_ACTS, ProcessConstants.AdeptDataType.BOOLEAN, Boolean.class);
        String errorMessage = "Automatic stop and abort of this instance.";
        String state = "ADEPT2:ProcessInteractionComponent:AutomaticAbortInstance";
        long errorCode = 124003L;
        try {
            this.getExecutionManagerOrFail().getInstanceControl().stopAndAbortInstance(session, instanceID, propagateToRunningActs, errorMessage, state, errorCode);
        }
        catch (InvalidInstanceStateException e) {
            String message = "An InvalidInstanceStateException occurred while trying to stop and abort an instance automatically.";
            state = "ADEPT2:ProcessSystemComponent:InvalidInstanceStateException";
            long code = 1600000L;
            throw new ApplicationFailedException(message, state, code, e);
        }
    }
}

