/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.systemtools.environments;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.executionenvironments.SystemExecutionEnvironment;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.FailingDataContext;

public class RedistributeComponent
extends SystemExecutionEnvironment {
    public static final String DISTRIBUTION_SAR = "DistributionSAR";

    public RedistributeComponent(ActivityInstance activityInstance, Registry registry) throws RuntimeException {
        super(activityInstance, registry);
        if (activityInstance.getParameter(DISTRIBUTION_SAR, ActivityConstants.AccessType.READ) == null && !activityInstance.getConfiguration().getAllEntries().contains(DISTRIBUTION_SAR)) {
            throw new RuntimeException("No distribution SAR available in the configuration!");
        }
    }

    @Override
    public void run() {
        String distributionSAR = this.activityInstance.getParameter(DISTRIBUTION_SAR, ActivityConstants.AccessType.READ) != null ? new FailingDataContext(this.sessionContext.getDataContext()).retrieveStringParameterValue(DISTRIBUTION_SAR) : this.activityInstance.getConfiguration().getString(DISTRIBUTION_SAR);
        SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
        this.getWorklistManagerOrFail().getAdministration().redistributeItems(session, distributionSAR);
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    private WorklistManager getWorklistManagerOrFail() {
        WorklistManager worklistManager;
        try {
            SessionToken session = this.sessionContext.getClientSessionFactory().getSessionToken();
            worklistManager = this.registry.getServiceOfType(session, "WorklistManager", WorklistManager.class);
        }
        catch (ServiceNotKnownException e) {
            String message = "Worklist manager not reachable.";
            String state = "No worklist manager";
            throw new ApplicationFailedException(message, state, 1600000L, e);
        }
        return worklistManager;
    }
}

