/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;

public abstract class AbstractFileTransferComponentCheck
extends AbstractExecutableComponentCheck {
    protected AbstractFileTransferComponentCheck(AllExecutableComponentChecks checkProvider, String activityTypeID, String checkID) {
        super(activityTypeID, checkID);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        long remotePort;
        String msg;
        long attempts;
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.checkConfValueAvailable(conf, "Attempts", ProcessConstants.AdeptDataType.INTEGER) && (attempts = conf.getInteger("Attempts").longValue()) < 1L) {
            msg = "The number of attempts must be positive!";
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        if (this.checkConfEntrySet(conf, "RemotePort") && this.checkConfValueAvailable(conf, "RemotePort", ProcessConstants.AdeptDataType.INTEGER) && ((remotePort = conf.getInteger("RemotePort").longValue()) < 1L || remotePort > 65535L)) {
            msg = "The port must be a number between 1 and 65535!";
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        this.checkConfEntrySet(conf, "RemoteHost");
        this.checkConfEntrySet(conf, "RemotePort");
        this.checkConfEntrySet(conf, "UserName");
        this.checkConfEntrySet(conf, "Password");
        this.checkConfEntrySet(conf, "LocalFile");
        this.checkConfEntrySet(conf, "RemoteFile");
    }
}

