/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractStringFormatComponentCheck
extends AbstractExecutableComponentCheck {
    protected Boolean argumentsCorrect;

    protected AbstractStringFormatComponentCheck(AllExecutableComponentChecks checkProvider, String activityTypeID, String checkID) {
        super(activityTypeID, checkID);
    }

    protected void performCheck(AbstractActivity activity, AbstractStringFormatComponent.FormatStyle formatStyle) {
        HashSet<Long> indices = new HashSet<Long>();
        int argumentCount = 0;
        Set<? extends Parameter> inParams = activity.getParameters(ActivityConstants.AccessType.READ);
        for (Parameter parameter : inParams) {
            ActivityConfiguration conf = parameter.getConfiguration();
            boolean argIndexSet = this.isConfEntrySet(conf, "ArgumentIndex");
            if (!argIndexSet) continue;
            ++argumentCount;
            if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                String msg = "The input parameter '%s' was assigned as a format argument but has the data type %s which is not supported for string formatting!";
                msg = String.format(msg, new Object[]{parameter.getName(), ProcessConstants.AdeptDataType.USERDEFINED});
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                this.argumentsCorrect = Boolean.FALSE;
            }
            if (this.checkConfValueAvailable(conf, "ArgumentIndex", ProcessConstants.AdeptDataType.INTEGER, ActivityConstants.AccessType.READ, parameter.getName())) {
                Long argIndex = conf.getInteger("ArgumentIndex");
                if (indices.contains(argIndex)) {
                    String msg = "There are at least two input parameters with the same argument index (ArgumentIndex) %d!";
                    msg = String.format(msg, argIndex);
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                    this.argumentsCorrect = Boolean.FALSE;
                    continue;
                }
                indices.add(argIndex);
                continue;
            }
            this.argumentsCorrect = Boolean.FALSE;
        }
        if (formatStyle != null && argumentCount > formatStyle.maxArgumentCount()) {
            String string2 = "The selected format style '%s' only supports up to %d format arguments!";
            string2 = String.format(string2, formatStyle.token(), formatStyle.maxArgumentCount());
            this.addReportEntry(CheckReport.ResultType.FAILURE, string2);
        }
        if (this.argumentsCorrect == null) {
            this.argumentsCorrect = Boolean.TRUE;
        }
    }

    public static Object[] getTestFormatArguments(Collection<? extends Parameter> inParams) {
        Parameter[] formatArgumentParameters = AbstractStringFormatComponent.getFormatArgumentParameters(inParams);
        Object[] testArguments = new Object[formatArgumentParameters.length];
        int i = 0;
        while (i < testArguments.length) {
            switch (formatArgumentParameters[i].getDataType()) {
                case BOOLEAN: {
                    testArguments[i] = Boolean.FALSE;
                    break;
                }
                case INTEGER: {
                    testArguments[i] = 5L;
                    break;
                }
                case FLOAT: {
                    testArguments[i] = 5.6544;
                    break;
                }
                case STRING: {
                    testArguments[i] = "sdfhsgksg";
                    break;
                }
                case URI: {
                    testArguments[i] = URI.create("http://www.google.de/");
                    break;
                }
                case DATE: {
                    testArguments[i] = new Date();
                    break;
                }
                case USERDEFINED: {
                    testArguments[i] = null;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        return testArguments;
    }
}

