/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.CheckReport;
import org.apache.commons.configuration.Configuration;

public class DefaultValueProvidingEnvironmentCheck
extends AbstractExecutableComponentCheck {
    public static final String ID = "de.aristaflow.tools.ValueProvidingEnvironment#Check";

    public DefaultValueProvidingEnvironmentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.tools.ValueProvidingEnvironment", ID);
    }

    public DefaultValueProvidingEnvironmentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        if (!activity.getGUIContextID().equals("NullContext")) {
            String string = String.format("The DefaultValueProvidingEnvironment only supports the %s context, but the context %s is used.", "NullContext", activity.getGUIContextID());
            this.logger.severe(string);
            this.addReportEntry(CheckReport.ResultType.FAILURE, string);
        }
        for (Parameter parameter : activity.getParameters(ActivityConstants.AccessType.WRITE)) {
            String defaultValue = parameter.getConfiguration().getString("DefaultParameterValue");
            if (defaultValue != null && !defaultValue.equals("")) continue;
            String message = String.format("The output parameter '%s' does not have a default value assigned!", parameter.getName());
            this.logger.severe(message);
            this.addReportEntry(CheckReport.ResultType.FAILURE, message);
        }
    }
}

