/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.util.CheckReport;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class FileIOComponentCheck
extends AbstractExecutableComponentCheck {
    public static final String ID = "de.aristaflow.tools.FileIO#Check";

    public FileIOComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.tools.FileIO", ID);
    }

    public FileIOComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        String msg;
        Set<? extends Parameter> inParams = activity.getParameters(ActivityConstants.AccessType.READ);
        Set<? extends Parameter> outParams = activity.getParameters(ActivityConstants.AccessType.WRITE);
        HashSet<Parameter> unusedInputParams = new HashSet<Parameter>(inParams);
        if (activity.getOperationName().equals("readFromFile")) {
            for (Parameter parameter : outParams) {
                this.checkFileURI(activity, parameter, ActivityConstants.AccessType.WRITE, unusedInputParams);
                if (parameter.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                    this.checkCharset(parameter, ActivityConstants.AccessType.WRITE);
                    continue;
                }
                if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) continue;
                msg = "Can't read files into output parameter '%s' because it has data type %s (only URI and USERDEFINED are supported)!";
                msg = String.format(msg, new Object[]{parameter.getName(), parameter.getDataType()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else if (activity.getOperationName().equals("writeToFile")) {
            for (Parameter parameter : inParams) {
                if (parameter.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                    this.checkFileURI(activity, parameter, ActivityConstants.AccessType.READ, unusedInputParams);
                    this.checkCharset(parameter, ActivityConstants.AccessType.READ);
                    unusedInputParams.remove(parameter);
                    continue;
                }
                if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    this.checkFileURI(activity, parameter, ActivityConstants.AccessType.READ, unusedInputParams);
                    unusedInputParams.remove(parameter);
                    continue;
                }
                if (parameter.getDataType() == ProcessConstants.AdeptDataType.URI) continue;
                msg = "Can't write output parameter '%s' to file because it has data type %s (only URI and USERDEFINED are supported)!";
                msg = String.format(msg, new Object[]{parameter.getName(), parameter.getDataType()});
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        } else {
            String string2 = "An operation '%s' is not supported by the activity type '%s'!";
            string2 = String.format(string2, activity.getOperationName(), this.getExecutableComponentName());
            this.addReportEntry(CheckReport.ResultType.FAILURE, string2);
        }
        for (Parameter parameter : unusedInputParams) {
            msg = "The input parameter '%s' is never used!";
            msg = String.format(msg, parameter.getName());
            this.addReportEntry(CheckReport.ResultType.WARNING, msg);
        }
    }

    private void checkFileURI(AbstractActivity activity, Parameter param, ActivityConstants.AccessType accessType, Set<Parameter> unusedInputParams) {
        ActivityConfiguration conf = param.getConfiguration();
        if (this.isConfEntrySet(conf, "FileURI")) {
            if (this.checkConfValueAvailable(conf, "FileURI", accessType, param.getName())) {
                String msg;
                String temp;
                try {
                    URI fileURI = new URI(conf.getString("FileURI"));
                    new File(fileURI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                    msg = "The specified URI for %s parameter '%s' doesn't seem to be a valid URI!";
                    msg = String.format(msg, temp, param.getName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                    msg = "The specified URI for %s parameter '%s' doesn't seem to be a valid file URI!";
                    msg = String.format(msg, temp, param.getName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
                if (this.isConfEntrySet(conf, "FileURIParameter")) {
                    temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                    msg = "Only one of %s and %s may be specified for %s parameter '%s'!";
                    msg = String.format(msg, "FileURI", "FileURIParameter", temp, param.getName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                }
            }
        } else if (!this.isConfEntrySet(conf, "FileURIParameter")) {
            String temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
            String msg = "Either %s or %s must be specified for the %s parameter '%s'!";
            msg = String.format(msg, "FileURI", "FileURIParameter", temp, param.getName());
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        } else if (this.checkConfValueAvailable(conf, "FileURIParameter", accessType, param.getName())) {
            String fileURIParamName = conf.getString("FileURIParameter");
            Parameter fileURIParam = activity.getParameter(fileURIParamName, ActivityConstants.AccessType.READ);
            if (fileURIParam == null) {
                String temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                String msg = "The input parameter '%s' - referenced by %s parameter '%s' to supply a file URI - does not exist!";
                msg = String.format(msg, fileURIParamName, temp, param.getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            } else if (fileURIParam.getDataType() != ProcessConstants.AdeptDataType.URI) {
                String temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                String msg = "The input parameter '%s' - referenced by %s parameter '%s' to supply a file URI - does not have the required data type URI!";
                msg = String.format(msg, fileURIParamName, temp, param.getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                unusedInputParams.remove(fileURIParam);
            } else {
                unusedInputParams.remove(fileURIParam);
            }
        }
    }

    private void checkCharset(Parameter param, ActivityConstants.AccessType accessType) throws ApplicationEnvironmentException {
        ActivityConfiguration conf = param.getConfiguration();
        if (this.checkConfValueAvailable(conf, "Encoding")) {
            String encoding = conf.getString("Encoding");
            try {
                Charset.forName(encoding);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                String msg = "The STRING %s parameter '%s' has an unsupported/unknown encoding assigned to it!";
                msg = String.format(msg, temp, param.getName());
                this.addReportEntry(CheckReport.ResultType.WARNING, msg);
            }
        }
    }
}

