/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class HTTPComponentCheck
extends AbstractExecutableComponentCheck {
    public static final String ID = "de.aristaflow.tools.net.HTTP#Check";

    public HTTPComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.tools.net.HTTP", ID);
    }

    public HTTPComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        Parameter parameter;
        String opName;
        Object msg;
        long attempts;
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.checkDualStringInputParameter(activity, "URL") && conf.getString("URL") != null) {
            try {
                String urlString = activity.getConfiguration().getString("URL");
                new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {
                String msg2 = "The specified URL isn't a valid URL!";
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg2);
            }
        }
        if (this.checkConfValueAvailable(conf, "Attempts", ProcessConstants.AdeptDataType.INTEGER) && (attempts = conf.getInteger("Attempts").longValue()) < 1L) {
            msg = "The number of attempts must be positive!";
            this.addReportEntry(CheckReport.ResultType.FAILURE, (String)msg);
        }
        if (!(opName = activity.getOperationName()).equals("Get") && !opName.equals("Post")) {
            String string = "Unknown operation encountered: " + activity.getOperationName();
            this.addReportEntry(CheckReport.ResultType.FAILURE, string);
        }
        for (Parameter parameter2 : activity.getParameters(ActivityConstants.AccessType.READ)) {
            if (parameter2.getDataType() == ProcessConstants.AdeptDataType.STRING) continue;
            String msg4 = "The input parameter '%s' must have the data type %s!";
            msg4 = String.format(msg4, new Object[]{parameter2.getName(), ProcessConstants.AdeptDataType.STRING});
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg4);
        }
        if (this.checkParameterPresent(activity, "response", ActivityConstants.AccessType.WRITE) && (parameter = activity.getParameter("response", ActivityConstants.AccessType.WRITE)).getDataType() != ProcessConstants.AdeptDataType.STRING && parameter.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) {
            msg = "The output parameter '%s' must either have the data type %s or %s!";
            msg = String.format((String)msg, new Object[]{"response", ProcessConstants.AdeptDataType.USERDEFINED, ProcessConstants.AdeptDataType.STRING});
            this.addReportEntry(CheckReport.ResultType.FAILURE, (String)msg);
        }
    }
}

