/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.extensions.tools.checks.AbstractStringFormatComponentCheck;
import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LocaleTools;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class StringFormatComponentCheck
extends AbstractStringFormatComponentCheck {
    public static final String ID = "de.aristaflow.tools.StringFormat#Check";

    public StringFormatComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super(checkProvider, "de.aristaflow.tools.StringFormat", ID);
    }

    public StringFormatComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        String formatStyleString;
        String localeString;
        Locale locale;
        ActivityConfiguration conf = activity.getConfiguration();
        if (this.checkConfValueAvailable(conf, "FormatLocale") && (locale = LocaleTools.parseLocaleString(localeString = conf.getString("FormatLocale"))) == null) {
            String string2 = "The specified locale '%s' doesn't appear to be valid! A default locale will be used instead.";
            string2 = String.format(string2, localeString);
            this.addReportEntry(CheckReport.ResultType.WARNING, string2);
        }
        AbstractStringFormatComponent.FormatStyle formatStyle = null;
        if (this.checkConfEntrySet(conf, "FormatStyle") && this.checkConfValueAvailable(conf, "FormatStyle") && (formatStyle = AbstractStringFormatComponent.FormatStyle.fromToken(formatStyleString = conf.getString("FormatStyle"))) == null) {
            String string3 = "The specified format style '%s' is not recognised!";
            string3 = String.format(string3, formatStyleString);
            this.addReportEntry(CheckReport.ResultType.FAILURE, string3);
        }
        this.performCheck(activity, formatStyle);
        Set<? extends Parameter> outParams = activity.getParameters(ActivityConstants.AccessType.WRITE);
        for (Parameter parameter : outParams) {
            Parameter inParam;
            if (!this.checkParameter(parameter, ActivityConstants.AccessType.WRITE, ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.USERDEFINED) || (inParam = activity.getParameter(parameter.getName(), ActivityConstants.AccessType.READ)) != null && this.checkParameter(activity, inParam.getName(), ActivityConstants.AccessType.READ, true, false, ProcessConstants.AdeptDataType.STRING)) continue;
            String atpcFormatString = parameter.getConfiguration().getString("FormatString");
            if (atpcFormatString != null) {
                if (formatStyle == null) continue;
                Object[] testFormatArguments = StringFormatComponentCheck.getTestFormatArguments(activity.getParameters(ActivityConstants.AccessType.READ));
                try {
                    AbstractStringFormatComponent.format(formatStyle, atpcFormatString, Locale.getDefault(), testFormatArguments);
                }
                catch (AbstractStringFormatComponent.FormatException formatException) {
                    String msg2 = "The format string of output parameter '%s' provided in its activity configuration can't be successfully formatted! Check the format string and the format arguments.";
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg2);
                }
                continue;
            }
            String msg3 = "No format string has been specified for the output parameter '%s', neither through an input parameter with the same name nor in the output parameter'sactivity configuration!";
            msg3 = String.format(msg3, parameter.getName());
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg3);
        }
    }
}

