/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import org.apache.commons.configuration.Configuration;

public class WaitComponentCheck
extends AbstractExecutableComponentCheck {
    public static final String ID = "de.aristaflow.tools.Wait#Check";

    public WaitComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.tools.Wait", ID);
    }

    public WaitComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    public void performCheckSpi(AbstractActivity activity) {
        if (activity.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            this.addReportEntry(CheckReport.ResultType.FAILURE, "Output parameters are not supported!");
        }
        ActivityConfiguration conf = activity.getConfiguration();
        if (!this.checkParameter(activity, "EndTime", ActivityConstants.AccessType.READ, true, false, ProcessConstants.AdeptDataType.DATE)) {
            if (this.checkDualIntegerInputParameter(activity, "Duration")) {
                long duration;
                if (conf.getInteger("Duration") != null && (duration = conf.getInteger("Duration").longValue()) < 0L) {
                    this.addReportEntry(CheckReport.ResultType.FAILURE, "The wait duration must not be negative!");
                }
            } else if (!this.checkConfEntrySet(conf, "Duration")) {
                this.addReportEntry(CheckReport.ResultType.FAILURE, "Neither a duration nor and end time for the wait have been specified!");
            }
        }
    }
}

