/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class XSLTComponentCheck
extends AbstractExecutableComponentCheck {
    public static final String ID = "de.aristaflow.xml.XSLT#Checks";

    public XSLTComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.xml.XSLT", ID);
    }

    public XSLTComponentCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    protected void performCheckSpi(AbstractActivity activity) {
        Parameter outputParam;
        String msg;
        Parameter xmlParam;
        ActivityConfiguration conf = activity.getConfiguration();
        this.checkOneOfATCFieldsPresent(activity, "Stylesheet", "StylesheetURI");
        String styleSheetUri = conf.getString("StylesheetURI");
        if (styleSheetUri != null) {
            try {
                new URL(styleSheetUri);
            }
            catch (MalformedURLException malformedURLException) {
                String msg2 = "The provided URL for the XSL stylesheet doesn't appear to be a valid URL!";
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg2);
            }
        }
        if (this.checkParameterPresent(activity, "inputXML", ActivityConstants.AccessType.READ) && (xmlParam = activity.getParameter("inputXML", ActivityConstants.AccessType.READ)).getDataType() != ProcessConstants.AdeptDataType.STRING && xmlParam.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) {
            msg = "The input parameter '%s' must either have the data type %s or %s!";
            msg = String.format(msg, new Object[]{xmlParam.getName(), ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.USERDEFINED});
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        if (this.checkParameterPresent(activity, "outputXML", ActivityConstants.AccessType.WRITE) && (outputParam = activity.getParameter("outputXML", ActivityConstants.AccessType.WRITE)).getDataType() != ProcessConstants.AdeptDataType.STRING && outputParam.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) {
            msg = "The output parameter '%s' must either have the data type %s or %s!";
            msg = String.format(msg, new Object[]{outputParam.getName(), ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.USERDEFINED});
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
    }
}

