/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.util.FileTools;
import de.aristaflow.adept2.util.StreamTools;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public abstract class AbstractFileTransferComponent
extends ExecutionEnvironment {
    public static final String CONF_ATTEMPTS = "Attempts";
    public static final String CONF_USERNAME = "UserName";
    public static final String CONF_PASSWORD = "Password";
    public static final String CONF_REMOTE_HOST = "RemoteHost";
    public static final String CONF_REMOTE_PORT = "RemotePort";
    public static final String CONF_LOCAL_FILE = "LocalFile";
    public static final String CONF_REMOTE_FILE = "RemoteFile";
    public static final String PCONF_REMOTE_FILE = "RemoteFile";
    public static final String OP_UPLOAD = "Upload";
    public static final String OP_DOWNLOAD = "Download";

    public AbstractFileTransferComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        String remoteHost = conf.getString(CONF_REMOTE_HOST);
        int remotePort = conf.getInteger(CONF_REMOTE_PORT).intValue();
        String userName = conf.getString(CONF_USERNAME);
        String password = conf.getString(CONF_PASSWORD);
        long attempts = conf.getInteger(CONF_ATTEMPTS) == null ? 1L : conf.getInteger(CONF_ATTEMPTS);
        while (attempts > 0L) {
            this.connect(remoteHost, remotePort, userName, password);
            String opName = this.activityInstance.getOperationName();
            if (opName.equals(OP_DOWNLOAD)) {
                this.op_download();
            } else if (opName.equals(OP_UPLOAD)) {
                this.op_upload();
            } else {
                String msg = "Unknown operation encountered: " + opName;
                throw new ApplicationEnvironmentException(msg, 0L);
            }
            this.disconnect();
            try {
                this.disconnect();
            }
            catch (Exception exception) {}
            break;
            catch (Exception ex) {
                block15: {
                    try {
                        ex.printStackTrace();
                        if (--attempts >= 0L) break block15;
                        String msg = "An error occured while transfering the file!";
                        throw new ApplicationFailedException(msg, null, 0L, ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.disconnect();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                }
                try {
                    this.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    private void op_download() throws Exception {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    private void op_upload() throws Exception {
        this.upload();
        for (ProcessModelParameter inputParam : this.activityInstance.getParameters(ActivityConstants.AccessType.READ)) {
            this.upload(inputParam);
        }
    }

    private void upload() {
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        String localFile = conf.getString(CONF_LOCAL_FILE);
        String remoteFile = conf.getString("RemoteFile");
        if (remoteFile != null && localFile != null) {
            OutputStream remoteOutput;
            try {
                remoteOutput = this.openRemoteTarget(remoteFile);
            }
            catch (Exception ex) {
                String msg = "Could not connect to the remote host!";
                throw new ApplicationFailedException(msg, null, 0L, ex);
            }
            try {
                try {
                    FileInputStream localFileInput = new FileInputStream(localFile);
                    StreamTools.copyStreamToStream(localFileInput, remoteOutput);
                    remoteOutput.flush();
                    remoteOutput = FileTools.close(remoteOutput);
                }
                catch (IOException ex) {
                    String msg = "An error occured while uploading the file!";
                    throw new ApplicationFailedException(msg, null, 0L, ex);
                }
            }
            finally {
                FileTools.closeQuietly(remoteOutput);
            }
        }
    }

    private void upload(ProcessModelParameter inputParam) {
        OutputStream remoteOutput;
        String remoteFile = inputParam.getConfiguration().getString("RemoteFile");
        try {
            remoteOutput = this.openRemoteTarget(remoteFile);
        }
        catch (Exception ex) {
            String msg = "Could not connect to the remote host!";
            throw new ApplicationFailedException(msg, null, 0L, ex);
        }
        try {
            try {
                block21: {
                    DataContext dataContext = this.sessionContext.getDataContext();
                    if (inputParam.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                        UDTValue value = dataContext.retrieveUDTParameterValue(inputParam.getName());
                        remoteOutput.write(value.getValueAsArray());
                    } else {
                        if (inputParam.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                            String value = dataContext.retrieveStringParameterValue(inputParam.getName());
                            String encoding = "UTF-8";
                            OutputStreamWriter writer = null;
                            try {
                                try {
                                    writer = new OutputStreamWriter(remoteOutput, encoding);
                                    writer.write(value);
                                    writer.close();
                                    break block21;
                                }
                                catch (UnsupportedEncodingException ex) {
                                    String msg = "Encoding not supported: %s!";
                                    msg = String.format(msg, encoding);
                                    throw new ApplicationEnvironmentException(msg, 0L, ex);
                                }
                            }
                            finally {
                                if (writer != null) {
                                    writer.close();
                                }
                            }
                        }
                        if (inputParam.getDataType() == ProcessConstants.AdeptDataType.URI) {
                            URI value = dataContext.retrieveURIParameterValue(inputParam.getName());
                            try {
                                URL url = value.toURL();
                                StreamTools.copyStreamToStream(url.openStream(), remoteOutput);
                            }
                            catch (MalformedURLException ex) {
                                String msg = "The provided URL isn't valid or the protocol not supported!";
                                throw new ApplicationEnvironmentException(msg, 0L, ex);
                            }
                        }
                    }
                }
                remoteOutput.flush();
                remoteOutput = FileTools.close(remoteOutput);
            }
            catch (InvalidDataTypeException ex) {
                String msg = "Input parameter '%s' does not have expected data type: %s!";
                msg = String.format(msg, new Object[]{inputParam.getName(), ProcessConstants.AdeptDataType.STRING});
                throw new ApplicationEnvironmentException(msg, -401000L, ex);
            }
            catch (NoSuchParameterException ex) {
                String msg = "Could not read string from input parameter '%s'! No such parameter!";
                msg = String.format(msg, inputParam.getName());
                throw new ApplicationEnvironmentException(msg, -401000L, ex);
            }
            catch (IOException ex) {
                String msg = "An error occured while uploading the file!";
                throw new ApplicationFailedException(msg, null, 0L, ex);
            }
        }
        finally {
            FileTools.closeQuietly(remoteOutput);
        }
    }

    protected abstract void connect(String var1, int var2, String var3, String var4) throws Exception;

    protected abstract void disconnect() throws Exception;

    protected abstract OutputStream openRemoteTarget(String var1) throws Exception;
}

