/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.ArgChecks;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Formatter;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractStringFormatComponent
extends ExecutionEnvironment {
    public static final String CONF_FORMAT_LOCALE = "FormatLocale";
    public static final String CONF_FORMAT_STYLE = "FormatStyle";
    public static final String PCONF_IN_ARGUMENT_INDEX = "ArgumentIndex";

    public AbstractStringFormatComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    protected Object[] getFormatArguments() {
        Set<ProcessModelParameter> inParams = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        Parameter[] formatArgumentParameters = AbstractStringFormatComponent.getFormatArgumentParameters(inParams);
        Object[] formatArguments = new Object[formatArgumentParameters.length];
        int i = 0;
        while (i < formatArguments.length) {
            Parameter argParam = formatArgumentParameters[i];
            formatArguments[i] = this.getInputParameterValue(argParam.getName());
            ++i;
        }
        return formatArguments;
    }

    public static String format(FormatStyle formatStyle, String parameterisedString, Locale locale, Object ... formatArguments) throws FormatException {
        ArgChecks.checkForNull((Object)formatStyle, "formatStyle");
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        ArgChecks.checkForNull(formatArguments, "formatArguments");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            switch (formatStyle) {
                case PRINTF_FORMATTER: {
                    Formatter formatter = new Formatter(locale);
                    return formatter.format(locale, parameterisedString, formatArguments).toString();
                }
                case MESSAGE_FORMAT: {
                    MessageFormat messageFormat = new MessageFormat(parameterisedString, locale);
                    return messageFormat.format(formatArguments);
                }
            }
            throw new AssertionError((Object)("unimplemented FormatSyle: " + (Object)((Object)formatStyle)));
        }
        catch (Exception ex) {
            throw new FormatException(ex);
        }
    }

    public static Parameter[] getFormatArgumentParameters(Collection<? extends Parameter> inParams) {
        TreeMap<Long, Parameter> formatArguments = new TreeMap<Long, Parameter>();
        for (Parameter parameter : inParams) {
            Long argIndex;
            if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED || (argIndex = parameter.getConfiguration().getInteger(PCONF_IN_ARGUMENT_INDEX)) == null) continue;
            formatArguments.put(argIndex, parameter);
        }
        return formatArguments.values().toArray(new Parameter[formatArguments.size()]);
    }

    public static class FormatException
    extends Exception {
        private static final long serialVersionUID = 1695108604214367653L;

        FormatException(Throwable cause) {
            super(cause);
        }
    }

    public static enum FormatStyle {
        PRINTF_FORMATTER("java.util.Formatter", 1, Integer.MAX_VALUE),
        MESSAGE_FORMAT("java.text.MessageFormat", 0, 10);

        private final String token;
        private final int firstIndex;
        private final int maxArgumentCount;

        private FormatStyle(String token, int firstIndex, int maxArgumentCount) {
            ArgChecks.checkForNegative(firstIndex, "firstIndex");
            ArgChecks.checkForNegative(maxArgumentCount, "maxArgumentCount");
            this.token = token;
            this.firstIndex = firstIndex;
            this.maxArgumentCount = maxArgumentCount;
        }

        public String token() {
            return this.token;
        }

        public int firstIndex() {
            return this.firstIndex;
        }

        public int maxArgumentCount() {
            return this.maxArgumentCount;
        }

        public static FormatStyle fromToken(String token) {
            ArgChecks.checkForNull(token, "token");
            FormatStyle[] formatStyleArray = FormatStyle.values();
            int n = formatStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                FormatStyle formatStyle = formatStyleArray[n2];
                if (token.equals(formatStyle.token)) {
                    return formatStyle;
                }
                ++n2;
            }
            return null;
        }

        public String toString() {
            return this.token();
        }
    }
}

