/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import java.net.URI;
import java.util.Date;

public class DefaultValueProvidingEnvironment
extends ExecutionEnvironment {
    public static final String EC_NAME = "de.aristaflow.tools.ValueProvidingEnvironment";
    public static final long MANDATORY_CONFIGURATION_VALUE_MISSING_EC = 192L;
    public static final String MANDATORY_CONFIGURATION_VALUE_MISSING = "ADEPT2:DefaultValueProvidingEnvironment:ConfigurationMandatoryValueMissing";
    public static final long WRONG_CONFIGURATION_VALUE_TYPE_EC = 96L;
    public static final String WRONG_CONFIGURATION_VALUE_TYPE_BOOLEAN = "ADEPT2:DefaultValueProvidingEnvironment:WrongConfigurationValueTypeBoolean";
    public static final String WRONG_CONFIGURATION_VALUE_TYPE_LONG = "ADEPT2:DefaultValueProvidingEnvironment:WrongConfigurationValueTypeLong";
    public static final String WRONG_CONFIGURATION_VALUE_TYPE_DOUBLE = "ADEPT2:DefaultValueProvidingEnvironment:WrongConfigurationValueTypeDouble";
    public static final String WRONG_CONFIGURATION_VALUE_TYPE_URI = "ADEPT2:DefaultValueProvidingEnvironment:WrongConfigurationValueTypeURI";
    public static final String WRONG_CONFIGURATION_VALUE_TYPE_DATE = "ADEPT2:DefaultValueProvidingEnvironment:WrongConfigurationValueTypeDate";
    public static final String WRONG_CONFIGURATION_VALUE_TYPE_UDT = "ADEPT2:DefaultValueProvidingEnvironment:WrongConfigurationValueTypeUDTEncoding";
    public static final long NO_SUCH_PARAMETER_EC = 999999999L;
    public static final String NO_SUCH_PARAMETER = "ADEPT2:DefaultValueProvidingEnvironment:NoSuchParameter";
    public static final long INVALID_DATA_TYPE_EC = 888888888L;
    public static final String INVALID_DATA_TYPE = "ADEPT2:DefaultValueProvidingEnvironment:InvalidDataType";
    public static final String DEFAULT_PARAMETER_VALUE = "DefaultParameterValue";

    public DefaultValueProvidingEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        DataContext dataContext = this.sessionContext.getDataContext();
        for (ProcessModelParameter parameter : this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE)) {
            block22: {
                String parameterName = parameter.getName();
                ActivityConfiguration configuration = parameter.getConfiguration();
                if (configuration.getAllEntries().contains(DEFAULT_PARAMETER_VALUE)) {
                    try {
                        switch (parameter.getDataType()) {
                            case BOOLEAN: {
                                Object value = configuration.getBoolean(DEFAULT_PARAMETER_VALUE);
                                if (value != null) {
                                    dataContext.storeBooleanParameterValue(parameterName, (Boolean)value);
                                    break block22;
                                }
                                throw new ApplicationEnvironmentException(WRONG_CONFIGURATION_VALUE_TYPE_BOOLEAN, 96L);
                            }
                            case INTEGER: {
                                Object value = configuration.getInteger(DEFAULT_PARAMETER_VALUE);
                                if (value != null) {
                                    dataContext.storeIntegerParameterValue(parameterName, (Long)value);
                                    break block22;
                                }
                                throw new ApplicationEnvironmentException(WRONG_CONFIGURATION_VALUE_TYPE_LONG, 96L);
                            }
                            case FLOAT: {
                                Object value = configuration.getFloat(DEFAULT_PARAMETER_VALUE);
                                if (value != null) {
                                    dataContext.storeFloatParameterValue(parameterName, (Double)value);
                                    break block22;
                                }
                                throw new ApplicationEnvironmentException(WRONG_CONFIGURATION_VALUE_TYPE_DOUBLE, 96L);
                            }
                            case STRING: {
                                dataContext.storeStringParameterValue(parameterName, configuration.getString(DEFAULT_PARAMETER_VALUE));
                                break block22;
                            }
                            case DATE: {
                                Object value = configuration.getDate(DEFAULT_PARAMETER_VALUE);
                                if (value != null) {
                                    dataContext.storeDateParameterValue(parameterName, (Date)value);
                                    break block22;
                                }
                                throw new ApplicationEnvironmentException(WRONG_CONFIGURATION_VALUE_TYPE_DATE, 96L);
                            }
                            case URI: {
                                Object value = configuration.getURI(DEFAULT_PARAMETER_VALUE);
                                if (value != null) {
                                    dataContext.storeURIParameterValue(parameterName, (URI)value);
                                    break block22;
                                }
                                throw new ApplicationEnvironmentException(WRONG_CONFIGURATION_VALUE_TYPE_URI, 96L);
                            }
                            case USERDEFINED: {
                                Object value = configuration.getUDT(DEFAULT_PARAMETER_VALUE);
                                if (value != null) {
                                    ADEPT2UDTValue udtValue = new ADEPT2UDTValue("UNKNOWN", (byte[])value);
                                    dataContext.storeUDTParameterValue(parameterName, udtValue);
                                    break block22;
                                }
                                throw new ApplicationEnvironmentException(WRONG_CONFIGURATION_VALUE_TYPE_UDT, 96L);
                            }
                            default: {
                                assert (false) : parameterName;
                                break block22;
                            }
                        }
                    }
                    catch (NoSuchParameterException nspe) {
                        throw new ApplicationEnvironmentException(NO_SUCH_PARAMETER, 999999999L, nspe);
                    }
                    catch (InvalidDataTypeException idte) {
                        throw new ApplicationEnvironmentException(INVALID_DATA_TYPE, 888888888L, idte);
                    }
                }
                if (!parameter.isOptional()) {
                    throw new ApplicationEnvironmentException(MANDATORY_CONFIGURATION_VALUE_MISSING, 192L);
                }
            }
            if (!Thread.interrupted()) continue;
            this.sessionContext.getRuntimeEnvironment().dispatch();
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return true;
    }
}

