/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.util.FileTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Set;

public class FileIOComponent
extends ExecutionEnvironment {
    public static final String EC_NAME = "de.aristaflow.tools.FileIO";
    public static final String PCONF_INOUT_ENCODING = "Encoding";
    public static final String PCONF_INOUT_FILEURI = "FileURI";
    public static final String PCONF_INOUT_FILEURI_PARAMETER = "FileURIParameter";
    public static final String PCONF_IN_APPEND = "Append";
    public static final String OP_READ_FROM_FILE = "readFromFile";
    public static final String OP_WRITE_TO_FILE = "writeToFile";

    public FileIOComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        if (this.activityInstance.getOperationName().equals(OP_READ_FROM_FILE)) {
            this.op_readFromFile();
        } else if (this.activityInstance.getOperationName().equals(OP_WRITE_TO_FILE)) {
            this.op_writeToFile();
        } else {
            String msg = "Unknown operation encountered: " + this.activityInstance.getOperationName();
            throw new ApplicationEnvironmentException(msg, 0L);
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    private void op_readFromFile() {
        Set<ProcessModelParameter> outParams = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        for (ProcessModelParameter outParam : outParams) {
            String msg;
            FileInputStream fis;
            URI fileURI = this.getFileURI(outParam, ActivityConstants.AccessType.WRITE);
            File inputFile = new File(fileURI);
            if (outParam.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                fis = null;
                try {
                    try {
                        int charsRead;
                        fis = new FileInputStream(inputFile);
                        InputStreamReader isr = new InputStreamReader((InputStream)fis, this.getCharset(outParam));
                        StringBuilder sb = new StringBuilder((int)inputFile.length());
                        char[] buffer = new char[16384];
                        while ((charsRead = isr.read(buffer)) > -1) {
                            sb.append(buffer, 0, charsRead);
                        }
                        isr = FileTools.close(isr);
                        try {
                            this.sessionContext.getDataContext().storeStringParameterValue(outParam.getName(), sb.toString());
                        }
                        catch (InvalidDataTypeException ex) {
                            String msg2 = "Could not store string to output parameter '%s'!Invalid data type '%s', expected '%s'!";
                            msg2 = String.format(msg2, new Object[]{outParam.getName(), ex.getActualDataType(), ex.getExpectedDataType()});
                            throw new ApplicationEnvironmentException(msg2, 1100004L, ex);
                        }
                        catch (NoSuchParameterException ex) {
                            String msg3 = "Could not store string to output parameter '%s'!No such parameter!";
                            msg3 = String.format(msg3, outParam.getName());
                            throw new ApplicationEnvironmentException(msg3, -401000L, ex);
                        }
                    }
                    catch (IOException ex) {
                        msg = "The was an error reading the file '%s'!";
                        msg = String.format(msg, fileURI);
                        throw new ApplicationFailedException(msg, null, 0L, ex);
                    }
                }
                catch (Throwable throwable) {
                    FileTools.closeQuietly(fis);
                    throw throwable;
                }
                FileTools.closeQuietly(fis);
                continue;
            }
            if (outParam.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) continue;
            fis = null;
            try {
                try {
                    fis = new FileInputStream(inputFile);
                    int bytesTotal = (int)inputFile.length();
                    byte[] buffer = new byte[bytesTotal];
                    int bytesReadTotal = 0;
                    while (bytesReadTotal < bytesTotal) {
                        int bytesRead = fis.read(buffer, bytesReadTotal, bytesTotal - bytesReadTotal);
                        bytesReadTotal += bytesRead;
                    }
                    fis = FileTools.close(fis);
                    ADEPT2UDTValue udtValue = new ADEPT2UDTValue(outParam.getUDTName(), buffer);
                    try {
                        this.sessionContext.getDataContext().storeUDTParameterValue(outParam.getName(), udtValue);
                    }
                    catch (Exception exception) {
                        String msg4 = "Could not store UDT to output parameter '%s'!";
                        msg4 = String.format(msg4, outParam.getName());
                        throw new ApplicationEnvironmentException(msg4, 0L);
                    }
                }
                catch (IOException ex) {
                    msg = "The was an error reading the file '%s'!";
                    msg = String.format(msg, fileURI);
                    throw new ApplicationFailedException(msg, null, 0L, ex);
                }
            }
            finally {
                FileTools.closeQuietly(fis);
            }
        }
    }

    private void op_writeToFile() {
        Set<ProcessModelParameter> inParams = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        for (ProcessModelParameter inParam : inParams) {
            String msg;
            FileOutputStream fos;
            File outputFile;
            URI fileURI;
            if (inParam.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                fileURI = this.getFileURI(inParam, ActivityConstants.AccessType.READ);
                outputFile = new File(fileURI);
                fos = null;
                try {
                    try {
                        String string;
                        fos = new FileOutputStream(outputFile, this.getWriteAppend(inParam));
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, this.getCharset(inParam));
                        try {
                            string = this.sessionContext.getDataContext().retrieveStringParameterValue(inParam.getName());
                        }
                        catch (InvalidDataTypeException e) {
                            String msg2 = "Could not read string from input parameter '%s'!Invalid data type '%s', expected '%s'!";
                            msg2 = String.format(msg2, new Object[]{inParam.getName(), e.getActualDataType(), e.getExpectedDataType()});
                            throw new ApplicationEnvironmentException(msg2, 1100004L);
                        }
                        catch (NoSuchParameterException noSuchParameterException) {
                            String msg3 = "Could not read string from input parameter '%s'!No such parameter!";
                            msg3 = String.format(msg3, inParam.getName());
                            throw new ApplicationEnvironmentException(msg3, -401000L);
                        }
                        osw.append(string);
                        osw = FileTools.close(osw);
                    }
                    catch (IOException ex) {
                        msg = "There was an error writing the file '%s'!";
                        msg = String.format(msg, fileURI);
                        throw new ApplicationFailedException(msg, null, 0L, ex);
                    }
                }
                catch (Throwable throwable) {
                    FileTools.closeQuietly(fos);
                    throw throwable;
                }
                FileTools.closeQuietly(fos);
                continue;
            }
            if (inParam.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED) continue;
            fileURI = this.getFileURI(inParam, ActivityConstants.AccessType.READ);
            outputFile = new File(fileURI);
            fos = null;
            try {
                try {
                    int bytesRead;
                    UDTValue udtValue;
                    fos = new FileOutputStream(outputFile, this.getWriteAppend(inParam));
                    try {
                        udtValue = this.sessionContext.getDataContext().retrieveUDTParameterValue(inParam.getName());
                    }
                    catch (Exception exception) {
                        msg = "Could not read UDT from input parameter '%s'!";
                        msg = String.format(msg, inParam.getName());
                        throw new ApplicationEnvironmentException(msg, 0L);
                    }
                    InputStream udtStream = udtValue.getValueAsStream();
                    byte[] buffer = new byte[16384];
                    while ((bytesRead = udtStream.read(buffer, 0, buffer.length)) > -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                    fos = FileTools.close(fos);
                }
                catch (IOException ex) {
                    msg = "The was an error writing the file '%s'!";
                    msg = String.format(msg, fileURI);
                    throw new ApplicationFailedException(msg, null, 0L, ex);
                }
            }
            catch (Throwable throwable) {
                FileTools.closeQuietly(fos);
                throw throwable;
            }
            FileTools.closeQuietly(fos);
        }
    }

    private URI getFileURI(ProcessModelParameter param, ActivityConstants.AccessType accessType) throws ApplicationEnvironmentException {
        URI fileURI;
        ActivityConfiguration pconf = param.getConfiguration();
        if (pconf.getString(PCONF_INOUT_FILEURI) != null) {
            fileURI = URI.create(pconf.getString(PCONF_INOUT_FILEURI));
        } else {
            String fileURIParam = pconf.getString(PCONF_INOUT_FILEURI_PARAMETER);
            try {
                fileURI = this.sessionContext.getDataContext().retrieveURIParameterValue(fileURIParam);
            }
            catch (InvalidDataTypeException e) {
                String temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                String msg = "Could not retrieve file URI from %s parameter '%s'!Invalid data type '%s', expected '%s'!";
                msg = String.format(msg, new Object[]{temp, fileURIParam, e.getActualDataType(), e.getExpectedDataType()});
                throw new ApplicationEnvironmentException(msg, 1100004L);
            }
            catch (NoSuchParameterException noSuchParameterException) {
                String temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
                String msg = "Could not retrieve file URI from %s parameter '%s'!No such parameter!";
                msg = String.format(msg, temp, fileURIParam);
                throw new ApplicationEnvironmentException(msg, -401000L);
            }
        }
        return fileURI;
    }

    private Charset getCharset(ProcessModelParameter param) throws ApplicationEnvironmentException {
        ActivityConfiguration pconf = param.getConfiguration();
        String encoding = pconf.getString(PCONF_INOUT_ENCODING);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return Charset.forName(encoding);
        }
        catch (IllegalArgumentException ex) {
            String msg = "The encoding '%s' is not available!";
            msg = String.format(msg, encoding);
            throw new ApplicationEnvironmentException(msg, 0L, ex);
        }
    }

    private boolean getWriteAppend(ProcessModelParameter param) {
        ActivityConfiguration pconf = param.getConfiguration();
        Boolean append = pconf.getBoolean(PCONF_IN_APPEND);
        if (append == null) {
            append = Boolean.FALSE;
        }
        return append;
    }
}

