/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.util.FileTools;
import de.aristaflow.adept2.util.net.OvertrustfulSSLSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public class HTTPComponent
extends ExecutionEnvironment {
    public static final String EC_NAME = "de.aristaflow.tools.net.HTTP";
    public static final String OP_GET = "Get";
    public static final String OP_POST = "Post";
    public static final String CONF_URL = "URL";
    public static final String CONF_ATTEMPTS = "Attempts";
    public static final String CONF_READ_TIMEOUT = "ReadTimeout";
    public static final String CONF_AUTO_ACCEPT_SSLCERT = "AutoAcceptSSLCert";
    public static final String CONF_RETURN_ERROR_RESPONSE = "ReturnErrorResponse";
    public static final String PARAM_OUT_RESPONSE = "response";
    public static final String PARAM_OUT_RESPONSE_CODE = "responseCode";

    public HTTPComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        ActivityConfiguration atc = this.activityInstance.getConfiguration();
        String opName = this.activityInstance.getOperationName();
        long attempts = atc.getInteger(CONF_ATTEMPTS) == null ? 1L : atc.getInteger(CONF_ATTEMPTS);
        while (attempts > 0L) {
            try {
                if (opName.equals(OP_GET)) {
                    this.op_get();
                    break;
                }
                if (opName.equals(OP_POST)) {
                    this.op_post();
                    break;
                }
                String msg = "Unknown operation encountered: " + opName;
                throw new ApplicationEnvironmentException(msg, 0L);
            }
            catch (MalformedURLException ex) {
                String msg = "The provided URL doesn't seem to be valid!";
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
            catch (IOException ex) {
                if (--attempts > 0L) continue;
                String msg = "An error occured while downloading the resource!";
                throw new ApplicationFailedException(msg, null, 0L, ex);
            }
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    private void op_get() throws MalformedURLException, IOException {
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        String urlString = this.getDualInputParameterValue(CONF_URL, ProcessConstants.AdeptDataType.STRING, String.class);
        Boolean autoAcceptSSLCert = conf.getBoolean(CONF_AUTO_ACCEPT_SSLCERT);
        if (autoAcceptSSLCert == null) {
            autoAcceptSSLCert = false;
        }
        HttpURLConnection urlConn = null;
        try {
            if (this.activityInstance.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
                URL url = new URL(urlString);
                urlString = url.getQuery() == null ? String.valueOf(urlString) + "?" + this.createQuery() : String.valueOf(urlString) + "&" + this.createQuery();
            }
            urlConn = (HttpURLConnection)new URL(urlString).openConnection();
            if (autoAcceptSSLCert.booleanValue() && urlConn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConn).setSSLSocketFactory(OvertrustfulSSLSocketFactory.getDefault());
            }
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("GET");
            this.readResponse(urlConn);
            urlConn.disconnect();
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    private void op_post() throws MalformedURLException, IOException {
        ActivityConfiguration atc = this.activityInstance.getConfiguration();
        String urlString = this.getDualInputParameterValue(CONF_URL, ProcessConstants.AdeptDataType.STRING, String.class);
        Boolean autoAcceptSSLCert = atc.getBoolean(CONF_AUTO_ACCEPT_SSLCERT);
        if (autoAcceptSSLCert == null) {
            autoAcceptSSLCert = false;
        }
        HttpURLConnection urlConn = null;
        FilterOutputStream out = null;
        try {
            urlConn = (HttpURLConnection)new URL(urlString).openConnection();
            if (autoAcceptSSLCert.booleanValue() && urlConn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConn).setSSLSocketFactory(OvertrustfulSSLSocketFactory.getDefault());
            }
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String content = this.createQuery();
            out = new DataOutputStream(urlConn.getOutputStream());
            ((DataOutputStream)out).writeBytes(content);
            ((DataOutputStream)out).flush();
            out.close();
            this.readResponse(urlConn);
            urlConn.disconnect();
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private String createQuery() {
        StringBuilder query = new StringBuilder();
        DataContext dataContext = this.sessionContext.getDataContext();
        Set<ProcessModelParameter> inParams = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        boolean first = true;
        for (ProcessModelParameter inParam : inParams) {
            String msg;
            try {
                String name = inParam.getName();
                String value = dataContext.retrieveStringParameterValue(inParam.getName());
                name = URLEncoder.encode(name, "UTF-8");
                value = URLEncoder.encode(value, "UTF-8");
                if (first) {
                    first = false;
                } else {
                    query.append("&");
                }
                query.append(name).append("=").append(value);
            }
            catch (UnsupportedEncodingException ex) {
                msg = "Encoding not supported: %s!";
                msg = String.format(msg, "UTF-8");
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
            catch (InvalidDataTypeException ex) {
                msg = "Input parameter '%s' does not have expected data type: %s!";
                msg = String.format(msg, new Object[]{inParam.getName(), ProcessConstants.AdeptDataType.STRING});
                throw new ApplicationEnvironmentException(msg, -401000L, ex);
            }
            catch (NoSuchParameterException ex) {
                msg = "Could not read string from input parameter '%s'! No such parameter!";
                msg = String.format(msg, inParam.getName());
                throw new ApplicationEnvironmentException(msg, -401000L, ex);
            }
        }
        return query.toString();
    }

    private void readResponse(HttpURLConnection urlConn) throws IOException {
        ActivityConfiguration conf = this.activityInstance.getConfiguration();
        DataContext dataContext = this.sessionContext.getDataContext();
        ProcessModelParameter responseParam = this.activityInstance.getParameter(PARAM_OUT_RESPONSE, ActivityConstants.AccessType.WRITE);
        ProcessModelParameter responseCodeParam = this.activityInstance.getParameter(PARAM_OUT_RESPONSE_CODE, ActivityConstants.AccessType.WRITE);
        InputStream response = null;
        try {
            try {
                Long readTimeout;
                Boolean returnErrorResponse;
                if (responseCodeParam != null) {
                    dataContext.storeIntegerParameterValue(PARAM_OUT_RESPONSE_CODE, urlConn.getResponseCode());
                }
                if ((returnErrorResponse = this.activityInstance.getConfiguration().getBoolean(CONF_RETURN_ERROR_RESPONSE)) == null) {
                    returnErrorResponse = Boolean.FALSE;
                }
                readTimeout = (readTimeout = conf.getInteger(CONF_READ_TIMEOUT)) == null ? Long.valueOf(600000L) : Long.valueOf(readTimeout * 1000L);
                urlConn.setReadTimeout(readTimeout.intValue());
                if (returnErrorResponse.booleanValue()) {
                    try {
                        response = urlConn.getInputStream();
                    }
                    catch (IOException ex) {
                        InputStream errorStream = urlConn.getErrorStream();
                        if (errorStream == null) {
                            throw ex;
                        }
                        response = errorStream;
                    }
                } else {
                    response = urlConn.getInputStream();
                }
                if (responseParam.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    int bytesRead;
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    byte[] buffer = new byte[16384];
                    while ((bytesRead = response.read(buffer)) > -1) {
                        data.write(buffer, 0, bytesRead);
                    }
                    ADEPT2UDTValue udtValue = new ADEPT2UDTValue(responseParam.getUDTName(), data.toByteArray());
                    dataContext.storeUDTParameterValue(PARAM_OUT_RESPONSE, udtValue);
                } else if (responseParam.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                    StringBuilder responseString;
                    InputStreamReader reader = null;
                    try {
                        int charsRead;
                        reader = new InputStreamReader(response, "UTF-8");
                        responseString = new StringBuilder();
                        char[] buffer = new char[8192];
                        while ((charsRead = reader.read(buffer)) > -1) {
                            responseString.append(buffer, 0, charsRead);
                        }
                        ((Reader)reader).close();
                    }
                    finally {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    dataContext.storeStringParameterValue(PARAM_OUT_RESPONSE, responseString.toString());
                } else {
                    String msg = "The output parameter '%s' must either have one of the data types %s and %s! It has the data type %s.";
                    msg = String.format(msg, new Object[]{PARAM_OUT_RESPONSE, ProcessConstants.AdeptDataType.USERDEFINED, ProcessConstants.AdeptDataType.STRING, responseParam.getDataType()});
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
                response = FileTools.close(response);
            }
            catch (InvalidDataTypeException ex) {
                String msg = "The output parameter '%s' does not have its expected data type '%s'.";
                msg = String.format(msg, new Object[]{responseParam.getName(), ex.getExpectedDataType()});
                throw new ApplicationEnvironmentException(msg, -401000L, ex);
            }
            catch (NoSuchParameterException ex) {
                String msg = "Could not write to output parameter '%s'! No such parameter!";
                msg = String.format(msg, responseParam.getName());
                throw new ApplicationEnvironmentException(msg, -401000L, ex);
            }
        }
        catch (Throwable throwable) {
            FileTools.closeQuietly(response);
            throw throwable;
        }
        FileTools.closeQuietly(response);
    }
}

