/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import de.aristaflow.adept2.extensions.tools.environments.AbstractFileTransferComponent;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.OutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SFTPComponent
extends AbstractFileTransferComponent {
    public static final String EC_NAME = "de.aristaflow.tools.net.SFTP";
    private ChannelSftp sftp;

    public SFTPComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    protected void connect(String remoteHost, int remotePort, String userName, String password) throws Exception {
        JSch jsch = new JSch();
        Session session = jsch.getSession(userName, remoteHost, remotePort);
        session.setPassword(password);
        session.setUserInfo(new UserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return null;
            }

            public boolean promptPassphrase(String arg0) {
                return false;
            }

            public boolean promptPassword(String arg0) {
                return false;
            }

            public boolean promptYesNo(String arg0) {
                return true;
            }

            public void showMessage(String arg0) {
            }
        });
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        this.sftp = (ChannelSftp)channel;
    }

    @Override
    protected void disconnect() throws Exception {
        if (this.sftp != null) {
            this.sftp.exit();
            this.sftp = null;
        }
    }

    @Override
    protected OutputStream openRemoteTarget(String remoteFile) throws Exception {
        return this.sftp.put(remoteFile);
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(null, str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.passwordField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passwd = this.passwordField.getText();
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            int i = 0;
            while (i < prompt.length) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
                ++i;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, String.valueOf(destination) + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                int i2 = 0;
                while (i2 < prompt.length) {
                    response[i2] = texts[i2].getText();
                    ++i2;
                }
                return response;
            }
            return null;
        }
    }
}

