/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.LocaleTools;
import de.aristaflow.adept2.util.StringTools;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Set;

public class StringFormatComponent
extends AbstractStringFormatComponent {
    public static final String EC_NAME = "de.aristaflow.tools.StringFormat";
    public static final String PCONF_OUT_FORMAT_STRING = "FormatString";
    public static final String PCONF_OUT_ENCODING = "Encoding";

    public StringFormatComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
    }

    @Override
    public void run() {
        ActivityConfiguration atc = this.activityInstance.getConfiguration();
        Locale locale = LocaleTools.parseLocaleString(atc.getString("FormatLocale"));
        if (locale == null) {
            locale = Locale.getDefault();
        }
        AbstractStringFormatComponent.FormatStyle formatStyle = null;
        if (atc.getString("FormatStyle") != null) {
            formatStyle = AbstractStringFormatComponent.FormatStyle.fromToken(atc.getString("FormatStyle"));
        }
        if (formatStyle == null) {
            formatStyle = AbstractStringFormatComponent.FormatStyle.PRINTF_FORMATTER;
        }
        Object[] formatArguments = this.getFormatArguments();
        Set<ProcessModelParameter> outParams = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        block10: for (ProcessModelParameter outParam : outParams) {
            String msg;
            ProcessModelParameter inParam = this.activityInstance.getParameter(outParam.getName(), ActivityConstants.AccessType.READ);
            try {
                String formatString = null;
                if (inParam != null && inParam.getDataType() == ProcessConstants.AdeptDataType.STRING) {
                    formatString = this.sessionContext.getDataContext().retrieveStringParameterValue(inParam.getName());
                }
                if (formatString == null) {
                    formatString = outParam.getConfiguration().getString(PCONF_OUT_FORMAT_STRING);
                }
                if (formatString == null) continue;
                String formattedString = StringFormatComponent.format(formatStyle, formatString, locale, formatArguments);
                switch (outParam.getDataType()) {
                    case STRING: {
                        this.sessionContext.getDataContext().storeStringParameterValue(outParam.getName(), formattedString);
                        continue block10;
                    }
                    case USERDEFINED: {
                        String encoding = outParam.getConfiguration().getString(PCONF_OUT_ENCODING);
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        try {
                            byte[] encodedString = StringTools.toByteArray(formattedString, encoding);
                            ADEPT2UDTValue udtValue = new ADEPT2UDTValue(outParam.getUDTName(), encodedString);
                            this.sessionContext.getDataContext().storeUDTParameterValue(outParam.getName(), udtValue);
                            continue block10;
                        }
                        catch (UnsupportedEncodingException ex) {
                            String msg2 = "The encoding at output parameter '%s' is not supported.";
                            msg2 = String.format(msg2, outParam.getName());
                            throw new ApplicationEnvironmentException(msg2, 0L, ex);
                        }
                    }
                    default: {
                        String msg3 = "Output parameters must either be STRING or USERDEFINED!";
                        throw new ApplicationEnvironmentException(msg3, 0L);
                    }
                }
            }
            catch (InvalidDataTypeException ex) {
                msg = "A parameter in the provided data context did not have the expected data type!";
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
            catch (NoSuchParameterException ex) {
                msg = "An expected parameter was not found in the provided data context!";
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
            catch (AbstractStringFormatComponent.FormatException ex) {
                msg = "The parameterised string could not be successfully formatted!";
                throw new ApplicationFailedException(msg, null, 0L, ex);
            }
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }
}

